/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.Translate;

public class LoaderFormatter
extends ResultsFormatter {
    String tableName = null;

    public LoaderFormatter() {
        super("LOADER", Translate.translate("Loader File"), "ldr");
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void start() throws IOException {
        this.write("LOAD DATA" + this.getLineTerminator());
        this.write("INFILE *" + this.getLineTerminator());
        this.write("Truncate" + this.getLineTerminator());
        this.write("INTO TABLE \"" + this.tableName + "\"" + this.getLineTerminator());
        this.write("FIELDS TERMINATED BY ','" + this.getLineTerminator());
        this.write("TRAILING NULLCOLS" + this.getLineTerminator());
        this.write("(");
        for (int i = 1; i < this._colNames.size(); ++i) {
            if (i == this._colNames.size() - 1) {
                this.write(((String)this._colNames.get(i)).toString() + ")" + this.getLineTerminator());
                continue;
            }
            this.write(((String)this._colNames.get(i)).toString() + "," + this.getLineTerminator());
        }
        this.write("begindata" + this.getLineTerminator());
    }

    public void startRow() throws IOException {
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        String string = "";
        if (n == 0) {
            return;
        }
        if (object != null && n == 1) {
            string = "\"" + this.cleanString(this.getValue(object).toString()) + "\"";
        } else if (object == null && n == 1) {
            string = "\"\"";
        } else if (object != null && n > 1) {
            string = ",\"" + this.cleanString(this.getValue(object).toString()) + "\"";
        } else if (object == null && n > 1) {
            string = ",\"\"";
        }
        this.write(string);
    }

    public String cleanString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(string.charAt(i));
            string2 = string2 + c;
        }
        return string2;
    }

    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    public void end() throws IOException {
    }

    public Boolean getPromptForTable() {
        return true;
    }
}

