/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.Translate;

public class HTMLFormatter
extends ResultsFormatter {
    private boolean _result = true;

    public HTMLFormatter() {
        super("HTML", Translate.translate("HTML File"), "htm");
    }

    public void start() throws IOException {
        this.write("<html><body><table>" + this.getLineTerminator());
        for (int i = 1; i < this._colNames.size(); ++i) {
            if (i > 0 && i < this._colNames.size() - 1) {
                this.write("\t<th>" + (String)this._colNames.get(i) + "</th>" + this.getLineTerminator());
                continue;
            }
            this.write("\t<th>" + (String)this._colNames.get(i) + "</th>" + this.getLineTerminator());
        }
        this.write(this.getLineTerminator());
    }

    public void startRow() throws IOException {
        this.write("\t<tr>" + this.getLineTerminator());
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        if (n == 0 && this._result) {
            return;
        }
        this.write("<td>");
        if (object != null) {
            this.write(this.getValue(object).toString());
        }
        this.write("</td>" + this.getLineTerminator());
    }

    public void endRow() throws IOException {
        this.write("\t</tr>" + this.getLineTerminator());
    }

    public void end() throws IOException {
        this.write("</table></body></html>");
    }

    public void setResult(boolean bl) {
        this._result = bl;
    }

    public void setTableName(String string) {
    }
}

