/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.format.ExcelFormatter;
import oracle.dbtools.raptor.format.HTMLFormatter;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.format.LoaderFormatter;
import oracle.dbtools.raptor.format.TxtFormatter;
import oracle.dbtools.raptor.format.XMLFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatRegistry {
    private static List<IResultFormatter> _registry = new ArrayList<IResultFormatter>();

    public static synchronized void registerFormater(IResultFormatter iResultFormatter) {
        _registry.add(iResultFormatter);
    }

    public static synchronized void unregisterFormater(IResultFormatter iResultFormatter) {
        _registry.remove(iResultFormatter);
    }

    public static synchronized IResultFormatter getFormatter(String string) {
        for (IResultFormatter iResultFormatter : _registry) {
            if (!iResultFormatter.getType().equalsIgnoreCase(string)) continue;
            return iResultFormatter;
        }
        return null;
    }

    public static synchronized List<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IResultFormatter iResultFormatter : _registry) {
            arrayList.add(iResultFormatter.getType());
        }
        return arrayList;
    }

    static {
        FormatRegistry.registerFormater(new TxtFormatter());
        FormatRegistry.registerFormater(new CSVFormatter());
        FormatRegistry.registerFormater(new InsertFormatter());
        FormatRegistry.registerFormater(new LoaderFormatter());
        FormatRegistry.registerFormater(new XMLFormatter());
        FormatRegistry.registerFormater(new HTMLFormatter());
        FormatRegistry.registerFormater(new ExcelFormatter());
    }
}

