/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.awt.Font;
import java.io.IOException;
import java.math.BigDecimal;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelFormatter
extends ResultsFormatter {
    private HSSFWorkbook _wb;
    private HSSFSheet _ws;
    private long _rownum;
    private HSSFRow _currRow;
    private HSSFCell _currCell;
    private Font _font;
    private HSSFCellStyle _rightAlign;
    private short _cell;

    public ExcelFormatter() {
        super("XLS", Translate.translate("XLS"), "xls");
    }

    public void start() throws IOException {
        this._wb = new HSSFWorkbook();
        this._ws = this._wb.createSheet();
        this._rightAlign = this._wb.createCellStyle();
        this._rightAlign.setAlignment((short)3);
        HSSFFont hSSFFont = this._wb.createFont();
        hSSFFont.setFontName(Font.decode(null).getName());
        this._rightAlign.setFont(hSSFFont);
        this._currRow = null;
        this._currCell = null;
        this._wb.setSheetName(0, "Export Worksheet");
        this._rownum = 0L;
        short s = Short.valueOf("" + this._rownum);
        this._currRow = this._ws.createRow((int)s);
        short s2 = 0;
        boolean bl = false;
        for (String string : this.getColumns()) {
            if (bl) {
                this._currCell = this._currRow.createCell(s2);
                this._currCell.setEncoding((short)1);
                this._currCell.setCellValue(string);
                s2 = (short)(s2 + 1);
            }
            bl = true;
        }
        this._currCell = this._currRow.createCell(s2);
        this._currCell.setCellValue(" ");
        this._ws.createFreezePane(0, 1, 0, 1);
    }

    public void startRow() throws IOException {
        if (this._rownum > 64000L) {
            this._ws = this._wb.createSheet();
            this._rownum = 0L;
        }
        ++this._rownum;
        int n = Integer.valueOf(new String("" + this._rownum));
        this._currRow = this._ws.createRow(n);
    }

    public void printColumn(Object object, int n) throws IOException {
    }

    public void endRow() throws IOException {
        this._cell = (short)(this._cell + 1);
        this._currCell = this._currRow.createCell(this._cell);
        this._currCell.setCellValue(" ");
    }

    public void end() throws IOException {
        if (this.getTable() != null && this.getTable().getModel() != null && this.getTable().getModel() instanceof ResultSetTableModel) {
            this._ws = this._wb.getSheetAt(0);
            this._ws.setFitToPage(true);
            this._ws = this._wb.createSheet("SQL");
            this._currRow = this._ws.createRow(1);
            this._currCell = this._currRow.createCell((short)1);
            String string = ((ResultSetTableModel)this.getTable().getModel()).getSQL();
            this._currCell.setCellValue(string);
        }
        this._wb.write(this.getOutputStream());
        this.getOutputStream().close();
    }

    public void setTableName(String string) {
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        this._cell = Short.valueOf(n2 - 1 + "");
        this._currCell = this._currRow.createCell(this._cell);
        this._currCell.setEncoding((short)1);
        int n3 = 0;
        if (n2 > 0) {
            try {
                n3 = this.getDataType(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            n3 = 2;
        }
        switch (n3) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                this._currCell.setCellStyle(this._rightAlign);
                BigDecimal bigDecimal = null;
                if (object == null) break;
                try {
                    bigDecimal = new BigDecimal(object.toString());
                }
                catch (Exception exception) {
                    bigDecimal = new BigDecimal(object.toString().replace(",", "."));
                }
                NLSUtils.formatBigDecimal(this.getConnection(), bigDecimal);
                this._currCell.setCellValue(bigDecimal.doubleValue());
                break;
            }
            case 12: {
                if (object == null) break;
                this._currCell.setCellValue(object.toString());
                break;
            }
            default: {
                if (object == null) break;
                this._currCell.setCellValue(object.toString());
            }
        }
    }
}

