/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.Translate;

public class CSVFormatter
extends ResultsFormatter {
    private String delimiter = DBConfig.getInstance().getString("EXPORT_DELIMITER");

    public CSVFormatter() {
        super("CSV", Translate.translate("Comma Seperated File"), "csv");
    }

    public void start() throws IOException {
        for (int i = 1; i < this._colNames.size(); ++i) {
            if (i > 0 && i < this._colNames.size() - 1) {
                this.write("\"" + (String)this._colNames.get(i) + "\"" + this.delimiter);
                continue;
            }
            this.write("\"" + (String)this._colNames.get(i) + "\"");
        }
        this.write("\n");
    }

    public void startRow() throws IOException {
    }

    public void printColumn(Object object, int n, int n2) throws IOException {
        this.delimiter = DBConfig.getInstance().getString("EXPORT_DELIMITER");
        String string = "";
        string = object != null ? this.delimiter + "\"" + this.getValue(object).toString().replaceAll("\"", "\"\"") + "\"" : this.delimiter + "\"\"";
        if (n == 0) {
            return;
        }
        if (n == 1) {
            this.write("\"" + string.substring(2));
        } else {
            this.write(string);
        }
    }

    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    public void end() throws IOException {
    }

    public void setTableName(String string) {
    }
}

