/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.data;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.scriptrunner.CommandListener;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdeveloper.cm.CMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMover
extends CommandListener {
    private Connection _fromConn;
    private Connection _toConn;
    private BufferedOutputStream _out;

    public DataMover() {
    }

    public DataMover(String string, String string2, List<DBObject> list) {
        try {
            this._fromConn = Connections.getInstance().getConnection(string);
            this._toConn = Connections.getInstance().getConnection(string2);
        }
        catch (CMException cMException) {
            // empty catch block
        }
    }

    public DataMover(Connection connection, Connection connection2, ArrayList<DBObject> arrayList) {
        this._fromConn = connection;
        this._toConn = connection2;
    }

    public DataMover(Connection connection, Connection connection2) {
        this._fromConn = connection;
        this._toConn = connection2;
    }

    private synchronized void feedback(String string) {
        try {
            if (string != null) {
                this._out.write(string.getBytes("UTF8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void move(DBObject dBObject, boolean bl) {
        long l = System.currentTimeMillis();
        String string = "select * from " + dBObject.getObjectName();
        String string2 = "insert into " + dBObject.getObjectName();
        try {
            ResultSet resultSet = this._fromConn.prepareStatement(string).executeQuery();
            resultSet.setFetchSize(100);
            int n = resultSet.getMetaData().getColumnCount();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i <= n; ++i) {
                if (i != 1) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("#");
                stringBuilder.append(resultSet.getMetaData().getColumnName(i));
            }
            string2 = string2 + "(" + stringBuilder.toString().replaceAll("#", "") + ")" + " values (" + stringBuilder.toString().replaceAll("#", ":") + ")";
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)this._toConn.prepareCall(string2);
            while (resultSet.next()) {
                for (int i = 1; i <= n; ++i) {
                    oracleCallableStatement.setObjectAtName(resultSet.getMetaData().getColumnName(i), resultSet.getObject(i));
                }
                oracleCallableStatement.addBatch();
            }
            int[] nArray = oracleCallableStatement.executeBatch();
            if (bl) {
                this.feedback("inserted " + nArray.length + " rows into " + dBObject.getObjectName() + " in " + (System.currentTimeMillis() - l) + "ms\n");
            }
            this._toConn.commit();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void test(BufferedOutputStream bufferedOutputStream, Connection connection, Connection connection2, HashMap<String, String> hashMap) throws Exception {
        this._out = bufferedOutputStream;
        DDLFormat dDLFormat = DDLGenerator.getInstance().getFormating();
        DDLFormat dDLFormat2 = new DDLFormat();
        dDLFormat2.setDrop(true);
        dDLFormat2.setSchema(false);
        dDLFormat2.setSegments(false);
        dDLFormat2.setTerminiator(true);
        DDLGenerator.getInstance().setFormating(dDLFormat2);
        StringBuilder stringBuilder = new StringBuilder("select user ,object_name,object_type from user_objects ");
        boolean bl = false;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (hashMap.get("FILTER") != null) {
            if (bl) {
                stringBuilder.append(" and object_name like :FILTER");
            } else {
                stringBuilder.append(" where object_name like :FILTER");
                bl = true;
            }
        }
        if (hashMap.get("TYPES") != null) {
            if (bl) {
                stringBuilder.append(" and instr(:TYPES,upper(object_name)) > 0");
            } else {
                stringBuilder.append(" where instr(:TYPES,upper(object_name)) > 0");
                bl = true;
            }
        }
        ResultSet resultSet = DBUtil.getInstance().executeQuery(connection, stringBuilder.toString(), hashMap);
        while (resultSet.next()) {
            arrayList.add(new DBObject(DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectioName(connection), null, resultSet.getString(1), resultSet.getString(3)), resultSet.getString(2))));
        }
        resultSet.getStatement().close();
        resultSet.close();
        this._fromConn = connection;
        this._toConn = connection2;
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
        DDLGenerator.getInstance().setFormating(dDLFormat);
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    @Override
    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
    }

    @Override
    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, SQLCommand sQLCommand) {
        try {
            if (sQLCommand.getSql().trim().toLowerCase().startsWith("copyschema")) {
                String[] stringArray = sQLCommand.getSql().split("\\W");
                Connection connection2 = Connections.getInstance().getConnection(stringArray[3]);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 3; i < stringArray.length; i += 2) {
                    hashMap.put(stringArray[i].toUpperCase(), stringArray[i + 1]);
                }
                this.test(scriptRunnerContext.getOutputStream(), connection, connection2, hashMap);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

