/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.FilePanel;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.export.AdvFilterPanel;
import oracle.dbtools.raptor.export.DataPanel;
import oracle.dbtools.raptor.export.ExportOptions;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBIcons;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.javatools.db.DBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox doTypes = new JCheckBox();
    private JCheckBox doTriggers = new JCheckBox();
    private JCheckBox doFunction = new JCheckBox();
    private JCheckBox doPackSpec = new JCheckBox();
    private JCheckBox doPackBody = new JCheckBox();
    private JCheckBox doProcedure = new JCheckBox();
    private JCheckBox doView = new JCheckBox();
    private JCheckBox doSequence = new JCheckBox();
    private JCheckBox doConstraints = new JCheckBox();
    private JCheckBox doData = new JCheckBox();
    private JCheckBox doIndex = new JCheckBox();
    private JCheckBox doTables = new JCheckBox();
    private JCheckBox doTabDeps = new JCheckBox();
    private JCheckBox doDbLink = new JCheckBox();
    private JCheckBox doMatView = new JCheckBox();
    private JCheckBox doSynonymn = new JCheckBox();
    private JCheckBox doMatViewLog = new JCheckBox();
    private JCheckBox checkAll = new JCheckBox();
    private JLabel checkLabel;
    JLabel lab = new JLabel();
    private JLabel trigLabel = new JLabel();
    private JLabel viewLabel = new JLabel();
    private JLabel FuncLabel = new JLabel();
    private JLabel psLabel = new JLabel();
    private JLabel pbLabel = new JLabel();
    private JLabel procLabel = new JLabel();
    private JLabel typeLabel = new JLabel();
    private JLabel seqLabel = new JLabel();
    private JLabel tabLabel = new JLabel();
    private JLabel tabDepLabel = new JLabel();
    private JLabel IndLabel = new JLabel();
    private JLabel ConsLabel = new JLabel();
    private JLabel DataLabel = new JLabel();
    private JLabel mvLabel = new JLabel();
    private JLabel synLabel = new JLabel();
    private JLabel dbLinkLabel = new JLabel();
    private JLabel MatViewLogLabel = new JLabel();
    JPanel depPan = new JPanel();
    private static ExpPanel INSTANCE;
    private FilePanel _file;
    private String _EOL = System.getProperty("line.separator");
    private OracleConnectionComboBox connSelector = new OracleConnectionComboBox();
    public static final String EXPORT_NAME = "raptor.export";
    public static final int EXPORT_ACTION;
    private boolean _cancel = false;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private ExportOptions _options;
    private DataPanel dp = new DataPanel();
    private AdvFilterPanel _advfilter;
    private HashMap<URL, String> _dataList = new HashMap();
    private ArrayList<URL> _advList = new ArrayList();

    public ExportOptions getOptions() {
        return this._options;
    }

    public void resetDataList() {
        this._dataList = new HashMap();
    }

    public HashMap<URL, String> getDataList() {
        return this._dataList;
    }

    public void resetAdvList() {
        this._advList = new ArrayList();
    }

    public void setAdvList(ArrayList<URL> arrayList) {
        this._advList = arrayList;
    }

    public void addToAdvList(ArrayList<URL> arrayList) {
        for (URL uRL : arrayList) {
            if (this._advList.contains(uRL)) continue;
            this._advList.add(uRL);
        }
    }

    public void remFromAdvList(URL uRL) {
        if (this._advList.contains(uRL)) {
            this._advList.remove(uRL);
        }
    }

    public ArrayList<URL> getAdvList() {
        return this._advList;
    }

    public ArrayList<URL> getAdvListType(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : this._advList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }

    public ExpPanel() {
        INSTANCE = this;
        this.initialize();
    }

    private JPanel getOptPanel() {
        JPanel jPanel = new JPanel();
        UIUtils.makeTitledBorder(jPanel, "Objects");
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.checkLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.checkAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        jPanel.add((Component)this.tabLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doTables, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.depPan.setLayout(new GridBagLayout());
        this.depPan.add((Component)this.doTabDeps, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.depPan.add((Component)this.tabDepLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.depPan, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.viewLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doView, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.IndLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doIndex, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.psLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doPackSpec, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.pbLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doPackBody, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.procLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doProcedure, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.FuncLabel, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doFunction, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.trigLabel, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doTriggers, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.typeLabel, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doTypes, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.seqLabel, new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doSequence, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.mvLabel, new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doMatView, new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.MatViewLogLabel, new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doMatViewLog, new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.synLabel, new GridBagConstraints(1, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doSynonymn, new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.dbLinkLabel, new GridBagConstraints(1, 15, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doDbLink, new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ConsLabel, new GridBagConstraints(1, 16, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doConstraints, new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.DataLabel, new GridBagConstraints(1, 17, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.doData, new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void initialize() {
        this.connSelector.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ExpPanel.this.connSelector.getCurrentDatabase();
                    ExpPanel.this.tabbedPane.setSelectedIndex(0);
                    ExpPanel.this.resetDataList();
                    ExpPanel.this.resetAdvList();
                }
                catch (DBException dBException) {
                    ExpPanel.this.connSelector.getJComboBox().setSelectedIndex(-1);
                }
            }
        });
        this.doView.setSelected(true);
        this.doTypes.setSelected(true);
        this.doTriggers.setSelected(true);
        this.doTables.setSelected(true);
        this.doTables.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ExpPanel.this.doTables.isSelected()) {
                    ExpPanel.this.doTabDeps.setSelected(false);
                }
            }
        });
        this.doTabDeps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ExpPanel.this.doTabDeps.isSelected()) {
                    ExpPanel.this.doTables.setSelected(true);
                }
            }
        });
        this.doTabDeps.setSelected(false);
        this.doSequence.setSelected(true);
        this.doProcedure.setSelected(true);
        this.doPackBody.setSelected(true);
        this.doPackSpec.setSelected(true);
        this.doMatView.setSelected(true);
        this.doIndex.setSelected(true);
        this.doFunction.setSelected(true);
        this.doDbLink.setSelected(true);
        this.doData.setSelected(true);
        this.doConstraints.setSelected(true);
        this.doSynonymn.setSelected(true);
        this.doMatViewLog.setSelected(true);
        this.checkAll.setSelected(true);
        this.checkAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpPanel.this.doView.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doTypes.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doTriggers.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doTables.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doSequence.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doProcedure.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doPackBody.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doPackSpec.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doMatView.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doIndex.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doFunction.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doDbLink.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doData.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doConstraints.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doSynonymn.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doMatViewLog.setSelected(ExpPanel.this.checkAll.isSelected());
                ExpPanel.this.doTabDeps.setSelected(false);
            }
        });
        String string = "<html><u><b>Export Object Types</b></u>";
        this.checkLabel = new JLabel(string);
        this.MatViewLogLabel.setText("Materialized View Logs");
        this.dbLinkLabel.setText("Database Link");
        this.synLabel.setText("Synonymn");
        this.mvLabel.setText("Materialized View");
        this.DataLabel.setText("Data");
        this.ConsLabel.setText("Constraints");
        this.IndLabel.setText("Indexes");
        this.typeLabel.setText("Types");
        this.tabLabel.setText("Tables");
        this.tabDepLabel.setText("Dependencies");
        this.procLabel.setText("Procedure");
        this.seqLabel.setText("Sequence");
        this.pbLabel.setText("Package Body");
        this.psLabel.setText("Package Spec");
        this.FuncLabel.setText("Functions");
        this.viewLabel.setText("Views");
        this.trigLabel.setText("Triggers");
        this.lab.setText("Selecting an object type will export all objects of that type unless you apply a filter.");
        this.setLayout(new GridBagLayout());
        this._file = new FilePanel(this);
        this.add((Component)new JLabel("File:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._file, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("Connection:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.connSelector.getJComboBox(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this._options = new ExportOptions();
        JPanel jPanel = this.getOptPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        jPanel2.add((Component)this._options, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 50, 5, 10), 0, 0));
        jPanel2.add((Component)this.lab, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._advfilter = new AdvFilterPanel();
        this._advfilter.setExpPanel(this);
        this.dp.setExpPanel(this);
        this.dp.setPreferredSize(new Dimension(700, 500));
        this.tabbedPane.addTab("Export", null, jPanel2, "Identify object types to export.");
        this.tabbedPane.setMnemonicAt(0, 49);
        this.tabbedPane.addTab("Filter Objects", null, this._advfilter, "Identify the objects to export.");
        this.tabbedPane.setMnemonicAt(1, 50);
        this.tabbedPane.addTab("Filter Data", null, this.dp, "Identify the table data to export.");
        this.tabbedPane.setMnemonicAt(2, 51);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if ((ExpPanel.this.connSelector.getCurrentConnectionName() == null || ExpPanel.this.connSelector.getCurrentConnectionName().equals("")) && n != 0) {
                    ExpPanel.this.tabbedPane.setSelectedIndex(0);
                    MessageDialog.error((Component)INSTANCE, (Object)"No Connection is selected option not available.", (String)"Connection Error", (String)"f1_exportConnection_html");
                    return;
                }
                if (ExpPanel.this.getTypes().size() == 0 && n != 0) {
                    ExpPanel.this.tabbedPane.setSelectedIndex(0);
                    MessageDialog.error((Component)INSTANCE, (Object)"No Object types selected for export, nothing to filter.", (String)"Filter Error", (String)"f1_nullfilterlist_html");
                    return;
                }
                if (n == 2 && !ExpPanel.this.doData.isSelected()) {
                    ExpPanel.this.tabbedPane.setSelectedIndex(0);
                    MessageDialog.error((Component)INSTANCE, (Object)"Data not selected for export nothing to filter.", (String)"Filter Error", (String)"f1_nullfilterlist_html");
                    return;
                }
                if (n == 1 && ExpPanel.this.doData.isSelected() && ExpPanel.this.getTypes().size() == 1) {
                    ExpPanel.this.tabbedPane.setSelectedIndex(0);
                    MessageDialog.error((Component)INSTANCE, (Object)"No object types selected for export nothing to filter.", (String)"Filter Error", (String)"f1_nullfilterlist_html");
                    return;
                }
                if (n != 0) {
                    String string = ExpPanel.this.connSelector.getCurrentConnectionName();
                    ExpPanel.this._advfilter.setConn(string);
                    ExpPanel.this._advfilter.setTypeList();
                    ExpPanel.this._advfilter.initialize();
                    ExpPanel.this.dp.setConn(string);
                    ExpPanel.this.dp.initialize();
                    if (ExpPanel.this._dataList.size() > 0) {
                        ExpPanel.this.dp.setList(ExpPanel.this._dataList);
                    }
                }
            }
        });
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 2, 2, 0, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)EXPORT_ACTION, null, (String)Translate.translate("Export DDL (and Data)"), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(69), (ArrayResourceBundle)DBIcons.getInstance(), (int)10, null, (boolean)true);
        ideAction.setEnabled(true);
        ideAction.addController(ExportController.INSTANCE);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static ExpPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExpPanel();
        }
        return INSTANCE;
    }

    public void launch() {
        this.tabbedPane.setSelectedIndex(0);
        this.resetDataList();
        this.resetAdvList();
        this._options.setDefault();
        this.doView.setSelected(true);
        this.doTypes.setSelected(true);
        this.doTriggers.setSelected(true);
        this.doTables.setSelected(true);
        this.doTabDeps.setSelected(false);
        this.doSequence.setSelected(true);
        this.doProcedure.setSelected(true);
        this.doPackBody.setSelected(true);
        this.doPackSpec.setSelected(true);
        this.doMatView.setSelected(true);
        this.doIndex.setSelected(true);
        this.doFunction.setSelected(true);
        this.doDbLink.setSelected(true);
        this.doData.setSelected(true);
        this.doConstraints.setSelected(true);
        this.doSynonymn.setSelected(true);
        this.doMatViewLog.setSelected(true);
        this.checkAll.setSelected(true);
        this.connSelector.getJComboBox().setSelectedIndex(-1);
        this._file.setFileName(null);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exportobjects_html");
        UIUtils.showPanelAsDialog((JPanel)this, "Export", (ActionListener)this, true);
    }

    private LinkedHashMap<String, String> getTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.doDbLink.isSelected()) {
            linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        }
        if (this.doSequence.isSelected()) {
            linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        }
        if (this.doTables.isSelected()) {
            linkedHashMap.put("TABLE", "Oracle#TABLE");
        }
        if (this.doData.isSelected()) {
            linkedHashMap.put("DATA", "Oracle#DATA");
        }
        if (this.doConstraints.isSelected()) {
            linkedHashMap.put("CONSTRAINT", "Oracle#CONSTRAINT");
        }
        if (this.doIndex.isSelected()) {
            linkedHashMap.put("INDEX", "Oracle#INDEX");
        }
        if (this.doConstraints.isSelected()) {
            linkedHashMap.put("REFCONSTRAINT", "Oracle#REFCONSTRAINT");
        }
        if (this.doTriggers.isSelected()) {
            linkedHashMap.put("TRIGGER", "Oracle#TRIGGER");
        }
        if (this.doMatView.isSelected()) {
            linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        }
        if (this.doMatViewLog.isSelected()) {
            linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        }
        if (this.doView.isSelected()) {
            linkedHashMap.put("VIEW", "Oracle#VIEW");
        }
        if (this.doFunction.isSelected()) {
            linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        }
        if (this.doPackSpec.isSelected()) {
            linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        }
        if (this.doPackBody.isSelected()) {
            linkedHashMap.put("PACKAGE BODY", "Oracle#PACKAGE_BODY");
        }
        if (this.doProcedure.isSelected()) {
            linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        }
        if (this.doTypes.isSelected()) {
            linkedHashMap.put("TYPE", "Oracle#TYPE");
        }
        if (this.doSynonymn.isSelected()) {
            linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        }
        return linkedHashMap;
    }

    public String getAllTypes() {
        String string = new String();
        for (String string2 : this.getistTypes()) {
            string = string2 + ":" + string;
        }
        return string;
    }

    public ArrayList<String> getistTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.doDbLink.isSelected()) {
            arrayList.add("DATABASE LINK");
        }
        if (this.doSequence.isSelected()) {
            arrayList.add("SEQUENCE");
        }
        if (this.doTables.isSelected()) {
            arrayList.add("TABLE");
        }
        if (this.doIndex.isSelected()) {
            arrayList.add("INDEX");
        }
        if (this.doTriggers.isSelected()) {
            arrayList.add("TRIGGER");
        }
        if (this.doMatView.isSelected()) {
            arrayList.add("MATERIALIZED VIEW");
        }
        if (this.doView.isSelected()) {
            arrayList.add("VIEW");
        }
        if (this.doFunction.isSelected()) {
            arrayList.add("FUNCTION");
        }
        if (this.doPackSpec.isSelected()) {
            arrayList.add("PACKAGE");
        }
        if (this.doPackBody.isSelected()) {
            arrayList.add("PACKAGE BODY");
        }
        if (this.doProcedure.isSelected()) {
            arrayList.add("PROCEDURE");
        }
        if (this.doTypes.isSelected()) {
            arrayList.add("TYPE");
        }
        if (this.doSynonymn.isSelected()) {
            arrayList.add("SYNONYM");
        }
        return arrayList;
    }

    private void doExportWork() {
        try {
            Serializable serializable;
            Object object;
            String string;
            if (this._file.getFileName().equals("") || this._file.getFileName() == null) {
                this._file.prompt();
            }
            if (this._file.getFileName().equals("") || this._file.getFileName() == null) {
                return;
            }
            DDLGenerator dDLGenerator = DDLGenerator.getInstance();
            dDLGenerator.setFile(this._file.getFileName(), this._file.getEncoding());
            dDLGenerator.openFile();
            Connection connection = this.connSelector.getCurrentConnection();
            String string2 = connection.getMetaData().getUserName();
            LinkedHashMap<String, String> linkedHashMap = this.getTypes();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
            Date date = new Date();
            dDLGenerator.getWriter().write("--------------------------------------------------------" + this._EOL);
            dDLGenerator.getWriter().write("--  File created - " + simpleDateFormat.format(date) + "   " + this._EOL);
            dDLGenerator.getWriter().write("--------------------------------------------------------" + this._EOL);
            String string3 = Connections.getInstance().getConnectioName(connection);
            for (String object3 : linkedHashMap.keySet()) {
                DBObject dBObject;
                URL uRL;
                URL uRL2;
                string = linkedHashMap.get(object3);
                if (object3.equals("DATA") && this._dataList.size() > 0) {
                    for (URL uRL3 : this._dataList.keySet()) {
                        if (uRL3 == null) continue;
                        object = new DBObject(uRL3);
                        uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object).getSchemaName(), "DATA");
                        uRL = DBURLFormatHelper.getURL(uRL2, ((DBObject)object).getObjectName());
                        arrayList.add(new DBObject(uRL));
                    }
                    continue;
                }
                if (object3.equals("DATA") && this._dataList.size() == 0 && this.getAdvListType("TABLE").size() > 0) {
                    serializable = this.getAdvListType("TABLE");
                    Iterator<URL> iterator = ((ArrayList)serializable).iterator();
                    while (iterator.hasNext()) {
                        object = new DBObject(iterator.next());
                        uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object).getSchemaName(), object3);
                        uRL = DBURLFormatHelper.getURL(uRL2, ((DBObject)object).getObjectName());
                        dBObject = new DBObject(uRL);
                        arrayList.add(dBObject);
                    }
                    continue;
                }
                if ((object3.equals("CONSTRAINT") || object3.equals("REFCONSTRAINT")) && this.getAdvListType("TABLE").size() > 0) {
                    serializable = this.getAdvListType("TABLE");
                    Iterator<URL> iterator = ((ArrayList)serializable).iterator();
                    while (iterator.hasNext()) {
                        object = new DBObject(iterator.next());
                        uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object).getSchemaName(), object3);
                        uRL = DBURLFormatHelper.getURL(uRL2, ((DBObject)object).getObjectName());
                        dBObject = new DBObject(uRL);
                        arrayList.add(dBObject);
                    }
                    continue;
                }
                if (this.getAdvListType(object3).size() > 0) {
                    serializable = this.getAdvListType(object3);
                    Iterator<URL> iterator = ((ArrayList)serializable).iterator();
                    while (iterator.hasNext()) {
                        object = new DBObject(iterator.next());
                        arrayList.add(object);
                    }
                    continue;
                }
                serializable = DDLGenerator.getInstance().getSchemaObjects(this.connSelector.getCurrentConnection(), string2, object3, string);
                if (serializable == null) continue;
                Iterator iterator = ((ArrayList)serializable).iterator();
                while (iterator.hasNext()) {
                    object = (DBObject)iterator.next();
                    arrayList.add(object);
                }
            }
            for (DBObject dBObject : arrayList) {
                if (this._cancel) {
                    dDLGenerator.getWriter().write(" ----------------------------" + this._EOL);
                    dDLGenerator.getWriter().write(" -- EXPORT TERMINATED BY USER" + this._EOL);
                    dDLGenerator.getWriter().write(" ----------------------------" + this._EOL);
                    break;
                }
                if (dBObject.getObjectType().equals("DATA") && this._dataList.size() > 0) {
                    string = dBObject.getURL().toString();
                    string = string.replace("DATA", "TABLE");
                    serializable = new URL(string);
                    String string4 = this._dataList.get(serializable);
                    try {
                        object = dDLGenerator.getScriptDDL(dBObject, string4);
                        dDLGenerator.getWriter().write((String)object);
                        dDLGenerator.getWriter().flush();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (this._options.getDrop()) {
                    dDLGenerator.getWriter().write(this._EOL + " ----------------------------" + this._EOL);
                    dDLGenerator.getWriter().write(" -- DROP " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\";" + this._EOL);
                    dDLGenerator.getWriter().write(" ----------------------------" + this._EOL);
                    if (this._options.getSchema()) {
                        dDLGenerator.getWriter().write("  DROP " + dBObject.getObjectType() + " \"" + dBObject.getSchemaName() + "\".\"" + dBObject.getObjectName() + "\";" + this._EOL);
                    } else {
                        dDLGenerator.getWriter().write("  DROP " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\";" + this._EOL);
                    }
                }
                if (dBObject.getObjectType().equals("TABLE") && this.doTabDeps.isSelected()) {
                    dDLGenerator.getWriter().write(this._EOL + "--------------------------------------------------------" + this._EOL);
                    dDLGenerator.getWriter().write("--  DDL for Table " + dBObject.getObjectName() + this._EOL);
                    dDLGenerator.getWriter().write("--------------------------------------------------------" + this._EOL);
                    dDLGenerator.getWriter().write(dDLGenerator.getDDL(dBObject, "DEP"));
                } else {
                    try {
                        string = dDLGenerator.getScriptDDL(dBObject);
                        dDLGenerator.getWriter().write(string);
                        dDLGenerator.getWriter().flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                dDLGenerator.getWriter().flush();
            }
            dDLGenerator.closeFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.connSelector.getCurrentConnectionName() == null || this.connSelector.getCurrentConnectionName().equals("")) {
            MessageDialog.error((Component)INSTANCE, (Object)"No Connection is selected unable to continue.", (String)"Connection Blank Error", (String)"f1_exportConnection_html");
            return;
        }
        if (actionEvent.getActionCommand().equals("apply")) {
            ExportRun exportRun = new ExportRun();
            exportRun.set_e(actionEvent);
            exportRun.setTitle(Translate.translate("Performing Export"));
            exportRun.setMessage(Translate.translate("Performing Export operations please be patient."));
            try {
                exportRun.start(true);
            }
            catch (ProgressException progressException) {
                progressException.printStackTrace();
            }
        }
    }

    static {
        EXPORT_ACTION = Ide.findOrCreateCmdID((String)EXPORT_NAME);
    }

    class ExportRun
    extends ProgressRunnable {
        private ActionEvent _e;

        ExportRun() {
        }

        public void set_e(ActionEvent actionEvent) {
            this._e = actionEvent;
        }

        protected Object doWork() throws Exception {
            ExpPanel.this._cancel = false;
            ExpPanel.this.doExportWork();
            if (this._e.getSource() instanceof JEWTDialog && !ExpPanel.this._cancel) {
                JEWTDialog jEWTDialog = (JEWTDialog)this._e.getSource();
                jEWTDialog.closeDialog(true);
            }
            return true;
        }

        protected void doCancel() {
            super.doCancel();
            ExpPanel.this._cancel = true;
        }
    }

    private static class ExportController
    implements Controller {
        private static Controller INSTANCE = new ExportController();

        private ExportController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == EXPORT_ACTION) {
                ExpPanel.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == EXPORT_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

