/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.DBObjectSearch;
import oracle.dbtools.raptor.controls.URLListRenderer;
import oracle.dbtools.raptor.export.ExpPanel;
import oracle.dbtools.raptor.images.RaptorImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvFilterPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = new JScrollPane();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private DBObjectSearch jList;
    private ExpPanel ePanel;
    private String _conn;
    private JButton addOne = new JButton();
    private JButton remOne = new JButton();
    private JButton addAll = new JButton();
    private JButton remAll = new JButton();
    private JList _tableList;
    private DefaultListModel _model;
    private JComboBox typeSelect = new JComboBox();
    private JLabel typeLabel = new JLabel();
    JLabel lab = new JLabel();

    public void setConn(String string) {
        this._conn = string;
    }

    public void setExpPanel(ExpPanel expPanel) {
        this.ePanel = expPanel;
    }

    private void loadFilterList(ArrayList<URL> arrayList) {
        ((DefaultListModel)this._tableList.getModel()).clear();
        for (URL uRL : arrayList) {
            if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
            ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeList() {
        try {
            this.typeSelect.removeAllItems();
        }
        finally {
            this.typeSelect.addItem("All");
            for (String string : this.ePanel.getistTypes()) {
                this.typeSelect.addItem(string);
            }
        }
    }

    public void initialize() {
        this._model = new DefaultListModel();
        this._tableList = new JList(this._model);
        this._tableList.setCellRenderer(new URLListRenderer());
        this._tableList.setDragEnabled(true);
        this._tableList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = AdvFilterPanel.this._tableList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        ((DefaultListModel)AdvFilterPanel.this._tableList.getModel()).removeElement(uRL);
                        AdvFilterPanel.this.ePanel.remFromAdvList(uRL);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.jList = new DBObjectSearch(this._conn);
        this.jList.setType(this.ePanel.getAllTypes());
        this.jList.getList().addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = AdvFilterPanel.this.jList.getList().getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        if (((DefaultListModel)AdvFilterPanel.this._tableList.getModel()).indexOf(uRL) != -1) continue;
                        ((DefaultListModel)AdvFilterPanel.this._tableList.getModel()).addElement(uRL);
                    }
                    AdvFilterPanel.this.ePanel.addToAdvList(AdvFilterPanel.this.getList());
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        ArrayList<URL> arrayList = this.ePanel.getAdvList();
        this.loadFilterList(arrayList);
        this.typeSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                    String string = (String)AdvFilterPanel.this.typeSelect.getSelectedItem();
                    if (string != null && !string.equals("All")) {
                        AdvFilterPanel.this.jList.setType(string.replace("_", " "));
                        ArrayList<URL> arrayList = AdvFilterPanel.this.ePanel.getAdvListType(string);
                        AdvFilterPanel.this.loadFilterList(arrayList);
                    } else {
                        AdvFilterPanel.this.jList.setType(AdvFilterPanel.this.ePanel.getAllTypes());
                        ArrayList<URL> arrayList = AdvFilterPanel.this.ePanel.getAdvList();
                        AdvFilterPanel.this.loadFilterList(arrayList);
                    }
                    AdvFilterPanel.this.jList.clear();
                }
            }
        });
        this.typeLabel.setText("Object Type:");
        this.addAll.setActionCommand(">>");
        this.addAll.setIcon(RaptorImage.getIcon("last_ena.png"));
        this.addAll.addActionListener(this);
        this.addOne.setActionCommand(">");
        this.addOne.setIcon(RaptorImage.getIcon("next_ena.png"));
        this.addOne.addActionListener(this);
        this.remAll.setActionCommand("<<");
        this.remAll.setIcon(RaptorImage.getIcon("first_ena.png"));
        this.remAll.addActionListener(this);
        this.remOne.setActionCommand("<");
        this.remOne.setIcon(RaptorImage.getIcon("prev_ena.png"));
        this.remOne.addActionListener(this);
        this.jScrollPane.setPreferredSize(new Dimension(300, 350));
        this.jScrollPane.setViewportView(this.jList);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 320));
        this.jScrollPane1.setViewportView(this._tableList);
        this.lab.setText("If no filter is applied for an object type then all objects or that type will be exported.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.anchor = 17;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 20, 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = new Insets(50, 10, 0, 10);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 4;
        gridBagConstraints5.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 5;
        gridBagConstraints6.insets = new Insets(0, 10, 0, 10);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.gridx = 3;
        gridBagConstraints7.gridy = 1;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(10, 10, 10, 10);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.gridx = 3;
        gridBagConstraints8.gridy = 2;
        gridBagConstraints8.gridheight = 6;
        gridBagConstraints8.insets = new Insets(0, 0, 10, 10);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 9;
        gridBagConstraints9.gridwidth = 4;
        gridBagConstraints9.anchor = 10;
        this.setSize(650, 400);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jScrollPane, gridBagConstraints);
        this.add((Component)this.lab, gridBagConstraints9);
        this.add((Component)this.addOne, gridBagConstraints3);
        this.add((Component)this.addAll, gridBagConstraints4);
        this.add((Component)this.remOne, gridBagConstraints5);
        this.add((Component)this.remAll, gridBagConstraints6);
        this.add((Component)this.jScrollPane1, gridBagConstraints8);
        this.add((Component)this.typeSelect, gridBagConstraints7);
        this.add((Component)this.typeLabel, gridBagConstraints2);
    }

    public ArrayList<URL> getList() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        DefaultListModel defaultListModel = (DefaultListModel)this._tableList.getModel();
        if (defaultListModel != null) {
            for (int i = 0; i < defaultListModel.size(); ++i) {
                URL uRL = (URL)defaultListModel.get(i);
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("apply")) {
            JEWTDialog jEWTDialog = (JEWTDialog)actionEvent.getSource();
            jEWTDialog.closeDialog(true);
        } else if (actionEvent.getActionCommand().equals(">")) {
            Object[] objectArray = this.jList.getList().getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                URL uRL = (URL)objectArray[i];
                if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
                ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
            }
            this.ePanel.addToAdvList(this.getList());
        } else if (actionEvent.getActionCommand().equals("<")) {
            Object[] objectArray = this._tableList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                URL uRL = (URL)objectArray[i];
                ((DefaultListModel)this._tableList.getModel()).removeElement(uRL);
                this.ePanel.remFromAdvList(uRL);
            }
        } else if (actionEvent.getActionCommand().equals(">>")) {
            DefaultListModel defaultListModel = (DefaultListModel)this.jList.getList().getModel();
            Object[] objectArray = new Object[defaultListModel.size() + 1];
            defaultListModel.copyInto(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                URL uRL = (URL)objectArray[i];
                if (uRL == null || ((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
                ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
            }
            this.ePanel.addToAdvList(this.getList());
        } else if (actionEvent.getActionCommand().equals("<<")) {
            ((DefaultListModel)this._tableList.getModel()).clear();
            this.ePanel.resetAdvList();
        }
    }
}

