/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.explorer.dt.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.explorer.dt.dialog.CommonDialog;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionWrapper;

public class ConnectionDialog
extends JPanel {
    public static String OCI_URL = "jdbc:oracle:oci8:@";
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JLabel lblName = new JLabel();
    private JTextField tfdConnName = new JTextField(15);
    private JLabel lblUser = new JLabel();
    private JTextField tfdUser = new JTextField(15);
    private JLabel lblPassword = new JLabel();
    private JPasswordField tfdPassword = new JPasswordField(15);
    private JCheckBox chkSavePassword = new JCheckBox();
    private JLabel lblRole = new JLabel();
    private String[] roles = new String[]{"default", "SYSDBA"};
    private JComboBox cbxRole = new JComboBox<String>(this.roles);
    private JSplitPane jSplitPane1 = new JSplitPane();
    private CommonDialog _dlg = null;
    private JButton btnClear = new JButton();
    private JButton btnTest = new JButton();
    private JLabel lblStatus = new JLabel(ConnectionDialogArb.getString(26));
    private static ConnectionDialog dlg = null;
    private ConnectionModel model = new ConnectionModel();
    private JTable jTable1 = new JTable(this.model){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = this.getSelectedRows();
            if (nArray.length > 0) {
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)ConnectionDialog.this.model.getData().get(nArray[0]);
                ConnectionDialog.this.tfdConnName.setText(connectionDescriptor.getConnectionName());
                ConnectionDialog.this.tfdUser.setText(connectionDescriptor.getUsername());
                ConnectionDialog.this.tfdPassword.setText(connectionDescriptor.getPassword());
                ConnectionDialog.this.chkSavePassword.setSelected(Boolean.parseBoolean(connectionDescriptor.getProperty("SavePassword", Boolean.TRUE.toString())));
                String string = connectionDescriptor.getRole();
                if (string != null) {
                    ConnectionDialog.this.cbxRole.setSelectedItem(string);
                } else {
                    ConnectionDialog.this.cbxRole.setSelectedItem("default");
                }
                String string2 = connectionDescriptor.getHostname();
                if (string2 != null) {
                    ConnectionDialog.this.jTabbedPane1.setSelectedComponent(ConnectionDialog.this.basicPanel);
                    ConnectionDialog.this.basicPanel.tfdHost.setText(string2);
                    String string3 = connectionDescriptor.getJdbcPort();
                    ConnectionDialog.this.basicPanel.tfdPort.setText(string3 != null ? string3 : "1521");
                    ConnectionDialog.this.basicPanel.tfdSid.setText(connectionDescriptor.getSid());
                    ConnectionDialog.this.basicPanel.tfdService.setText(connectionDescriptor.getProperty("ServiceName"));
                    if (ConnectionDialog.this.basicPanel.tfdSid.getText().length() > 0) {
                        ConnectionDialog.this.basicPanel.btnSid.setSelected(true);
                        ConnectionDialog.this.toggleSidOrService(ConnectionDialog.this.basicPanel.btnSid);
                    } else {
                        ConnectionDialog.this.basicPanel.btnService.setSelected(true);
                        ConnectionDialog.this.toggleSidOrService(ConnectionDialog.this.basicPanel.btnService);
                    }
                } else {
                    ConnectionDialog.this.jTabbedPane1.setSelectedComponent(ConnectionDialog.this.tNSPanel);
                    String string4 = connectionDescriptor.getURL();
                    String string5 = string4.substring(string4.lastIndexOf(64) + 1);
                    ConnectionDialog.this.tNSPanel.cbxTnsName.setSelectedItem(string5);
                    if (ConnectionDialog.this.tNSPanel.cbxTnsName.getSelectedItem() != null && ConnectionDialog.this.tNSPanel.cbxTnsName.getSelectedItem().equals(string5)) {
                        ConnectionDialog.this.tNSPanel.btnTns.setSelected(true);
                        ConnectionDialog.this.toggleTNSOrSqlNet(ConnectionDialog.this.tNSPanel.btnTns);
                    } else {
                        ConnectionDialog.this.tNSPanel.tfdSqlNetName.setText(string5);
                        ConnectionDialog.this.tNSPanel.btnSqlNet.setSelected(true);
                        ConnectionDialog.this.toggleTNSOrSqlNet(ConnectionDialog.this.tNSPanel.btnSqlNet);
                    }
                }
            }
            this.clearSelection();
        }
    };
    private BasicPanel basicPanel = new BasicPanel();
    private TNSPanel tNSPanel = new TNSPanel();
    private AdvancedPanel advancedPanel = new AdvancedPanel();
    private ConnectionDescriptor connectionDescriptor = null;

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connectionDescriptor;
    }

    public void setConnectionDescriptor(ConnectionDescriptor connectionDescriptor) {
        this.connectionDescriptor = connectionDescriptor;
    }

    public ConnectionDialog() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.btnClear, (String)ConnectionDialogArb.getString(21));
        ResourceUtils.resButton((AbstractButton)this.btnTest, (String)ConnectionDialogArb.getString(22));
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.tfdConnName, (String)ConnectionDialogArb.getString(6));
        ResourceUtils.resLabel((JLabel)this.lblUser, (Component)this.tfdUser, (String)ConnectionDialogArb.getString(9));
        ResourceUtils.resLabel((JLabel)this.lblPassword, (Component)this.tfdPassword, (String)ConnectionDialogArb.getString(10));
        ResourceUtils.resButton((AbstractButton)this.chkSavePassword, (String)ConnectionDialogArb.getString(11));
        ResourceUtils.resLabel((JLabel)this.lblRole, (Component)this.cbxRole, (String)ConnectionDialogArb.getString(12));
        this.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel2.setOpaque(false);
        this.jSplitPane1.setOpaque(false);
        this.jTable1.setOpaque(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.tfdConnName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lblUser, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.tfdUser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lblPassword, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.tfdPassword, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.chkSavePassword, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.lblRole, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.cbxRole, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, null);
        this.jTabbedPane1.addTab(ConnectionDialogArb.getString(16), this.basicPanel);
        this.jTabbedPane1.addTab(ConnectionDialogArb.getString(17), this.tNSPanel);
        this.jTabbedPane1.addTab(ConnectionDialogArb.getString(20), this.advancedPanel);
        this.jPanel1.add((Component)this.jTabbedPane1, null);
        this.jTabbedPane1.setPreferredSize(this.basicPanel.getPreferredSize());
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
        this.jSplitPane1.add((Component)this.jPanel1, "left");
        this.jSplitPane1.add((Component)this.jScrollPane1, "right");
        this.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.lblStatus, "South");
        SpringLayout springLayout = new SpringLayout();
        this.jPanel1.setLayout(springLayout);
        this.jPanel1.setOpaque(false);
        springLayout.putConstraint("North", (Component)this.jPanel2, 0, "North", (Component)this.jPanel2.getParent());
        springLayout.putConstraint("East", (Component)this.jPanel2.getParent(), 0, "East", (Component)this.jPanel2);
        springLayout.putConstraint("West", (Component)this.jTabbedPane1, 0, "West", (Component)this.jTabbedPane1.getParent());
        springLayout.putConstraint("North", (Component)this.jTabbedPane1, 0, "South", (Component)this.jPanel2);
        springLayout.putConstraint("South", (Component)this.jTabbedPane1.getParent(), 0, "South", (Component)this.jTabbedPane1);
        springLayout.putConstraint("East", (Component)this.jPanel2, 0, "East", (Component)this.jTabbedPane1);
        springLayout.putConstraint("West", (Component)this.jPanel2, 0, "West", (Component)this.jTabbedPane1);
        this.jPanel2.setMinimumSize(new Dimension(280, 120));
        this.jPanel2.setMaximumSize(new Dimension(430, 130));
        this.jTabbedPane1.setMinimumSize(new Dimension(280, 300));
        this.jTabbedPane1.setMaximumSize(new Dimension(430, 285));
        this.jScrollPane1.setMinimumSize(new Dimension(450, 420));
        this.jScrollPane1.setOpaque(false);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Component component = (Component)propertyChangeEvent.getSource();
                ConnectionDialog.this.jTabbedPane1.setSelectedComponent(component.getParent().getParent());
            }
        };
        this.btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.clearFields();
            }
        });
        this.btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ConnectionDialog.this.testConnection();
                }
                catch (CMException cMException) {
                    ConnectionDialog.this.lblStatus.setText(ConnectionDialogArb.getString(28) + cMException.getMessage());
                    ConnectionDialog.this.lblStatus.setForeground(Color.RED);
                    ConnectionDialog.this.lblStatus.getAccessibleContext().setAccessibleName(ConnectionDialog.this.lblStatus.getText());
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                ConnectionDialog.this.toggleSidOrService(abstractButton);
            }
        };
        this.basicPanel.btnSid.addActionListener(actionListener);
        this.basicPanel.btnService.addActionListener(actionListener);
        this.basicPanel.btnSid.setSelected(true);
        this.basicPanel.tfdSid.setEnabled(true);
        this.basicPanel.btnService.setSelected(false);
        this.basicPanel.tfdService.setEnabled(false);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                ConnectionDialog.this.toggleTNSOrSqlNet(abstractButton);
            }
        };
        this.tNSPanel.btnTns.addActionListener(actionListener2);
        this.tNSPanel.btnSqlNet.addActionListener(actionListener2);
        this.tNSPanel.btnTns.setSelected(true);
        this.tNSPanel.cbxTnsName.setEnabled(true);
        this.tNSPanel.btnSqlNet.setSelected(false);
        this.tNSPanel.tfdSqlNetName.setEnabled(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    ConnectionDialog.this._dlg.ok();
                }
            }
        });
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(50);
    }

    public void setHistoryData(List list) {
        this.model.setData(list);
        this.jTable1.updateUI();
    }

    public void setTNSConnectionData(List list) {
        this.tNSPanel.model.setData(list);
    }

    private ConnectionDescriptor runDialog(String string) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idewcxnwelcome_html");
        this.jTabbedPane1.setSelectedComponent(this.basicPanel);
        this._dlg = new CommonDialog("");
        this._dlg.addCustomButton(this.btnClear);
        this._dlg.addCustomButton(this.btnTest);
        this._dlg.setInitialFocus(this.jTable1);
        this._dlg.setContent(this);
        this._dlg.setPreferredSize(800, 420);
        this._dlg.setResizable(true);
        this._dlg.setOKButtonText(ConnectionDialogArb.getString(23));
        this._dlg.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                ConnectionDialog.this._dlg;
                if (CommonDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                    if (ConnectionDialog.this.tfdConnName.getText().trim().length() <= 0) {
                        ConnectionDialog.this.lblStatus.setText(ConnectionDialogArb.getString(29));
                        ConnectionDialog.this.lblStatus.setForeground(Color.RED);
                        ConnectionDialog.this.tfdConnName.requestFocusInWindow();
                        throw new PropertyVetoException(ConnectionDialogArb.getString(29), propertyChangeEvent);
                    }
                    try {
                        ConnectionDialog.this.testConnection();
                    }
                    catch (CMException cMException) {
                        ConnectionDialog.this.lblStatus.setText(ConnectionDialogArb.getString(28) + cMException.getMessage());
                        ConnectionDialog.this.lblStatus.setForeground(Color.RED);
                        throw new PropertyVetoException(cMException.getMessage(), propertyChangeEvent);
                    }
                }
            }
        });
        if (string != null && string.length() > 0) {
            this._dlg.setTitle(string);
        } else {
            this._dlg.setTitle(ConnectionDialogArb.getString(24));
            this.clearFields();
        }
        ConnectionDescriptor connectionDescriptor = null;
        if (WizardLauncher.runDialog((JDialog)((Object)this._dlg))) {
            connectionDescriptor = this.getInput();
        }
        this.lblStatus.setText(ConnectionDialogArb.getString(26));
        this.lblStatus.setForeground(Color.BLACK);
        return connectionDescriptor;
    }

    public void select(String string) {
        if (string != null && string.trim().length() > 0) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.model.getRowData(i);
                if (!connectionDescriptor.getConnectionName().equals(string)) continue;
                this.jTable1.getSelectionModel().setSelectionInterval(i, i);
                break;
            }
        }
    }

    private void testConnection() throws CMException {
        this.lblStatus.setText("");
        ConnectionDescriptor connectionDescriptor = this.getInput();
        this.lblStatus.setText(ConnectionDialogArb.getString(26));
        this.lblStatus.setForeground(Color.BLACK);
        this.testConnection(connectionDescriptor);
        this.lblStatus.setText(ConnectionDialogArb.getString(27));
        this.lblStatus.setForeground(Color.BLACK);
    }

    protected void testConnection(ConnectionDescriptor connectionDescriptor) throws CMException {
        ConnectionWrapper connectionWrapper = null;
        try {
            Object object;
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            if (connectionDescriptor.getURL().indexOf("jdbc") != 0) {
                object = Connections.getInstance().resovleTNS2JDBCURL(connectionDescriptor.getURL());
                connectionDescriptor.put((Object)"URL", object);
            }
            connectionWrapper = connectionManager.getConnection(connectionDescriptor);
            object = connectionWrapper.getPresentationIterator();
            while (object.hasNext()) {
                connectionWrapper.testPresentation((String)object.next());
            }
            connectionWrapper.closeConnection();
            connectionWrapper = null;
        }
        catch (CMException cMException) {
            throw cMException;
        }
        catch (RuntimeException runtimeException) {
            throw new CMException((Exception)runtimeException);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Error error) {
            throw new CMException(error.getLocalizedMessage());
        }
        finally {
            if (connectionWrapper != null) {
                try {
                    connectionWrapper.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
    }

    private ConnectionDescriptor getInput() {
        ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor();
        connectionDescriptor.put((Object)"ConnectionType", (Object)"JDBC");
        connectionDescriptor.put((Object)"DeployPassword", (Object)"false");
        connectionDescriptor.put((Object)"JdbcDriver", (Object)"oracle.jdbc.driver.OracleDriver");
        connectionDescriptor.put((Object)"ORACLE_JDBC_TYPE", (Object)"thin");
        connectionDescriptor.put((Object)"user", (Object)this.tfdUser.getText());
        connectionDescriptor.put((Object)"password", (Object)new String(this.tfdPassword.getPassword()));
        connectionDescriptor.put((Object)"SavePassword", (Object)Boolean.toString(this.chkSavePassword.isSelected()));
        String string = (String)this.cbxRole.getSelectedItem();
        if (string.equals(this.roles[0])) {
            connectionDescriptor.put((Object)"Role", (Object)"");
        } else {
            connectionDescriptor.put((Object)"Role", (Object)string);
        }
        if (this.tfdConnName.getText().length() > 0) {
            connectionDescriptor.put((Object)"ConnectionName", (Object)this.tfdConnName.getText());
        } else {
            connectionDescriptor.put((Object)"ConnectionName", (Object)connectionDescriptor.getConnectionName());
        }
        CDComponentView cDComponentView = (CDComponentView)((Object)this.jTabbedPane1.getSelectedComponent());
        cDComponentView.populateComponent(connectionDescriptor);
        return connectionDescriptor;
    }

    private void clearFields() {
        this.basicPanel.tfdHost.setText("");
        this.basicPanel.tfdPort.setText("1521");
        this.tfdPassword.setText("");
        this.chkSavePassword.setSelected(false);
        this.basicPanel.tfdSid.setText("");
        this.basicPanel.tfdService.setText("");
        this.tfdUser.setText("");
        this.cbxRole.setSelectedItem("default");
        if (this.tNSPanel.cbxTnsName.getItemCount() > 0) {
            this.tNSPanel.cbxTnsName.setSelectedIndex(0);
        }
        this.tNSPanel.tfdSqlNetName.setText("");
        Thread thread = new Thread(){

            public void run() {
                ConnectionDialog.this.preFillConnName();
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        ConnectionDialog connectionDialog = new ConnectionDialog();
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Component component = (Component)componentEvent.getSource();
                System.out.println(component + ".size=" + component.getSize());
            }
        };
        connectionDialog.jPanel2.addComponentListener(componentAdapter);
        connectionDialog.jTabbedPane1.addComponentListener(componentAdapter);
        connectionDialog.jScrollPane1.addComponentListener(componentAdapter);
        connectionDialog.addComponentListener(componentAdapter);
        JFrame jFrame = new JFrame("Test");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new GridLayout(1, 1));
        jFrame.getContentPane().add(connectionDialog);
        jFrame.setSize(730, 375);
        jFrame.setVisible(true);
    }

    private void toggleSidOrService(AbstractButton abstractButton) {
        if (abstractButton.equals(this.basicPanel.btnSid)) {
            if (abstractButton.isSelected()) {
                this.basicPanel.tfdSid.setEnabled(true);
                this.basicPanel.tfdService.setEnabled(false);
            } else {
                this.basicPanel.tfdSid.setEnabled(false);
                this.basicPanel.tfdService.setEnabled(true);
            }
        } else if (abstractButton.equals(this.basicPanel.btnService)) {
            if (abstractButton.isSelected()) {
                this.basicPanel.tfdSid.setEnabled(false);
                this.basicPanel.tfdService.setEnabled(true);
            } else {
                this.basicPanel.tfdSid.setEnabled(true);
                this.basicPanel.tfdService.setEnabled(false);
            }
        }
    }

    private void toggleTNSOrSqlNet(AbstractButton abstractButton) {
        if (abstractButton.equals(this.tNSPanel.btnTns)) {
            if (abstractButton.isSelected()) {
                this.tNSPanel.cbxTnsName.setEnabled(true);
                this.tNSPanel.tfdSqlNetName.setEnabled(false);
            } else {
                this.tNSPanel.cbxTnsName.setEnabled(false);
                this.tNSPanel.tfdSqlNetName.setEnabled(true);
            }
        } else if (abstractButton.equals(this.tNSPanel.btnSqlNet)) {
            if (abstractButton.isSelected()) {
                this.tNSPanel.cbxTnsName.setEnabled(false);
                this.tNSPanel.tfdSqlNetName.setEnabled(true);
            } else {
                this.tNSPanel.cbxTnsName.setEnabled(true);
                this.tNSPanel.tfdSqlNetName.setEnabled(false);
            }
        }
    }

    private void preFillConnName() {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        String string = ConnectionDialogArb.getString(25);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            treeSet.add(this.model.getValueAt(i, 0));
        }
        List<Object> list = Arrays.asList(treeSet.toArray());
        int n = 1;
        int n2 = 0;
        while (n2 >= 0) {
            n2 = list.indexOf(string + n++);
        }
        this.tfdConnName.setText(string + (n - 1));
        this.tfdConnName.updateUI();
    }

    public static ConnectionDescriptor selectConnection(String string) {
        List list;
        if (dlg == null) {
            dlg = new ConnectionDialog();
        }
        if ((list = ConnectionDialog.getAllConnections()) == null) {
            list = new ArrayList();
        }
        dlg.setHistoryData(list);
        dlg.select(string);
        list = ConnectionDialog.getTNSConnections();
        if (list == null) {
            list = new ArrayList();
        }
        dlg.setTNSConnectionData(list);
        return dlg.runDialog(string);
    }

    public static void registerConnection(ConnectionDescriptor connectionDescriptor) throws IOException {
        if (connectionDescriptor != null) {
            ConnectionManager.getInstance().putConnectionDescriptor(connectionDescriptor.getConnectionName(), connectionDescriptor);
        }
    }

    private static List getAllConnections() {
        ConnectionManager connectionManager = ConnectionManager.getInstance();
        try {
            String[] stringArray = connectionManager.getConnectionNames();
            TreeSet<ConnectionDescriptor> treeSet = new TreeSet<ConnectionDescriptor>(new CDComparator());
            for (int i = 0; i < stringArray.length; ++i) {
                treeSet.add(connectionManager.getConnectionDescriptor(stringArray[i]));
            }
            return Arrays.asList(treeSet.toArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static List getTNSConnections() {
        TreeSet<ConnectionDescriptor> treeSet = new TreeSet<ConnectionDescriptor>(new CDComparator());
        ArrayList<TCPTNSEntry> arrayList = TNSHelper.getTNSEntries();
        for (int i = 0; i < arrayList.size(); ++i) {
            ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor();
            connectionDescriptor.put((Object)"ConnectionType", (Object)"JDBC");
            connectionDescriptor.put((Object)"DeployPassword", (Object)"false");
            connectionDescriptor.put((Object)"Role", (Object)"");
            connectionDescriptor.put((Object)"JdbcDriver", (Object)"oracle.jdbc.driver.OracleDriver");
            connectionDescriptor.put((Object)"ORACLE_JDBC_TYPE", (Object)"thin");
            connectionDescriptor.put((Object)"user", (Object)"");
            connectionDescriptor.put((Object)"password", (Object)"");
            connectionDescriptor.put((Object)"ConnectionName", (Object)arrayList.get(i).getName());
            connectionDescriptor.put((Object)"URL", (Object)arrayList.get(i).getJDBCUrl());
            treeSet.add(connectionDescriptor);
        }
        return Arrays.asList(treeSet.toArray());
    }

    private static class CDComparator
    implements Comparator {
        private CDComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof ConnectionDescriptor && object2 instanceof ConnectionDescriptor) {
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)object;
                ConnectionDescriptor connectionDescriptor2 = (ConnectionDescriptor)object2;
                return connectionDescriptor.getConnectionName().compareTo(connectionDescriptor2.getConnectionName());
            }
            throw new IllegalArgumentException(object + " and " + object2 + " are not comparable.");
        }

        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    private class BasicPanel
    extends JPanel
    implements CDComponentView {
        private GridLayout gridLayout1 = new GridLayout();
        private JLabel jLabel1 = new JLabel();
        private JTextField tfdHost = new JTextField(15);
        private JLabel jLabel2 = new JLabel();
        private JTextField tfdPort = new JTextField(15);
        private JTextField tfdSid = new JTextField(15);
        private JTextField tfdService = new JTextField(15);
        private JRadioButton btnSid = new JRadioButton();
        private JRadioButton btnService = new JRadioButton();
        private ButtonGroup group = new ButtonGroup();

        public BasicPanel() {
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void populateComponent(ConnectionDescriptor connectionDescriptor) {
            connectionDescriptor.put((Object)"HOSTNAME", (Object)this.tfdHost.getText());
            connectionDescriptor.put((Object)"JDBC_PORT", (Object)this.tfdPort.getText());
            String string = "jdbc:oracle:thin:@" + this.tfdHost.getText() + ":" + this.tfdPort.getText() + ":";
            if (this.btnSid.isSelected()) {
                connectionDescriptor.put((Object)"SID", (Object)this.tfdSid.getText());
                string = string + this.tfdSid.getText();
            } else if (this.btnService.isSelected()) {
                connectionDescriptor.put((Object)"ServiceName", (Object)this.tfdService.getText());
                string = string + this.tfdService.getText();
            }
            connectionDescriptor.put((Object)"URL", (Object)string);
        }

        private void jbInit() throws Exception {
            this.setSize(new Dimension(385, 266));
            this.gridLayout1.setColumns(2);
            this.gridLayout1.setRows(4);
            this.gridLayout1.setVgap(30);
            this.gridLayout1.setHgap(-200);
            ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this.tfdHost, (String)ConnectionDialogArb.getString(7));
            ResourceUtils.resLabel((JLabel)this.jLabel2, (Component)this.tfdPort, (String)ConnectionDialogArb.getString(8));
            ResourceUtils.resButton((AbstractButton)this.btnSid, (String)ConnectionDialogArb.getString(13));
            ResourceUtils.resButton((AbstractButton)this.btnService, (String)ConnectionDialogArb.getString(14));
            this.group.add(this.btnSid);
            this.group.add(this.btnService);
            this.add((Component)this.jLabel1, null);
            this.add((Component)this.tfdHost, null);
            this.add((Component)this.jLabel2, null);
            this.add((Component)this.tfdPort, null);
            this.add((Component)this.btnSid, null);
            this.add((Component)this.tfdSid, null);
            this.add((Component)this.btnService, null);
            this.add((Component)this.tfdService, null);
            SpringLayout springLayout = new SpringLayout();
            this.setLayout(springLayout);
            springLayout.putConstraint("West", (Component)this.jLabel1, 5, "West", (Component)this.jLabel1.getParent());
            springLayout.putConstraint("North", (Component)this.jLabel1, 10, "North", (Component)this.jLabel1.getParent());
            springLayout.putConstraint("North", (Component)this.tfdHost, 0, "North", (Component)this.jLabel1);
            springLayout.putConstraint("East", (Component)this.tfdHost, 0, "East", (Component)this.tfdService);
            springLayout.putConstraint("West", (Component)this.tfdHost, 0, "West", (Component)this.tfdService);
            springLayout.putConstraint("West", (Component)this.jLabel2, 5, "West", (Component)this.jLabel2.getParent());
            springLayout.putConstraint("North", (Component)this.jLabel2, 10, "South", (Component)this.jLabel1);
            springLayout.putConstraint("North", (Component)this.tfdPort, 0, "North", (Component)this.jLabel2);
            springLayout.putConstraint("East", (Component)this.tfdPort, 0, "East", (Component)this.tfdService);
            springLayout.putConstraint("West", (Component)this.tfdPort, 0, "West", (Component)this.tfdService);
            springLayout.putConstraint("West", (Component)this.btnSid, 5, "West", (Component)this.btnSid.getParent());
            springLayout.putConstraint("North", (Component)this.btnSid, 10, "South", (Component)this.jLabel2);
            springLayout.putConstraint("North", (Component)this.tfdSid, 0, "North", (Component)this.btnSid);
            springLayout.putConstraint("East", (Component)this.tfdSid, 0, "East", (Component)this.tfdService);
            springLayout.putConstraint("West", (Component)this.tfdSid, 0, "West", (Component)this.tfdService);
            springLayout.putConstraint("West", (Component)this.btnService, 5, "West", (Component)this.btnService.getParent());
            springLayout.putConstraint("North", (Component)this.btnService, 5, "South", (Component)this.btnSid);
            springLayout.putConstraint("West", (Component)this.tfdService, 5, "East", (Component)this.btnService);
            springLayout.putConstraint("North", (Component)this.tfdService, 0, "North", (Component)this.btnService);
            springLayout.putConstraint("East", (Component)this.tfdHost.getParent(), 5, "East", (Component)this.tfdService);
        }
    }

    private class AdvancedPanel
    extends JPanel
    implements CDComponentView {
        private JLabel jLabel1 = new JLabel();
        private JTextArea tfdUrl = new JTextArea();

        public AdvancedPanel() {
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void populateComponent(ConnectionDescriptor connectionDescriptor) {
            connectionDescriptor.put((Object)"URL", (Object)this.tfdUrl.getText());
        }

        private void jbInit() throws Exception {
            this.add((Component)this.jLabel1, null);
            JScrollPane jScrollPane = new JScrollPane(this.tfdUrl);
            this.add((Component)jScrollPane, null);
            ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this.tfdUrl, (String)ConnectionDialogArb.getString(15));
            SpringLayout springLayout = new SpringLayout();
            this.setLayout(springLayout);
            springLayout.putConstraint("West", (Component)this.jLabel1, 5, "West", (Component)this.jLabel1.getParent());
            springLayout.putConstraint("North", (Component)this.jLabel1, 10, "North", (Component)this.jLabel1.getParent());
            springLayout.putConstraint("North", (Component)jScrollPane, 10, "South", (Component)this.jLabel1);
            springLayout.putConstraint("West", (Component)jScrollPane, 5, "West", (Component)jScrollPane.getParent());
            springLayout.putConstraint("East", (Component)jScrollPane.getParent(), 5, "East", (Component)jScrollPane);
            springLayout.putConstraint("South", (Component)jScrollPane.getParent(), 10, "South", (Component)jScrollPane);
        }
    }

    private class TNSPanel
    extends JPanel
    implements CDComponentView {
        private JRadioButton btnTns = new JRadioButton();
        private JRadioButton btnSqlNet = new JRadioButton();
        private JTextField tfdSqlNetName = new JTextField(15);
        private ButtonGroup group = new ButtonGroup();
        private DataModel model = new DataModel();
        private JComboBox cbxTnsName = new JComboBox(this.model);

        public TNSPanel() {
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void populateComponent(ConnectionDescriptor connectionDescriptor) {
            if (this.btnTns.isSelected()) {
                int n = this.cbxTnsName.getSelectedIndex();
                if (n >= 0) {
                    String string = (String)this.cbxTnsName.getSelectedItem();
                    connectionDescriptor.put((Object)"URL", (Object)string);
                }
            } else if (this.btnSqlNet.isSelected()) {
                String string = OCI_URL + this.tfdSqlNetName.getText();
                connectionDescriptor.put((Object)"URL", (Object)string);
            }
        }

        private void jbInit() throws Exception {
            ResourceUtils.resButton((AbstractButton)this.btnTns, (String)ConnectionDialogArb.getString(18));
            ResourceUtils.resButton((AbstractButton)this.btnSqlNet, (String)ConnectionDialogArb.getString(19));
            this.group.add(this.btnTns);
            this.group.add(this.btnSqlNet);
            this.add((Component)this.btnTns, null);
            this.add((Component)this.cbxTnsName, null);
            this.add((Component)this.tfdSqlNetName, null);
            this.add((Component)this.btnSqlNet, null);
            SpringLayout springLayout = new SpringLayout();
            this.setLayout(springLayout);
            springLayout.putConstraint("West", (Component)this.btnTns, 5, "West", (Component)this.btnTns.getParent());
            springLayout.putConstraint("North", (Component)this.btnTns, 10, "North", (Component)this.btnTns.getParent());
            springLayout.putConstraint("North", (Component)this.cbxTnsName, 0, "North", (Component)this.btnTns);
            springLayout.putConstraint("East", (Component)this.cbxTnsName.getParent(), 5, "East", (Component)this.cbxTnsName);
            springLayout.putConstraint("West", (Component)this.btnSqlNet, 0, "West", (Component)this.btnTns);
            springLayout.putConstraint("North", (Component)this.btnSqlNet, 10, "South", (Component)this.btnTns);
            springLayout.putConstraint("North", (Component)this.tfdSqlNetName, 0, "North", (Component)this.btnSqlNet);
            springLayout.putConstraint("East", (Component)this.cbxTnsName, 0, "East", (Component)this.tfdSqlNetName);
            springLayout.putConstraint("West", (Component)this.cbxTnsName, 0, "West", (Component)this.tfdSqlNetName);
            springLayout.putConstraint("West", (Component)this.tfdSqlNetName, 5, "East", (Component)this.btnSqlNet);
        }

        private class DataModel
        extends DefaultComboBoxModel {
            List data = null;

            private DataModel() {
            }

            public void setData(List list) {
                assert (list != null);
                this.data = list;
                TNSPanel.this.cbxTnsName.updateUI();
            }

            public List getData() {
                return this.data;
            }

            public ConnectionDescriptor getRowData(int n) {
                return (ConnectionDescriptor)this.data.get(n);
            }

            public Object getElementAt(int n) {
                return this.getRowData(n).getConnectionName();
            }

            public int getSize() {
                return this.data != null ? this.data.size() : 0;
            }
        }
    }

    private static interface CDComponentView {
        public void populateComponent(ConnectionDescriptor var1);
    }

    private class ConnectionModel
    extends AbstractTableModel {
        List data = null;

        private ConnectionModel() {
        }

        public void setData(List list) {
            assert (list != null);
            this.data = list;
        }

        public List getData() {
            return this.data;
        }

        public String getColumnName(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = ConnectionDialogArb.getString(4);
                    break;
                }
                case 1: {
                    string = ConnectionDialogArb.getString(5);
                }
            }
            return string;
        }

        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.getRowData(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = connectionDescriptor.getConnectionName();
                    break;
                }
                case 1: {
                    String string2;
                    String string3 = connectionDescriptor.getHostname();
                    if (string3 != null) {
                        string2 = connectionDescriptor.getJdbcPort();
                        String string4 = connectionDescriptor.getSid();
                        string4 = string4 != null ? string4 : connectionDescriptor.get((Object)"ServiceName").toString();
                        string = "//" + connectionDescriptor.getHostname() + ":" + (string2 != null ? string2 : "1521") + "/" + string4;
                    } else {
                        string2 = connectionDescriptor.getURL();
                        string = string2.substring(string2.lastIndexOf(64) + 1);
                    }
                    string2 = connectionDescriptor.getUsername() != null ? connectionDescriptor.getUsername() : "";
                    string = string2 + "@" + string;
                }
            }
            return string;
        }

        public Object getRowData(int n) {
            return this.data.get(n);
        }
    }
}

