/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.importdata;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.dbtools.raptor.dialogs.importdata.ExcelColumnPosition;
import oracle.dbtools.raptor.dialogs.importdata.ExcelComboCellEditor;
import oracle.dbtools.raptor.dialogs.importdata.ExcelDDLGenerator;
import oracle.dbtools.raptor.dialogs.importdata.ExcelOracleColumnType;
import oracle.dbtools.raptor.dialogs.importdata.Item;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelTabPanel
extends JTabbedPane {
    private ArrayList<String> dml = null;
    private DBObject m_dbObject;
    private static final long serialVersionUID = -6989734787770379596L;
    private Shuttle colChooserShuttle;
    private DefaultListModel fromModel;
    private DefaultListModel toModel;
    private JList fromList;
    private JList toList;
    private ListPicker fromPicker;
    private ListPicker toPicker;
    private DefaultTableModel dataTypesModel;
    private DefaultTableModel previewTableModel;
    private JTable dataTypeTable;
    private JTextPane sqlPane;
    private JTextPane dmlPane;
    private HSSFSheet sheet;
    private Column[] objcols;
    private boolean m_header;
    private ArrayList<ExcelOracleColumnType> colDetails;
    private boolean existingDBObject = false;
    private Item[] items;
    private ExcelComboCellEditor cellEditor;
    private ArrayList<ExcelColumnPosition> excelColumnPositions;

    public ExcelTabPanel() {
        this.createGUI();
        this.m_header = true;
    }

    public ExcelTabPanel(DBObject dBObject) {
        this.m_dbObject = dBObject;
        this.setupColumns();
        this.existingDBObject = true;
        this.m_header = true;
        this.createGUI();
    }

    private void setupColumns() {
        this.objcols = ((Relation)this.m_dbObject.getSchemaObject()).getColumns();
    }

    private void createGUI() {
        this.addTab("Columns", null, this.CreateColumnChooser(), null);
        this.addTab("Data Types", null, this.CreateDataTypesPanel(), null);
        if (!this.existingDBObject) {
            this.addTab("DDL", null, this.createDDLPane(), null);
        }
        this.addTab("DML", null, this.createDMLPanel(), null);
        this.setupChangeListener(this);
        this.initialiseDataTypesPositions();
    }

    private void initialiseDataTypesPositions() {
        this.excelColumnPositions = new ArrayList();
    }

    private void setupChangeListener(ExcelTabPanel excelTabPanel) {
        excelTabPanel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof JTabbedPane) {
                    ExcelTabPanel.this.refresh();
                }
            }
        });
    }

    private Component CreateDataTypesPanel() {
        Object[] objectArray = new String[]{"Column", this.m_dbObject.getObjectName(), "DataType", "Size/Precision", "Scale", "Format"};
        this.dataTypesModel = new DefaultTableModel(){
            private static final long serialVersionUID = -6130641237522009123L;

            public boolean isCellEditable(int n, int n2) {
                if (n2 == 2) {
                    return this.getValueAt(n, 2) == null;
                }
                if (n2 == 3) {
                    return this.getValueAt(n, 3) == null;
                }
                if (n2 == 4) {
                    return this.getValueAt(n, 4) == null;
                }
                if (n2 == 5 && !this.getValueAt(n, 2).toString().toUpperCase().startsWith("TIMESTAMP") && !this.getValueAt(n, 2).toString().toUpperCase().startsWith("DATE")) {
                    return this.getValueAt(n, 5) == null;
                }
                return super.isCellEditable(n, n2);
            }
        };
        this.dataTypesModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                if (n == 1) {
                    for (int i = 0; i < ExcelTabPanel.this.objcols.length; ++i) {
                        if (!ExcelTabPanel.this.dataTypesModel.getValueAt(n2, n).toString().equals(ExcelTabPanel.this.objcols[i].getName())) continue;
                        try {
                            string = DataTypeHelper.getDataType((DataTypeUsage)ExcelTabPanel.this.objcols[i].getDataTypeUsage()).toString();
                            DataTypeUsage dataTypeUsage = ExcelTabPanel.this.objcols[i].getDataTypeUsage();
                            if (string.toUpperCase().startsWith("VARCHAR")) {
                                string2 = dataTypeUsage.getAttributeValue("size").toString();
                                string3 = "";
                                string4 = "";
                                continue;
                            }
                            if (string.toUpperCase().equals("CLOB") || string.toUpperCase().equals("BLOB")) {
                                string2 = "";
                                string3 = "";
                                string4 = "";
                                continue;
                            }
                            if (string.toUpperCase().equals("CHAR") || string.toUpperCase().equals("DATE") || string.toUpperCase().equals("TIMESTAMP")) {
                                string2 = "";
                                string3 = "";
                                continue;
                            }
                            string2 = "";
                            string3 = "";
                            string4 = "";
                            continue;
                        }
                        catch (DBException dBException) {
                            ExceptionHandler.handleException((Exception)((Object)dBException));
                        }
                    }
                    ExcelTabPanel.this.dataTypesModel.setValueAt(string, n2, 2);
                    ExcelTabPanel.this.dataTypesModel.setValueAt(string2, n2, 3);
                    ExcelTabPanel.this.dataTypesModel.setValueAt(string3, n2, 4);
                    ExcelTabPanel.this.dataTypesModel.setValueAt(string4, n2, 5);
                }
            }
        });
        this.dataTypesModel.setColumnIdentifiers(objectArray);
        this.dataTypesModel.fireTableDataChanged();
        this.dataTypeTable = new JTable();
        this.dataTypeTable.setModel(this.dataTypesModel);
        this.getColumnChoiceChanges();
        this.cellEditor = this.getNewCellEditor();
        this.dataTypeTable.getColumnModel().getColumn(1).setCellEditor(this.cellEditor);
        JScrollPane jScrollPane = new JScrollPane(this.dataTypeTable, 20, 31);
        jScrollPane.setName("datatypes");
        return jScrollPane;
    }

    private ExcelComboCellEditor getNewCellEditor() {
        this.items = this.convert2Item(this.getComboList(this.m_dbObject));
        this.cellEditor = new ExcelComboCellEditor(this.items);
        this.cellEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                if (jComboBox.getSelectedItem() != null) {
                    ExcelTabPanel.this.stopTypeTableEditing();
                }
            }
        });
        return this.cellEditor;
    }

    private Component CreateColumnChooser() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setName("columns");
        this.colChooserShuttle = this.createShuttle();
        jPanel.add((Component)this.colChooserShuttle, gridBagConstraints);
        return jPanel;
    }

    private JPanel createDDLPane() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("ddl");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        gridBagConstraints.fill = 1;
        this.sqlPane = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane(this.sqlPane, 20, 31);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private Component createDMLPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("dml");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        gridBagConstraints.fill = 1;
        this.dmlPane = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane(this.dmlPane, 20, 31);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    protected void setDDL() {
        String string = ExcelDDLGenerator.generateDDL("TEST", this.dataTypesModel);
        this.sqlPane.setText(this.dataTypesModel.getRowCount() < 1 ? "NO SQL" : string);
        this.colDetails = ExcelDDLGenerator.getOracleTypePosition(this.dataTypesModel, this.excelColumnPositions);
    }

    private void getColumnChoiceChanges() {
        int n;
        ArrayList<foundObject> arrayList = new ArrayList<foundObject>();
        if (this.toModel.getSize() > 0) {
            for (int i = 0; i < this.dataTypesModel.getRowCount(); ++i) {
                foundObject foundObject2 = new foundObject();
                String string = this.dataTypesModel.getValueAt(i, 0).toString();
                foundObject2.setName(string);
                foundObject2.setRow(i);
                boolean bl = false;
                for (int j = 0; j < this.getToModel().getSize(); ++j) {
                    if (!string.equals(this.toModel.getElementAt(j).toString())) continue;
                    bl = true;
                }
                foundObject2.found = bl;
                arrayList.add(foundObject2);
            }
            foundObject[] foundObjectArray = arrayList.toArray(new foundObject[arrayList.size()]);
            for (n = foundObjectArray.length - 1; n > 0; --n) {
                if (foundObjectArray[n].isFound() || this.dataTypesModel.getRowCount() <= 0) continue;
                this.dataTypesModel.removeRow(foundObjectArray[n].getRow());
            }
        } else {
            int n2;
            for (n = n2 = this.dataTypesModel.getRowCount(); n > 0; --n) {
                this.dataTypesModel.removeRow(n - 1);
            }
        }
        this.dataTypesModel.fireTableDataChanged();
        for (int i = 0; i < this.getToModel().getSize(); ++i) {
            n = 0;
            for (int j = 0; j < this.dataTypesModel.getRowCount(); ++j) {
                if (!this.getToModel().getElementAt(i).toString().equals(this.dataTypesModel.getValueAt(j, 0))) continue;
                n = 1;
            }
            if (n != 0 || this.getToModel().getSize() <= 0) continue;
            Object[] objectArray = new Object[]{this.getToModel().getElementAt(i), "Choose Data Type", this.getProbabType(this.sheet, (String)this.getToModel().getElementAt(i)), "", "", ""};
            this.dataTypesModel.addRow(objectArray);
            this.dataTypesModel.fireTableDataChanged();
        }
    }

    private String getProbabType(HSSFSheet hSSFSheet, String string) {
        return "VARCHAR2";
    }

    private String[] getComboList(DBObject dBObject) {
        Column[] columnArray = ((Relation)dBObject.getSchemaObject()).getColumns();
        String[] stringArray = new String[columnArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            stringArray[i] = columnArray[i].getName();
        }
        return stringArray;
    }

    private Item[] convert2Item(String[] stringArray) {
        Item[] itemArray = new Item[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Item item;
            itemArray[i] = item = new Item(stringArray[i], false);
        }
        return itemArray;
    }

    private Shuttle createShuttle() {
        Shuttle shuttle = new Shuttle();
        this.fromModel = new DefaultListModel();
        this.toModel = new DefaultListModel();
        this.fromList = new JList();
        this.toList = new JList();
        this.fromPicker = new ListPicker(this.fromList);
        this.toPicker = new ReorderableListPicker(this.toList);
        shuttle.setToPicker((ItemPicker)this.toPicker);
        shuttle.setFromPicker((ItemPicker)this.fromPicker);
        this.fromList.setModel(this.fromModel);
        this.toList.setModel(this.toModel);
        shuttle.add((Component)new JLabel("Available Columns"), (Object)"FromHeader");
        shuttle.add((Component)new JLabel("Selected Columns"), (Object)"ToHeader");
        return shuttle;
    }

    public DefaultListModel getFromModel() {
        return this.fromModel;
    }

    public void setFromModel(DefaultListModel defaultListModel) {
        this.fromModel = defaultListModel;
    }

    public DefaultListModel getToModel() {
        return this.toModel;
    }

    public void setToModel(DefaultListModel defaultListModel) {
        this.toModel = defaultListModel;
    }

    public void populateShuttle(DefaultTableModel defaultTableModel, JTable jTable) {
        this.m_header = false;
        this.fromModel.removeAllElements();
        this.toModel.removeAllElements();
        this.previewTableModel = defaultTableModel;
        TableColumnModel tableColumnModel = jTable.getTableHeader().getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            this.fromModel.add(i, tableColumnModel.getColumn(i).getHeaderValue().toString());
        }
        this.toModel.removeAllElements();
    }

    public void refreshExcelColumnPositions() {
        this.excelColumnPositions.clear();
        for (int i = 0; i < this.previewTableModel.getColumnCount(); ++i) {
            ExcelColumnPosition excelColumnPosition = new ExcelColumnPosition();
            excelColumnPosition.setName(this.previewTableModel.getColumnName(i));
            if (this.m_header) {
                for (short s = 0; s < this.sheet.getRow(0).getLastCellNum(); s = (short)(s + 1)) {
                    HSSFCell hSSFCell = this.sheet.getRow(0).getCell(s);
                    String string = (String)this.getStringValue(hSSFCell);
                    if (!string.equalsIgnoreCase(excelColumnPosition.getName())) continue;
                    excelColumnPosition.setColumn(s);
                }
            } else {
                excelColumnPosition.setColumn(i);
            }
            this.excelColumnPositions.add(excelColumnPosition);
        }
    }

    public void populateShuttle(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet, DefaultTableModel defaultTableModel) {
        this.previewTableModel = defaultTableModel;
        this.m_header = true;
        HSSFSheet hSSFSheet2 = hSSFSheet == null ? hSSFWorkbook.getSheetAt(0) : hSSFSheet;
        this.sheet = hSSFSheet;
        this.fromModel.removeAllElements();
        this.toModel.removeAllElements();
        HSSFRow hSSFRow = hSSFSheet2.getRow(0);
        if (hSSFRow != null) {
            for (short s = 0; s < hSSFRow.getLastCellNum(); s = (short)(s + 1)) {
                this.fromModel.add(s, this.getStringValue(hSSFRow.getCell(s)));
            }
            this.toModel.removeAllElements();
        }
    }

    private Object getStringValue(HSSFCell hSSFCell) {
        switch (hSSFCell.getCellType()) {
            case 1: {
                return hSSFCell.getStringCellValue() == null ? "" : hSSFCell.getStringCellValue();
            }
            case 3: {
                return "";
            }
            case 0: {
                return hSSFCell.getCellNum() + "";
            }
            case 4: {
                if (hSSFCell.getBooleanCellValue()) {
                    return "true";
                }
                return "false";
            }
        }
        return hSSFCell.getStringCellValue();
    }

    public void switchSheet(HSSFWorkbook hSSFWorkbook, HSSFSheet hSSFSheet) {
        this.populateShuttle(hSSFWorkbook, hSSFSheet, this.previewTableModel);
    }

    public boolean isFormatEntered() {
        boolean bl = true;
        int n = this.dataTypesModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!this.dataTypesModel.getValueAt(i, 2).toString().toUpperCase().startsWith("TIMESTAMP") && !this.dataTypesModel.getValueAt(i, 2).toString().toUpperCase().startsWith("DATE") || this.dateFormatCorrect((String)this.dataTypesModel.getValueAt(i, 5))) continue;
            bl = false;
        }
        return bl;
    }

    private boolean dateFormatCorrect(String string) {
        try {
            OraSimpleDateFormat oraSimpleDateFormat = new OraSimpleDateFormat(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public String[] getSelectedColumns(DefaultListModel defaultListModel) {
        return (String[])this.toModel.toArray();
    }

    public void setWorkSheet(HSSFSheet hSSFSheet) {
        this.sheet = hSSFSheet;
    }

    public HSSFSheet getWorkSheet() {
        return this.sheet;
    }

    public void refresh() {
        this.getColumnChoiceChanges();
        this.refreshExcelColumnPositions();
        if (!this.existingDBObject) {
            this.setDDL();
        }
        this.setDML();
    }

    private void stopTypeTableEditing() {
        int n = this.dataTypeTable.getSelectedRow();
        int n2 = this.dataTypeTable.getSelectedColumn();
        if (n != -1 && n2 != -1 && this.dataTypeTable.getValueAt(n, n2) != null) {
            this.dataTypeTable.getCellEditor(n, n2).stopCellEditing();
        }
    }

    private void setDML() {
        this.colDetails = ExcelDDLGenerator.getOracleTypePosition(this.dataTypesModel, this.excelColumnPositions);
        int n = 5;
        if (this.dataTypesModel.getRowCount() > 0) {
            this.dml = ExcelDDLGenerator.generateDML(this.existingDBObject ? this.m_dbObject.getObjectName() : "Test", this.dataTypesModel, this.getWorkSheet(), this.excelColumnPositions, this.m_header);
            if (this.dml.size() < n) {
                n = this.dml.size();
            }
            String string = "";
            for (int i = 0; i < n; ++i) {
                string = string + this.dml.get(i) + "\n";
            }
            this.dmlPane.setText(string);
        } else {
            this.dmlPane.setText("No DML");
        }
    }

    public void setDbObject(DBObject dBObject) {
        this.m_dbObject = dBObject;
    }

    public ArrayList<ExcelOracleColumnType> getColumnsForInsert() {
        return this.colDetails;
    }

    public ArrayList<String> getDML() {
        return this.dml;
    }

    public void refreshAndReset() {
        this.refresh();
        this.cellEditor = this.getNewCellEditor();
        this.dataTypeTable.getColumnModel().getColumn(1).setCellEditor(this.cellEditor);
    }

    private class foundObject {
        private String name = "";
        private boolean found = false;
        private int row;

        private foundObject() {
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int n) {
            this.row = n;
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean bl) {
            this.found = bl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

