/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.importdata;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.importdata.ExcelImportDialog;
import oracle.dbtools.raptor.dialogs.importdata.ExcelOracleColumnType;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.log.LogManager;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelImportUtil {
    private static boolean CANCELED = false;

    static void insertExcelToTable(URL uRL, DBObject dBObject) throws IOException {
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)new FileInputStream(uRL.getFile().toString()));
        ExcelImportDialog excelImportDialog = new ExcelImportDialog();
        excelImportDialog.displayExcelDialog(hSSFWorkbook, dBObject);
    }

    private static void doTableInsert(DBObject dBObject, String string, ArrayList arrayList) {
        DBUtil dBUtil = new DBUtil();
        dBUtil.setRaiseError(true);
        Log.log("INSERTING INTO " + dBObject.getSchemaName() + "." + dBObject.getObjectName());
        dBUtil.executeUpdate(dBObject.getConnectionName(), string, arrayList);
    }

    static void insertExcelFromModel(HSSFSheet hSSFSheet, ArrayList<ExcelOracleColumnType> arrayList, DBObject dBObject, boolean bl) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        String string = ExcelImportUtil.getSqlFromModel(arrayList, dBObject.getObjectName());
        for (int i = 0; i < hSSFSheet.getLastRowNum(); ++i) {
            try {
                if (bl) {
                    if (i == 0) continue;
                    ExcelImportUtil.doTableInsert(dBObject, string, ExcelImportUtil.getSqlModelBinds(arrayList, hSSFSheet.getRow(i)));
                    continue;
                }
                ExcelImportUtil.doTableInsert(dBObject, string, ExcelImportUtil.getSqlModelBinds(arrayList, hSSFSheet.getRow(i)));
                continue;
            }
            catch (Exception exception) {
                arrayList2.add(new Integer(i));
                System.out.println("Bad row " + i + "\n");
            }
        }
    }

    private static ArrayList<Object> getSqlModelBinds(ArrayList<ExcelOracleColumnType> arrayList, HSSFRow hSSFRow) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (ExcelOracleColumnType excelOracleColumnType : arrayList) {
            HSSFCell hSSFCell = hSSFRow.getCell((short)excelOracleColumnType.getExcelSheetPostion());
            if (hSSFCell == null) {
                arrayList2.add(DBUtil.NULL_VALUE);
                continue;
            }
            if (excelOracleColumnType.getDataType().toUpperCase().equals("NUMBER")) {
                arrayList2.add(new BigDecimal(ExcelImportUtil.getCellContents(hSSFCell)));
                continue;
            }
            arrayList2.add(ExcelImportUtil.getCellContents(hSSFCell));
        }
        return arrayList2;
    }

    private static String getCellContents(HSSFCell hSSFCell) {
        String string = "";
        if (hSSFCell == null) {
            string = null;
        } else {
            switch (hSSFCell.getCellType()) {
                case 3: {
                    string = "";
                    break;
                }
                case 4: {
                    string = hSSFCell.getBooleanCellValue() ? "0" : "1";
                    break;
                }
                case 0: {
                    string = String.valueOf(hSSFCell.getNumericCellValue());
                    break;
                }
                case 1: {
                    string = hSSFCell.getStringCellValue();
                    break;
                }
            }
        }
        return string;
    }

    private static String getSqlFromModel(ArrayList<ExcelOracleColumnType> arrayList, String string) {
        String string2 = "INSERT INTO " + string + " ";
        String string3 = "(";
        String string4 = "(";
        Iterator<ExcelOracleColumnType> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ExcelOracleColumnType excelOracleColumnType = null;
            if (iterator.hasNext() && !(excelOracleColumnType = iterator.next()).getOracleColName().equals("")) {
                string4 = string4 + ",";
                string3 = string3 + ",";
            }
            string4 = string4 + excelOracleColumnType.getOracleColName();
            string3 = string3 + "?";
        }
        string4 = string4 + ")";
        string3 = string3 + ")";
        string2 = string2 + string4 + " VALUES " + string3;
        return string2;
    }

    public static int insertExcelFromModel(DBObject dBObject, ArrayList<String> arrayList) {
        CANCELED = false;
        int n = 0;
        int n2 = 0;
        DBUtil dBUtil = new DBUtil();
        dBUtil.setRaiseError(false);
        Log.log("INSERTING INTO " + dBObject.getSchemaName() + "." + dBObject.getObjectName());
        HashMap hashMap = new HashMap();
        if (arrayList != null) {
            int n3 = 0;
            LogManager.getIdeLogWindow().show();
            LogManager.getIdeLogWindow().log((Object)("\n\nImporting into " + dBObject.getObjectName() + "\n"));
            String string = "";
            for (String string2 : arrayList) {
                int n4;
                if (CANCELED) {
                    n4 = dBUtil.executeUpdate(dBObject.getConnectionName(), "commit", hashMap);
                    LogManager.getIdeLogWindow().log((Object)("IMPORT into table " + dBObject.getObjectName() + " cancelled\n"));
                    LogManager.getIdeLogWindow().log((Object)("Inserted " + n2 + "rows.\n"));
                    if (n > 0) {
                        LogManager.getIdeLogWindow().log((Object)("Failed to insert " + n + "rows.\n"));
                        LogManager.getIdeLogWindow().log((Object)("SQL Error:" + string));
                    }
                    return n;
                }
                ++n3;
                n4 = 0;
                n4 = dBUtil.executeUpdate(dBObject.getConnectionName(), ExcelImportUtil.strip(string2), hashMap);
                string = dBUtil.getCurrentError();
                if (n4 < 1) {
                    ++n;
                    LogManager.getIdeLogWindow().log((Object)("\nError at line " + n3 + ":" + ExcelImportUtil.strip(string2)));
                    continue;
                }
                ++n2;
            }
            int n5 = dBUtil.executeUpdate(dBObject.getConnectionName(), "commit", hashMap);
            LogManager.getIdeLogWindow().log((Object)("IMPORT into table " + dBObject.getObjectName() + " complete\n"));
            LogManager.getIdeLogWindow().log((Object)("Inserted " + n2 + " rows.\n"));
            if (n > 0) {
                LogManager.getIdeLogWindow().log((Object)("Failed to insert " + n + " rows.\n"));
                LogManager.getIdeLogWindow().log((Object)("SQL Error:" + string));
            }
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"No columns selected for insert.", (String)"Excel Import Selection Error", null);
        }
        return n;
    }

    private static String strip(String string) {
        String string2 = string;
        string2 = string2.replaceAll("\n", "");
        string2 = string2.replaceAll("\r", "");
        string2 = string2.replaceAll("\t", "");
        string2 = string2.replaceAll(";", "");
        return string2;
    }

    public static void cancel() {
        CANCELED = true;
    }
}

