/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.importdata;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.dialogs.importdata.ExcelColumnPosition;
import oracle.dbtools.raptor.dialogs.importdata.ExcelOracleColumnType;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelDDLGenerator {
    public static String generateDDL(String string, DefaultTableModel defaultTableModel) {
        String string2 = "Create Table ";
        string2 = string2 + string + " (\n";
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            string2 = string2 + defaultTableModel.getValueAt(i, 1) + " " + defaultTableModel.getValueAt(i, 0);
            if (i >= defaultTableModel.getRowCount()) continue;
            string2 = string2 + ",\n";
        }
        string2 = string2 + ");\n";
        return string2;
    }

    public static ArrayList<ExcelOracleColumnType> getOracleTypePosition(DefaultTableModel defaultTableModel, ArrayList<ExcelColumnPosition> arrayList) {
        ArrayList<ExcelOracleColumnType> arrayList2 = new ArrayList<ExcelOracleColumnType>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ExcelOracleColumnType excelOracleColumnType = new ExcelOracleColumnType();
            excelOracleColumnType.setName(arrayList.get(i).getName());
            excelOracleColumnType.setExcelSheetPostion(arrayList.get(i).getColumn());
            for (int j = 0; j < defaultTableModel.getRowCount(); ++j) {
                if (!defaultTableModel.getValueAt(j, 0).toString().equalsIgnoreCase(arrayList.get(i).getName())) continue;
                excelOracleColumnType.setOracleColName(defaultTableModel.getValueAt(j, 1).toString());
                excelOracleColumnType.setDataType((String)defaultTableModel.getValueAt(j, 2));
                excelOracleColumnType.setDataTypeModelPostion(j);
                excelOracleColumnType.setFormat((String)defaultTableModel.getValueAt(j, 5));
            }
            if (excelOracleColumnType.getOracleColName().equals("")) continue;
            arrayList2.add(excelOracleColumnType);
        }
        return arrayList2;
    }

    public static ArrayList<String> generateDML(String string, DefaultTableModel defaultTableModel, HSSFSheet hSSFSheet, ArrayList<ExcelColumnPosition> arrayList, boolean bl) {
        int n;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<ExcelOracleColumnType> arrayList3 = ExcelDDLGenerator.getOracleTypePosition(defaultTableModel, arrayList);
        int n2 = 0;
        n2 = defaultTableModel.getRowCount() > 0 && !bl ? 0 : 1;
        String string2 = "(";
        for (n = 0; n < arrayList3.size(); ++n) {
            string2 = string2 + arrayList3.get(n).getOracleColName();
            int n3 = n + 1;
            if (arrayList3.get(n).getOracleColName().equals("")) continue;
            string2 = n3 < defaultTableModel.getRowCount() ? string2 + "," : string2 + ")";
        }
        for (n = n2; n <= hSSFSheet.getLastRowNum(); ++n) {
            String string3 = " VALUES(";
            HSSFRow hSSFRow = hSSFSheet.getRow(n);
            for (int i = 0; i < arrayList3.size(); ++i) {
                boolean bl2 = false;
                HSSFCell hSSFCell = hSSFRow.getCell((short)arrayList3.get(i).getExcelSheetPostion());
                String string4 = "";
                if (hSSFCell == null) {
                    string4 = "NULL";
                    bl2 = true;
                } else {
                    int n4 = hSSFCell.getCellType();
                    switch (n4) {
                        case 4: {
                            if (hSSFCell.getBooleanCellValue()) {
                                string4 = "0";
                                break;
                            }
                            string4 = "1";
                            break;
                        }
                        case 3: {
                            if (!hSSFCell.getStringCellValue().equals("") && hSSFCell.getStringCellValue() != null && hSSFCell.getNumericCellValue() != 0.0) break;
                            string4 = "NULL";
                            bl2 = true;
                            break;
                        }
                        case 0: {
                            Comparable<Calendar> comparable;
                            double d = hSSFCell.getNumericCellValue();
                            if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell)) {
                                string4 = "'";
                                comparable = Calendar.getInstance();
                                ((Calendar)comparable).setTime(HSSFDateUtil.getJavaDate((double)d));
                                string4 = String.valueOf(((Calendar)comparable).get(1)).substring(2);
                                string4 = ((Calendar)comparable).get(2) + 1 + "/" + ((Calendar)comparable).get(5) + "/" + string4;
                                break;
                            }
                            comparable = hSSFCell.getNumericCellValue();
                            DecimalFormat decimalFormat = new DecimalFormat();
                            if ((Double)comparable != (double)Math.round((Double)comparable)) {
                                decimalFormat.applyPattern("#.#");
                            }
                            if (!(string4 = decimalFormat.format(comparable)).contains(",")) break;
                            string4 = string4.replaceAll(",", "");
                            break;
                        }
                        case 1: {
                            string4 = hSSFCell.getStringCellValue();
                            break;
                        }
                        default: {
                            string4 = hSSFCell.getStringCellValue();
                            if (!string4.equals("")) break;
                            string4 = "NULL";
                        }
                    }
                }
                string4 = ExcelDDLGenerator.processDataType(string4, arrayList3.get(i), bl2);
                string3 = string3 + string4;
                if (i >= arrayList3.size() || arrayList3.get(i).getOracleColName().equals("") || i + 1 >= arrayList3.size()) continue;
                string3 = string3 + ",";
            }
            String string5 = "insert into " + string + " " + string2 + string3 + ");\n";
            arrayList2.add(string5);
        }
        return arrayList2;
    }

    private static String processDataType(String string, ExcelOracleColumnType excelOracleColumnType, boolean bl) {
        String string2 = "";
        if (excelOracleColumnType.getDataType().toLowerCase().startsWith("varchar") || excelOracleColumnType.getDataType().toLowerCase().startsWith("char")) {
            string2 = "'" + string + "'";
        } else if (excelOracleColumnType.getDataType().toLowerCase().startsWith("timestamp")) {
            string2 = "TO_TIMESTAMP('" + string + "','" + excelOracleColumnType.getFormat() + "')";
        } else if (excelOracleColumnType.getDataType().toLowerCase().startsWith("date")) {
            string2 = "TO_DATE('" + string + "','" + excelOracleColumnType.getFormat() + "')";
        } else if (excelOracleColumnType.getDataType().toLowerCase().equals("number") || excelOracleColumnType.getDataType().toLowerCase().equals("integer")) {
            string2 = string;
        } else {
            return string;
        }
        if (bl) {
            return "NULL";
        }
        return string2;
    }
}

