/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.importdata;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import oracle.dbtools.raptor.dialogs.importdata.ExcelComboModel;
import oracle.dbtools.raptor.dialogs.importdata.Item;

public class ExcelComboCellEditor
extends JComboBox
implements TableCellEditor {
    private static final long serialVersionUID = 3688358212986310680L;
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    private ExcelComboModel model;

    public ExcelComboCellEditor(Item[] itemArray) {
        this.model = new ExcelComboModel(itemArray);
        this.setModel(this.model);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != CellEditorListener.class) continue;
            CellEditorListener cellEditorListener = (CellEditorListener)objectArray[i + 1];
            cellEditorListener.editingCanceled(this.changeEvent);
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public Object getCellEditorValue() {
        Item item = (Item)super.getSelectedItem();
        item.setUsed(true);
        return item;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.model.setSelectedItem(object);
        this.model.filter();
        return this;
    }
}

