/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.dialogs.grants.PrivilegesInfoPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;

public class RevokePrivilegesPanel
extends PrivilegesInfoPanel
implements ActionListener {
    private final ArrayList<String> _usersWithGrants = new ArrayList();
    private final HashMap<String, ArrayList> _usersPrivs = new HashMap();

    protected RevokePrivilegesPanel(DBObject dBObject) {
        super(dBObject);
        this.init();
    }

    protected void init() {
        this.populateUserGrants();
        ((DefaultComboBoxModel)this.cbxUsers.getModel()).removeAllElements();
        for (int i = 0; i < this._usersWithGrants.size(); ++i) {
            ((DefaultComboBoxModel)this.cbxUsers.getModel()).addElement(this._usersWithGrants.get(i));
        }
        this.cbxUsers.setSelectedIndex(-1);
        this.mdlPrivFrom.removeAllElements();
        this.cbxUsers.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                Object object = jComboBox.getSelectedItem();
                if (object != null) {
                    String string = (String)object;
                    try {
                        RevokePrivilegesPanel.this.mdlPrivFrom.removeAllElements();
                        for (int i = 0; i < ((ArrayList)RevokePrivilegesPanel.this._usersPrivs.get(string)).size(); ++i) {
                            RevokePrivilegesPanel.this.mdlPrivFrom.addElement(((ArrayList)RevokePrivilegesPanel.this._usersPrivs.get(string)).get(i));
                        }
                        RevokePrivilegesPanel.this.lstPrivFrom.updateUI();
                    }
                    catch (Exception exception) {
                        SQLErrorDialog.showErrorDialog(null, "Error updating privileges. ", (SQLException)exception);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateUserGrants() {
        String string = "Select GRANTEE, PRIVILEGE  from sys.all_col_privs  where TABLE_SCHEMA = :OWNER  and TABLE_NAME =  :OBJECT_NAME  union all  Select  GRANTEE, PRIVILEGE from sys.all_tab_privs where TABLE_SCHEMA = :OWNER  and TABLE_NAME = :OBJECT_NAME";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", this.getDBObject().getSchemaName());
        hashMap.put("OBJECT_NAME", this.getDBObject().getObjectName());
        DBUtil dBUtil = new DBUtil();
        ResultSet resultSet = dBUtil.executeQuery(this.getDBObject().getConnectionName(), string, hashMap);
        try {
            while (resultSet.next()) {
                if (!this._usersWithGrants.contains(resultSet.getString(1))) {
                    this._usersWithGrants.add(resultSet.getString(1));
                }
                if (this._usersPrivs.get(resultSet.getString(1)) == null) {
                    this._usersPrivs.put(resultSet.getString(1), new ArrayList());
                }
                this._usersPrivs.get(resultSet.getString(1)).add(resultSet.getString(2));
            }
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            try {
                resultSet.getStatement().close();
            }
            catch (Exception exception) {}
        }
    }

    protected void performRevoke() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("revoke ");
        if (this.chkAll.isSelected()) {
            stringBuilder.append("ALL");
        } else {
            object = this.getSelectedPrivileges();
            for (int i = 0; i < object.size(); ++i) {
                if (i != object.size() - 1) {
                    stringBuilder.append(object.get(i) + ",");
                    continue;
                }
                stringBuilder.append(object.get(i));
            }
        }
        stringBuilder.append(" on ");
        stringBuilder.append("\"" + this.getDBObject().getSchemaName() + "\".\"" + this.getDBObject().getObjectName() + "\"");
        stringBuilder.append(" from ");
        stringBuilder.append((String)this.cbxUsers.getSelectedItem());
        object = new DBUtil();
        Log.log("REVOKE:" + stringBuilder.toString());
        ((DBUtil)object).execute(this.getDBObject().getConnectionName(), stringBuilder.toString(), (List)null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.performRevoke();
        this.close(actionEvent);
    }
}

