/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.dialogs.grants.PrivilegesInfoPanel;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.util.Resource;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Database;
import oracle.javatools.dialogs.MessageDialog;

public class GrantPrivilegesPanel
extends PrivilegesInfoPanel
implements ActionListener {
    protected JCheckBox chkAdmin = new JCheckBox();

    protected GrantPrivilegesPanel(DBObject dBObject) {
        super(dBObject);
        ResourceUtils.resButton((AbstractButton)this.chkAdmin, (String)CreateDialogArb.getString(557));
        this.addItem(this.jPanel1, Translate.translate("Admin"), this.chkAdmin, true);
        this.init();
    }

    protected void init() {
        try {
            SQLComboxModel sQLComboxModel = new SQLComboxModel(this.getDBObject().getConnectionName(), "select 'PUBLIC' from dual union all select username from all_users union all select distinct role from session_roles order by 1", (ArrayList)null, null);
            this.cbxUsers.setModel(sQLComboxModel);
            this.cbxUsers.setEditable(true);
            String string = (String)this.cbxUsers.getSelectedItem();
            String[] stringArray = this.getAvailablePrivileges(string);
            this.mdlPrivFrom.removeAllElements();
            for (int i = 0; i < stringArray.length; ++i) {
                this.mdlPrivFrom.addElement(stringArray[i]);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, "Error updating privileges. ", (SQLException)exception);
            }
            exception.printStackTrace();
        }
    }

    protected String[] getAvailablePrivileges(String string) throws IOException {
        Properties properties = new Properties();
        properties.load(Resource.getResourceAsStream(this.getClass(), "privileges.properties"));
        String string2 = properties.getProperty(this.getDBObject().getObjectType().replace(' ', '_'));
        return string2.split(",");
    }

    protected void performGrant() {
        Database database = this.getDBObject().getDatabase();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("grant ");
        if (this.chkAll.isSelected()) {
            stringBuilder.append("ALL");
        } else {
            List list = this.getSelectedPrivileges();
            for (int i = 0; i < list.size(); ++i) {
                if (i != list.size() - 1) {
                    stringBuilder.append(list.get(i) + ",");
                    continue;
                }
                stringBuilder.append(list.get(i));
            }
        }
        stringBuilder.append(" on ");
        stringBuilder.append("\"" + this.getDBObject().getSchemaName() + "\".\"" + this.getDBObject().getObjectName() + "\"");
        stringBuilder.append(" to ");
        stringBuilder.append("\"" + (String)this.cbxUsers.getSelectedItem() + "\"");
        if (this.chkAdmin.isSelected()) {
            stringBuilder.append(" WITH GRANT OPTION");
        }
        Log.log("GRANTING:" + stringBuilder.toString());
        DBUtil.getInstance().execute(this.getDBObject().getConnectionName(), stringBuilder.toString(), (List)null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.cbxUsers.getSelectedItem() != null && this.cbxUsers.getSelectedItem().toString().length() > 0) {
            this.performGrant();
            this.close(actionEvent);
        } else {
            MessageDialog.error((Component)this, (Object)"User must be specified", (String)"User must be specified", null);
        }
    }
}

