/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.grants;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.grants.GrantPrivilegesPanel;
import oracle.dbtools.raptor.dialogs.grants.PrivListener;
import oracle.dbtools.raptor.dialogs.grants.RevokePrivilegesPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class GenericGrantEditor
implements Controller {
    public static String HELP_TABLE_GRANT = "f1_granttablehtml";
    public static String HELP_TABLE_REVOKE = "f1_revoketablehtml";
    private static final int GRANT_TABLE_CMD_ID = Ide.findOrCreateCmdID((String)"GRANT_TABLE_CMD_ID");
    private static final int REVOKE_TABLE_CMD_ID = Ide.findOrCreateCmdID((String)"REVOKE_TABLE_CMD_ID");
    private DBObject _dbObject;
    private Toolbar _toolbar;
    private View _view;
    private ArrayList<PrivListener> _listeners = new ArrayList();

    public GenericGrantEditor(DBObject dBObject) {
        this._dbObject = dBObject;
        this.createActions();
        this.addActionToToolbar();
    }

    public GenericGrantEditor(View view, Toolbar toolbar, DBObject dBObject) {
        this._dbObject = dBObject;
        this._view = view;
        this._toolbar = toolbar;
        this.createActions();
        this.addActionToToolbar();
    }

    public void grantPrivileges() {
        GrantPrivilegesPanel grantPrivilegesPanel = new GrantPrivilegesPanel(this._dbObject);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)grantPrivilegesPanel, null, (String)Translate.translate("Grant"), (int)10);
        jEWTDialog.addActionListener((ActionListener)grantPrivilegesPanel);
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        jEWTDialog.setPreferredSize(grantPrivilegesPanel.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
        this.firePrivChanges();
    }

    public void revokePrivileges() {
        RevokePrivilegesPanel revokePrivilegesPanel = new RevokePrivilegesPanel(this._dbObject);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)revokePrivilegesPanel, null, (String)Translate.translate("Revoke"), (int)10);
        jEWTDialog.addActionListener((ActionListener)revokePrivilegesPanel);
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        jEWTDialog.setPreferredSize(revokePrivilegesPanel.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
        this.firePrivChanges();
    }

    private void createActions() {
        IdeAction.get((int)GRANT_TABLE_CMD_ID, null, (String)CreateDialogArb.getString(549), null, null, (Icon)ConnectionArb.getIcon((int)440), null, (boolean)true).addController((Controller)this);
        IdeAction.get((int)REVOKE_TABLE_CMD_ID, null, (String)CreateDialogArb.getString(550), null, null, (Icon)ConnectionArb.getIcon((int)441), null, (boolean)true).addController((Controller)this);
    }

    public void addActionToToolbar() {
        if (this._toolbar != null) {
            JButton jButton = new JButton((Action)IdeAction.find((int)GRANT_TABLE_CMD_ID).newLocalAction(this._view));
            jButton.setToolTipText(Translate.translate("Grant"));
            this._toolbar.add((Component)jButton);
            jButton = new JButton((Action)IdeAction.find((int)REVOKE_TABLE_CMD_ID).newLocalAction(this._view));
            jButton.setToolTipText(Translate.translate("Revoke"));
            this._toolbar.add((Component)jButton);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == GRANT_TABLE_CMD_ID) {
            this.grantPrivileges();
        } else if (n == REVOKE_TABLE_CMD_ID) {
            this.revokePrivileges();
        }
        return true;
    }

    public void addPrivListener(PrivListener privListener) {
        this._listeners.add(privListener);
    }

    public void firePrivChanges() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).privledgesChanges();
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void setDBObject(DBObject dBObject) {
        this._dbObject = dBObject;
    }
}

