/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.file;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.component.NewFilePanel;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.wizard.Wizard;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.dialogs.JDevDialogHeader;
import oracle.jdevimpl.db.sqlplus.SqlFileBuilder;

public class NewSqlFile
extends Wizard {
    private Wizard _base = new SqlFileBuilder();

    public String getShortLabel() {
        return this._base.getShortLabel();
    }

    public boolean invoke(Context context) {
        final NewFilePanel newFilePanel = new NewFilePanel();
        newFilePanel.setFileExtension("sql");
        newFilePanel.setFileType(CreateDialogArb.getString(583));
        newFilePanel.setSupportsAutoFill(false);
        newFilePanel.setCanOverwriteOpenNodes(true);
        newFilePanel.setEnforceFileExtension(false);
        URL uRL = URLFactory.newDirURL((File)Resource.raptorUser);
        newFilePanel.setDirectoryURL(uRL);
        URL uRL2 = URLFactory.newUniqueURL((URL)uRL, (NameGenerator)new DefaultNameGenerator("Untitled", "sql", -1));
        newFilePanel.setFileName(URLFileSystem.getFileName((URL)uRL2));
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        int n = 7;
        HelpSystem.getHelpSystem().registerTopic((JComponent)newFilePanel, "f1_dbnewsqlfile_html");
        final JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, this.getShortLabel(), n);
        jEWTDialog.setContent((Component)newFilePanel);
        jEWTDialog.setTitle(CreateDialogArb.getString(582));
        JDevDialogHeader jDevDialogHeader = new JDevDialogHeader();
        jDevDialogHeader.setHeaderImage(null);
        jDevDialogHeader.setHeaderTitle(this.getShortLabel());
        jDevDialogHeader.setHeaderDescription(CreateDialogArb.getString(584));
        jEWTDialog.setDialogHeader((Component)jDevDialogHeader);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                    try {
                        URL uRL = newFilePanel.getFileURL();
                        SqlNode sqlNode = null;
                        try {
                            sqlNode = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)uRL);
                        }
                        catch (Exception exception) {
                            throw new TraversalException(exception.getLocalizedMessage());
                        }
                        TextBuffer textBuffer = null;
                        try {
                            textBuffer = sqlNode.acquireTextBuffer();
                            int n = textBuffer.getLength();
                            if (n > 0) {
                                textBuffer.remove(0, n);
                                UpdateMessage.fireStructureChanged((Subject)sqlNode);
                            }
                        }
                        finally {
                            if (textBuffer != null) {
                                sqlNode.releaseTextBuffer();
                            }
                        }
                        if (!URLFileSystem.exists((URL)uRL)) {
                            try {
                                URLFileSystem.openOutputStream((URL)uRL).close();
                            }
                            catch (IOException iOException) {
                                throw new TraversalException(iOException.getLocalizedMessage());
                            }
                        }
                        final SqlNode sqlNode2 = sqlNode;
                        FileOpenHistory.getInstance().updateFileHistory(uRL);
                        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                            public void run() {
                                EditorUtil.openDefaultEditorInFrame((Node)sqlNode2);
                            }
                        });
                    }
                    catch (TraversalException traversalException) {
                        traversalException.showMessageDialog((Component)jEWTDialog);
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            }
        });
        return WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    public boolean isAvailable(Context context) {
        return true;
    }

    public String getToolTipText() {
        return this._base.getToolTipText();
    }

    public String getLongLabel() {
        return CreateDialogArb.getString(585);
    }

    public Icon getIcon() {
        return this._base.getIcon();
    }
}

