/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.export;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.ide.help.HelpSystem;

public class PredicatePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String _baseSql;
    private JTextField _predicate;
    private ResultSetTable _sampleTab;
    private String _conn;
    private List _bindList = null;
    private Map _bindMap = null;
    private boolean _dirty = true;

    public PredicatePanel(String string, String string2, List list) {
        this._bindList = list;
        this.showPanel(string, string2);
    }

    public PredicatePanel(String string, String string2, Map map) {
        this._bindMap = map;
        this.showPanel(string, string2);
    }

    public PredicatePanel(String string, String string2) {
        this.showPanel(string, string2);
    }

    public void showPanel(String string, String string2) {
        this._baseSql = string2;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttablepredicate_html");
        this.setLayout(new SpringLayout());
        this._predicate = new JTextField();
        this._predicate.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    PredicatePanel.this._dirty = true;
                }
                PredicatePanel.this.showSampleData();
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        JButton jButton = new JButton();
        jButton.setText("Go");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PredicatePanel.this._dirty = true;
                PredicatePanel.this.showSampleData();
            }
        });
        this._sampleTab = new ResultSetTable();
        this._sampleTab.setTranslatedColNames(false);
        this._sampleTab.setSize(200, 200);
        this._sampleTab.setThreaded(false);
        this._sampleTab.getTableHeader().setReorderingAllowed(false);
        this._conn = string;
        this.add(new JLabel("Where clause:"));
        JPanel jPanel = new JPanel();
        this._predicate.setColumns(40);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._predicate, "Before");
        jPanel.add((Component)jButton, "After");
        this.add(jPanel);
        this.add(new JLabel("Sample data:"));
        this.add(new JScrollPane(this._sampleTab));
        SpringUtilities.makeCompactGrid(this, 2, 2, 0, 0, 2, 2);
    }

    public void showSampleData() {
        if (this._dirty && (this._sampleTab.getModel() instanceof DefaultTableModel || ((ResultSetTableModel)this._sampleTab.getModel()).getSQL() != null && !((ResultSetTableModel)this._sampleTab.getModel()).getSQL().equals(this.getSQL()))) {
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection(this._conn);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connection != null) {
                if (this._bindList != null) {
                    this._sampleTab.setQuery(connection, null, this.getSQL(), this._bindList);
                } else if (this._bindMap != null) {
                    this._sampleTab.setQuery(connection, null, this.getSQL(), this._bindMap);
                } else {
                    this._sampleTab.setQuery(connection, null, this.getSQL());
                }
            }
        }
        this._dirty = false;
    }

    public void setSQL(String string) {
        string.intern();
        if (!this._baseSql.equals(string)) {
            this._baseSql = string;
            this._dirty = true;
            this._baseSql.intern();
        }
    }

    public String getSQL() {
        return this._baseSql + " " + this.getPredicate();
    }

    public void setPredicate(String string) {
        this._predicate.setText(string);
    }

    public String getPredicate() {
        String string = this._predicate.getText();
        if (!string.equals("") && string.trim().toLowerCase().indexOf("where") != 0) {
            string = " where " + string;
        }
        return string;
    }

    public ResultSetTable getTable() {
        if (this._dirty) {
            this.showSampleData();
            this._dirty = false;
        }
        return this._sampleTab;
    }
}

