/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.FilePanel;
import oracle.dbtools.raptor.controls.JComboPanel;
import oracle.dbtools.raptor.controls.RadioGroupPanel;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.ide.help.HelpSystem;

public class ExportFormatPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String _format;
    private JComboPanel _formatGroup;
    private RadioGroupPanel _outputGroup;
    private JTextField _tableName;
    private FilePanel _file;

    public ExportFormatPanel(String string) {
        this._format = string;
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_exporttableformat_html");
        this.setLayout(new GridBagLayout());
        this._formatGroup = new JComboPanel();
        this._outputGroup = new RadioGroupPanel("STATIC:File:Clipboard");
        this._tableName = new JTextField();
        this._tableName.setSize(new Dimension(40, 1));
        this._file = new FilePanel(this);
        this.setTableFocus(this._format);
        this.add((Component)new JLabel("Format"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 0, 0), 10, 0));
        this.add((Component)this._formatGroup, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("Output"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        this.add((Component)this._outputGroup, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("Table"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 0, 0), 0, 0));
        this.add((Component)this._tableName, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(20, 0, 0, 100), 0, 0));
        this.add((Component)new JLabel("File"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        this.add((Component)this._file, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 20), 0, 0));
        this.add((Component)new JLabel("Encoding set in preferences will be used unless you select another one using the file dialog."), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._formatGroup.addActionListener(this);
        this._formatGroup.setSelectedValue(this._format);
    }

    public String getFormat() {
        return this._formatGroup.getSelectedValue();
    }

    public FilePanel getFilePanel() {
        return this._file;
    }

    public void setFileName(String string) {
        this._file.setFileName(string);
    }

    public String getFileName() {
        String string = this._file.getFileName();
        int n = string.lastIndexOf("\\");
        if (n == -1) {
            n = string.lastIndexOf("/");
            n = 0;
        }
        String string2 = string.substring(n);
        String string3 = "";
        string3 = string2.lastIndexOf(".") > -1 ? this._file.getFileName() : this._file.getFileName() + ".sql";
        if (string2.indexOf("/") != 0 && n == 0) {
            string3 = (String)DBConfig.getInstance().getParameter("EXPORTDIR") != null && !((String)DBConfig.getInstance().getParameter("EXPORTDIR")).equals("") ? (String)DBConfig.getInstance().getParameter("EXPORTDIR") + File.separator + string3 : System.getProperty("user.home") + File.separator + string3;
        }
        return string3;
    }

    public String getDestination() {
        return this._outputGroup.getSelectedValue();
    }

    public void setDefaultName(String string) {
        this._tableName.setText(string);
    }

    public String getDefaultName() {
        return this._tableName.getText();
    }

    public void setTableFocus(String string) {
        String string2 = this._file.getFileName().lastIndexOf(46) > -1 ? this._file.getFileName().substring(0, this._file.getFileName().lastIndexOf(46)) : this._tableName.getText();
        this._file.setFileName(string2 + "." + FormatRegistry.getFormatter(string).getExt());
        this._tableName.setEnabled(FormatRegistry.getFormatter(string).getPromptForTable());
        this._tableName.setFocusable(FormatRegistry.getFormatter(string).getPromptForTable());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this._formatGroup.getSelectedValue();
        this.setTableFocus(string);
    }
}

