/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;

public class ConnectionRename
extends AbstractMenuAction {
    private static final long serialVersionUID = 1L;
    private JEWTDialog dlg;
    private JTextField gName = null;
    private String oName;

    public boolean validateInput() {
        boolean bl = true;
        if (this.gName.getText() == null || this.gName.getText().trim().length() == 0) {
            LogManager.getIdeLogWindow().log((Object)"Connection Name invalid.\n");
            bl = false;
        }
        return bl;
    }

    public void ShowPanel(String string) {
        this.oName = string;
        PropertyPanel propertyPanel = new PropertyPanel();
        String string2 = Translate.translate("Rename Connection");
        JLabel jLabel = new JLabel(Translate.translate("Warning: Renaming a connection will close all open editors/viewers."));
        propertyPanel.addSingleComp(jLabel);
        String string3 = new String(Translate.translate("*Name"));
        this.gName = new JTextField();
        this.gName.setColumns(30);
        this.gName.setEditable(true);
        this.gName.setBorder(new LineBorder(Color.black, 1));
        this.gName.setText(string);
        propertyPanel.addComp(string3, this.gName);
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string2, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ConnectionRename.this.gName.getText().equals("") && ConnectionRename.this.validateInput()) {
                    Boolean bl = ConnectionRename.this.renameConnection(ConnectionRename.this.oName, ConnectionRename.this.gName.getText());
                    if (bl.booleanValue()) {
                        ConnectionRename.this.dlg.dispose();
                    } else {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Connection name exists use a different name.\n", (String)"Error", (String)"f1_connectionnamedup_html");
                    }
                }
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    boolean renameConnection(String string, String string2) {
        ConnectionManager connectionManager = ConnectionManager.getInstance();
        try {
            if (connectionManager.connectionDescriptorExists(string2)) {
                return false;
            }
            ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(string);
            ConnectionOptions connectionOptions = (ConnectionOptions)Ide.getSettings().getData("ConnectionOptions");
            if (connectionOptions != null) {
                connectionOptions.renameConnection(string, string2);
            }
            connectionManager.removeConnectionDescriptor(string);
            connectionDescriptor.setProperty("PREVIOUS_NAME", string);
            connectionManager.putConnectionDescriptor(string2, connectionDescriptor);
            URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2);
            try {
                DatabaseConnection databaseConnection = (DatabaseConnection)NodeFactory.findOrCreate(DatabaseConnection.class, (URL)uRL);
                this.setDBObject(new DBObject((Element)databaseConnection));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public void launch() {
        this.ShowPanel(this.getDBObject().getObjectName());
    }

    public void setArgs(String string) {
    }
}

