/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TogglePLScope
extends AbstractMenuAction {
    public void launch() {
        try {
            Connection connection = null;
            try {
                connection = this.getDBObject().getConnection();
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Could not connect", (String)"Connection Error", null);
                return;
            }
            int n = connection.getMetaData().getDatabaseMajorVersion();
            if (n < 11) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"This feature is supported from version 11 and above", (String)"Not supported feature", null);
                return;
            }
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            try {
                resultSet = statement.executeQuery("select value from v$parameter where lower(name) = 'plscope_settings'");
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)"Can't query v$parameter. Grant SELECT_CATALOG role to user", (String)"Permission problem", null);
                return;
            }
            resultSet.next();
            boolean bl = "IDENTIFIERS:ALL".equals(resultSet.getString("value"));
            resultSet.close();
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)("PLSCOPE identifier collection switched " + (bl ? "off" : "on")), (String)"PLSCOPE_SETTINGS", null);
            if (bl) {
                statement.execute("alter session set PLSCOPE_SETTINGS='IDENTIFIERS:NONE'");
            } else {
                statement.execute("alter session set PLSCOPE_SETTINGS='IDENTIFIERS:ALL'");
            }
            statement.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setArgs(String string) {
    }
}

