/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.dialogs.export.ColumnPanel;
import oracle.dbtools.raptor.dialogs.export.ExportFormatPanel;
import oracle.dbtools.raptor.dialogs.export.PredicatePanel;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Ide;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class TableExportAction
extends AbstractMenuAction
implements ActionListener,
ChangeListener {
    private String _format;
    private ColumnPanel _cols;
    private PredicatePanel _predicate;
    private ExportFormatPanel _formatPanel;
    private JMenu _menu;
    private String _sql;
    private Connection _conn = null;
    private String _connName;
    private String _name;
    private String _schema;
    private String _tName;
    private String _from;
    private List _bindList = null;
    private Map _bindMap = null;
    private JTable _table;
    private JEWTDialog dlg;
    private static boolean isExportInProgress = false;
    private boolean _isOracle = true;
    private boolean _isTimesTen = false;
    private TreeCellCheckedListener _colListener = new TreeCellCheckedListener(){

        public void cellChecked(TreeCellCheckedEvent treeCellCheckedEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TableExportAction.this._predicate.setSQL("select " + TableExportAction.this._cols.getSelectedColumns() + TableExportAction.this._from);
                }
            });
        }

        public void cellUnchecked(TreeCellCheckedEvent treeCellCheckedEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TableExportAction.this._predicate.setSQL("select " + TableExportAction.this._cols.getSelectedColumns() + TableExportAction.this._from);
                }
            });
        }
    };

    private void clearData() {
        this._format = null;
        this._cols = null;
        this._sql = null;
        this._conn = null;
        this._connName = null;
        this._name = null;
        this._schema = null;
        this._tName = null;
        this._from = null;
        this._bindList = null;
        this._bindMap = null;
        this._table = null;
        this.setDBObject(null);
        this.setContext(null);
        isExportInProgress = false;
    }

    public void launch() {
        this._connName = this.getDBObject().getConnectionName();
        this._isOracle = Connections.getInstance().isOracle(this._connName);
        this._isTimesTen = Connections.getInstance().isTimesTen(this._connName);
        this.setBindMap(this.getDBObject().getDictionary());
        if (this.getDBObject().getSchemaName() != null) {
            this._schema = DBUtil.getInstance().addQuotes(this._conn, this.getDBObject().getSchemaName());
        }
        this._tName = DBUtil.getInstance().addQuotes(this._conn, this.getDBObject().getObjectName());
        this._sql = this._isOracle || this._isTimesTen ? "select * from (select * from " + this._schema + "." + this._tName + ")" : (this._schema != null ? "select * from (select * from " + this._schema + "." + this._tName + ") as t" : "select * from (select * from " + DBUtil.enquote(this.getDBObject().getObjectName()) + ") as t");
        this.scrubColList();
        if (this._sql.equals("")) {
            PropertyPanel propertyPanel = new PropertyPanel();
            String string = Translate.translate("Warning Message");
            JLabel jLabel = new JLabel(Translate.translate("No valid colums available for export, we do not surrently support CLOB or BLOB columns."));
            propertyPanel.addSingleComp(jLabel);
            propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)1);
            this.dlg.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TableExportAction.this.dlg.dispose();
                }
            });
            Dimension dimension = propertyPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 100;
            int n2 = (int)dimension.getWidth() + 100;
            this.dlg.setSize(n2, n);
            this.dlg.setPreferredSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
            this.dlg.setVisible(true);
            return;
        }
        this._name = this.getDBObject().getObjectName();
        this._from = this._isOracle || this._isTimesTen ? " from (" + this._sql + ")" : " from (" + this._sql + ") as t";
        this.showPanels();
    }

    public void launchDlg() {
        this._connName = Connections.getInstance().getConnectioName(this._conn);
        this._isOracle = Connections.getInstance().isOracle(this._connName);
        this._name = this._table instanceof ResultSetTable ? ((ResultSetTable)this._table).getDefaultExportName() : "Export";
        this.scrubColList();
        if (this._sql.equals("")) {
            PropertyPanel propertyPanel = new PropertyPanel();
            String string = Translate.translate("Warning Message");
            JLabel jLabel = new JLabel(Translate.translate("No valid colums available for export, we do not currently support CLOB or BLOB columns."));
            propertyPanel.addSingleComp(jLabel);
            propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)1);
            this.dlg.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TableExportAction.this.dlg.dispose();
                }
            });
            Dimension dimension = propertyPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 100;
            int n2 = (int)dimension.getWidth() + 100;
            this.dlg.setSize(n2, n);
            this.dlg.setPreferredSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
            this.dlg.setVisible(true);
            return;
        }
        if (this._isOracle || this._isTimesTen) {
            this._sql = "select * from (\n" + this._sql + "\n)";
            this._from = " from (" + this._sql + "\n)";
        } else {
            this._sql = "select * from (\n" + this._sql + "\n) as t";
            this._from = " from (" + this._sql + "\n) as t";
        }
        this.showPanels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubColList() {
        int n = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (this._isOracle) {
                statement = Connections.getInstance().getConnection(this._connName).prepareStatement(this._sql);
                if (this._bindList != null) {
                    DBUtil.getInstance().bind((PreparedStatement)statement, this._bindList);
                } else if (this._bindMap != null) {
                    DBUtil.getInstance().bind(this._sql, (PreparedStatement)statement, this._bindMap);
                }
            } else if (this._bindMap != null) {
                this._sql = DBUtil.getInstance().prepareNonOracleSql(this._conn, this._sql, this._bindMap);
                statement = Connections.getInstance().getConnection(this._connName).prepareStatement(this._sql);
            } else if (this._bindList != null) {
                this._sql = DBUtil.getInstance().prepareNonOracleSql(this._sql);
                statement = Connections.getInstance().getConnection(this._connName).prepareStatement(this._sql);
                DBUtil.getInstance().bind((PreparedStatement)statement, this._bindList);
            }
            StringBuilder stringBuilder = new StringBuilder("select ");
            resultSet = statement.executeQuery();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                boolean bl;
                switch (resultSet.getMetaData().getColumnType(i)) {
                    case 2004: 
                    case 2005: {
                        bl = false;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (!bl) continue;
                String string = resultSet.getMetaData().getColumnName(i);
                string = DBUtil.getInstance().addQuotes(this._conn, string);
                stringBuilder.append(string + ",");
                ++n;
            }
            if (n > 0) {
                stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "");
                stringBuilder.append(" from ( " + this._sql + "\n)");
                if (!this._isOracle && !this._isTimesTen) {
                    stringBuilder.append("as t");
                }
                this._sql = stringBuilder.toString();
            } else {
                this._sql = "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.clearData();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private String addQuotes(String string) {
        String string2 = null;
        String string3 = Connections.getInstance().getDatabase(this._conn).getIdentifierQuoteString();
        string2 = string3 != null ? string3 + string + string3 : string;
        return string2;
    }

    private void showPanels() {
        isExportInProgress = true;
        if (this._connName == null && this._conn != null) {
            this._connName = Connections.getInstance().getDatabase(this._conn).getConnectionName();
        }
        this._predicate = this._bindList != null ? new PredicatePanel(this._connName, this._sql, this._bindList) : (this._bindMap != null ? new PredicatePanel(this._connName, this._sql, this._bindMap) : new PredicatePanel(this._connName, this._sql));
        this._cols = this._bindList != null ? new ColumnPanel(this._connName, this._sql, this._bindList, this._table) : (this._bindMap != null ? new ColumnPanel(this._connName, this._sql, this._bindMap, this._table) : new ColumnPanel(this._connName, this._sql, this._table));
        if (this._cols.getColCount() == 0) {
            return;
        }
        this._cols.addTreeCellCheckedListener(this._colListener);
        this._formatPanel = new ExportFormatPanel(this._format);
        if (this._name == null) {
            this._name = "table_export";
        }
        this._formatPanel.setDefaultName(this._name);
        String string = "";
        string = FormatRegistry.getFormatter(this._format).getExt();
        File file = null;
        String string2 = null;
        file = DBConfig.getInstance().getParameter("EXPORTDIR") == null || ((String)DBConfig.getInstance().getParameter("EXPORTDIR")).equals("") ? new File(System.getProperty("user.home")) : new File((String)DBConfig.getInstance().getParameter("EXPORTDIR"));
        string2 = file.toString() + File.separator + this._name + "." + string;
        this._formatPanel.setFileName(string2);
        JPanel[] jPanelArray = new JPanel[]{this._formatPanel, this._cols, this._predicate};
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._formatPanel, "f1_idedexporttabledata_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._cols, "f1_idedexporttabledata_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._predicate, "f1_idedexporttabledata_html");
        String[] stringArray = new String[]{"Format", "Columns", "Where"};
        UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, "Export Data", this, null, this);
        this.clearData();
    }

    public void setArgs(String string) {
        this._format = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this._formatPanel.getFormat();
        Boolean bl = true;
        try {
            int n;
            int n2;
            Dimension dimension;
            JLabel jLabel;
            Object object;
            JComponent jComponent;
            FileOutputStream fileOutputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            String string2 = null;
            if (this._formatPanel.getFormat().equals("INSERT") && (this._formatPanel.getDefaultName() == null || this._formatPanel.getDefaultName().equals(""))) {
                bl = false;
                jComponent = new PropertyPanel();
                object = Translate.translate("Warning Message");
                jLabel = new JLabel(Translate.translate("Must provide a table name."));
                ((PropertyPanel)jComponent).addSingleComp(jLabel);
                ((PropertyPanel)jComponent).setBackground(UIManager.getColor("EWTDialog.background"));
                this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, null, (String)object, (int)1);
                this.dlg.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TableExportAction.this.dlg.dispose();
                    }
                });
                dimension = jComponent.getPreferredSize();
                n2 = (int)dimension.getHeight() + 100;
                n = (int)dimension.getWidth() + 100;
                this.dlg.setSize(n, n2);
                this.dlg.setPreferredSize(n, n2);
                IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
                this.dlg.setVisible(true);
            }
            if (this._formatPanel.getDestination().equalsIgnoreCase("file")) {
                if (!this._formatPanel.getFileName().equals("")) {
                    fileOutputStream = new FileOutputStream(this._formatPanel.getFileName());
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    try {
                        string2 = this._formatPanel.getFilePanel().getEncoding();
                        if (string2 == null) {
                            string2 = IdeUtil.getIdeEncoding();
                        }
                        outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
                    }
                } else {
                    bl = false;
                    jComponent = new PropertyPanel();
                    object = Translate.translate("Warning Message");
                    jLabel = new JLabel(Translate.translate("Must provide a file name."));
                    ((PropertyPanel)jComponent).addSingleComp(jLabel);
                    ((PropertyPanel)jComponent).setBackground(UIManager.getColor("EWTDialog.background"));
                    this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, null, (String)object, (int)1);
                    this.dlg.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            TableExportAction.this.dlg.dispose();
                        }
                    });
                    dimension = jComponent.getPreferredSize();
                    n2 = (int)dimension.getHeight() + 100;
                    n = (int)dimension.getWidth() + 100;
                    this.dlg.setSize(n, n2);
                    this.dlg.setPreferredSize(n, n2);
                    IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
                    this.dlg.setVisible(true);
                }
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
                bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
            }
            jComponent = null;
            jComponent = this._table != null && this._predicate.getPredicate() != null && this._predicate.getPredicate().equals("") && this._cols.getSelectedColumns().equals(" * ") ? this._table : this._predicate.getTable();
            if (bl.booleanValue()) {
                object = null;
                if (jComponent != null) {
                    object = (ResultsFormatter)FormatRegistry.getFormatter(string);
                    ((ResultsFormatter)object).setJTable((JTable)jComponent);
                    ((ResultsFormatter)object).setOutputStream(bufferedOutputStream);
                    ((ResultsFormatter)object).setOutWriter(outputStreamWriter);
                    ((ResultsFormatter)object).setEncode(string2);
                    if (this._connName != null) {
                        ((ResultsFormatter)object).setConn(this._connName);
                    }
                    object.setTableName(this._formatPanel.getDefaultName());
                } else {
                    object = (ResultsFormatter)FormatRegistry.getFormatter(string);
                    ((ResultsFormatter)object).setConn(this._connName);
                    ((ResultsFormatter)object).setSql(this._connName, this._sql);
                    ((ResultsFormatter)object).setOutputStream(bufferedOutputStream);
                    ((ResultsFormatter)object).setOutWriter(outputStreamWriter);
                    ((ResultsFormatter)object).setEncode(string2);
                    object.setTableName(this._formatPanel.getDefaultName());
                }
                if (object != null) {
                    ((ResultsFormatter)object).printWithDialog();
                }
                if (!this._formatPanel.getDestination().equalsIgnoreCase("file")) {
                    UIUtils.setClipboard(new String(byteArrayOutputStream.toByteArray()));
                }
                if (actionEvent.getSource() instanceof JEWTDialog) {
                    ((JEWTDialog)actionEvent.getSource()).dispose();
                }
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.error((Component)this._formatPanel, (Object)("Error writing to file:" + this._formatPanel.getFileName()), (String)"Error writing to file", (String)"");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (((CustomTabbedPane)changeEvent.getSource()).getSelectedIndex() == 2) {
            this._predicate.setSQL("select " + this._cols.getSelectedColumns() + this._from);
            this._predicate.showSampleData();
        }
    }

    public JMenu getMenu() {
        if (this._menu == null) {
            this._menu = new JMenu("Export");
        }
        List<String> list = FormatRegistry.getTypes();
        for (final String string : list) {
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TableExportAction.this.setArgs(string);
                    TableExportAction.this.launchDlg();
                }
            });
            this._menu.add(jMenuItem);
        }
        return this._menu;
    }

    public void setSql(String string) {
        this._sql = string;
    }

    public void setConn(Connection connection) {
        this._conn = connection;
    }

    public void setBindList(List list) {
        this._bindList = list;
    }

    public void setBindMap(Map map) {
        this._bindMap = map;
    }

    public void setTable(JTable jTable) {
        this.clearData();
        this._table = jTable;
        if (this._table.getModel() instanceof ResultSetTableModel) {
            this.setConn(((ResultSetTableModel)this._table.getModel()).getConnection());
            this.setSql(((ResultSetTableModel)this._table.getModel()).getSQL());
            this.setBindMap(((ResultSetTableModel)this._table.getModel()).getBindMap());
            this.setBindList(((ResultSetTableModel)this._table.getModel()).getBindList());
            this.setConnName(((ResultSetTableModel)this._table.getModel()).getConnName());
        }
    }

    public JTable getTable() {
        return this._table;
    }

    private void setConnName(String string) {
        this._connName = string;
    }

    public static boolean isExportInProgress() {
        return isExportInProgress;
    }
}

