/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.oracle.OracleObjectDDL;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ora.OracleDDLGenerator;

public class OracleTypeDDL
extends OracleObjectDDL {
    private String type_ddl;
    private String _EOL = System.getProperty("line.separator");

    private void getQueries(Connection connection) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("/oracle/dbtools/raptor/ddl/oracle/TypeSql.xml");
        Query query = queryXMLSupport.getQuery("type_ddl", connection);
        this.type_ddl = query.getSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetDDL(DBObject dBObject) {
        this.getQueries(dBObject.getConnection());
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.clear();
        hashMap.put("OWNER", dBObject.getSchemaName());
        hashMap.put("NAME", dBObject.getObjectName());
        try {
            resultSet = DBUtil.getInstance().executeQuery(dBObject.getConnection(), this.type_ddl, hashMap);
            if (resultSet != null) {
                while (resultSet.next()) {
                    stringBuilder.append(resultSet.getString(1));
                }
            } else {
                OracleDDLGenerator oracleDDLGenerator;
                Ddl ddl;
                Database database = dBObject.getDatabase();
                if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                    stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                    stringBuilder.append(ddl.getDdl());
                }
            }
        }
        catch (SQLException sQLException) {
            OracleDDLGenerator oracleDDLGenerator;
            Ddl ddl;
            stringBuilder = new StringBuilder();
            Database database = dBObject.getDatabase();
            if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                stringBuilder.append(ddl.getDdl());
            }
        }
        finally {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {}
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGetDDLScript(DBObject dBObject) {
        this.getQueries(dBObject.getConnection());
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.clear();
        hashMap.put("OWNER", dBObject.getSchemaName());
        hashMap.put("NAME", dBObject.getObjectName());
        stringBuilder.append(this._EOL + "--------------------------------------------------------" + this._EOL);
        stringBuilder.append("--  DDL for Type " + dBObject.getObjectName() + this._EOL);
        stringBuilder.append("--------------------------------------------------------" + this._EOL);
        try {
            resultSet = DBUtil.getInstance().executeQuery(dBObject.getConnection(), this.type_ddl, hashMap);
            if (resultSet != null) {
                while (resultSet.next()) {
                    stringBuilder.append(resultSet.getString(1));
                }
            } else {
                OracleDDLGenerator oracleDDLGenerator;
                Ddl ddl;
                Database database = dBObject.getDatabase();
                if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                    stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                    stringBuilder.append(ddl.getDdl());
                }
            }
        }
        catch (SQLException sQLException) {
            OracleDDLGenerator oracleDDLGenerator;
            Ddl ddl;
            stringBuilder = new StringBuilder();
            Database database = dBObject.getDatabase();
            if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                stringBuilder.append(ddl.getDdl());
            }
        }
        finally {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {}
            }
        }
        return stringBuilder.toString();
    }
}

