/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.sql.Connection;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.export.ExpPanel;
import oracle.dbtools.raptor.export.ExportOptions;

public class OracleMetaSetup {
    Connection _conn = null;
    private static String META_SETUP = "declare  FUNCTION ifelse (bool_in IN number)    RETURN boolean  IS  BEGIN    IF bool_in = 0    THEN      RETURN false;   ELSE      RETURN true;   END IF;  END;  begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', ifelse(:SEGMENTS));   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR', ifelse(:TERMINATOR));  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY', ifelse(:PRETTY));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD', ifelse(:BYTE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE', ifelse(:FORCE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', ifelse(:ALTER));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA', ifelse(:SHOWSCHEMA));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS', ifelse(:SCRIPT));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'REF_CONSTRAINTS', ifelse(:SCRIPT2)); end;";
    private static String META_SETUP_SCRIPT = "declare  FUNCTION ifelse (bool_in IN number)    RETURN boolean  IS  BEGIN    IF bool_in = 0    THEN      RETURN false;   ELSE      RETURN true;   END IF;  END;  begin   DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', ifelse(:SEGMENTS));   dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'SQLTERMINATOR',  ifelse(:TERMINATOR));  dbms_metadata.set_transform_param(dbms_metadata.SESSION_TRANSFORM,'PRETTY',  ifelse(:PRETTY));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'SIZE_BYTE_KEYWORD',  ifelse(:BYTE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'FORCE',  ifelse(:FORCE));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA',  ifelse(:SHOWSCHEMA));  DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS', ifelse(:SCRIPT));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'REF_CONSTRAINTS', ifelse(:SCRIPT2));   DBMS_METADATA.SET_TRANSFORM_PARAM( dbms_metadata.SESSION_TRANSFORM, 'CONSTRAINTS_AS_ALTER', false);  end;";

    public OracleMetaSetup(Connection connection, String string) {
        this._conn = connection;
        this.setup(string);
    }

    public void setConnection(Connection connection) {
        this._conn = connection;
    }

    private void setup(String string) {
        Object object;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (string.equals("SCRIPT")) {
            object = ExpPanel.getInstance().getOptions();
            hashMap.put("SEGMENTS", ((ExportOptions)object).getSegments());
            hashMap.put("TERMINATOR", ((ExportOptions)object).getTerminator());
            hashMap.put("PRETTY", ((ExportOptions)object).getPretty());
            hashMap.put("BYTE", ((ExportOptions)object).getByte());
            hashMap.put("FORCE", ((ExportOptions)object).getForce());
            hashMap.put("SHOWSCHEMA", ((ExportOptions)object).getSchema());
            hashMap.put("SCRIPT", false);
            hashMap.put("SCRIPT2", false);
        } else if (string.equals("COPY")) {
            object = DDLGenerator.getInstance().getFormating();
            hashMap.put("SEGMENTS", ((DDLFormat)object).getSegments());
            hashMap.put("TERMINATOR", ((DDLFormat)object).getTerminator());
            hashMap.put("PRETTY", ((DDLFormat)object).getPretty());
            hashMap.put("BYTE", ((DDLFormat)object).getByte());
            hashMap.put("FORCE", ((DDLFormat)object).getForce());
            hashMap.put("SHOWSCHEMA", false);
            hashMap.put("SCRIPT", false);
            hashMap.put("SCRIPT2", false);
        } else if (string.equals("DEP")) {
            object = ExpPanel.getInstance().getOptions();
            hashMap.put("SEGMENTS", ((ExportOptions)object).getSegments());
            hashMap.put("TERMINATOR", ((ExportOptions)object).getTerminator());
            hashMap.put("PRETTY", ((ExportOptions)object).getPretty());
            hashMap.put("BYTE", ((ExportOptions)object).getByte());
            hashMap.put("FORCE", ((ExportOptions)object).getForce());
            hashMap.put("SHOWSCHEMA", ((ExportOptions)object).getSchema());
            hashMap.put("SCRIPT", true);
            hashMap.put("SCRIPT2", true);
        } else {
            hashMap.put("SEGMENTS", DBConfig.getInstance().getBoolean("DDL_SEGMENTS"));
            hashMap.put("TERMINATOR", DBConfig.getInstance().getBoolean("DDL_TERMINATOR"));
            hashMap.put("PRETTY", DBConfig.getInstance().getBoolean("DDL_PRETTY"));
            hashMap.put("BYTE", DBConfig.getInstance().getBoolean("DDL_BYTE"));
            hashMap.put("FORCE", DBConfig.getInstance().getBoolean("DDL_FORCE"));
            hashMap.put("ALTER", DBConfig.getInstance().getBoolean("DDL_ALTER"));
            hashMap.put("SHOWSCHEMA", DBConfig.getInstance().getBoolean("DDL_SCHEMA"));
            hashMap.put("SCRIPT", true);
            hashMap.put("SCRIPT2", true);
        }
        object = null;
        object = string.equals("COPY") || string.equals("SCRIPT") || string.equals("DEP") ? DBUtil.getInstance().executeQuery(this._conn, META_SETUP_SCRIPT, hashMap) : DBUtil.getInstance().executeQuery(this._conn, META_SETUP, hashMap);
        try {
            object.getStatement().close();
            object.close();
        }
        catch (Exception exception) {
            try {
                object.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }
}

