/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.oracle.OracleObjectDDL;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.ora.OracleDDLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDbLinkDDL
extends OracleObjectDDL {
    private static String LIST_OBJECTS;
    private String script_ddl;
    private String _EOL = System.getProperty("line.separator");

    private void getQueries(Connection connection) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("/oracle/dbtools/raptor/ddl/oracle/DbLinkSql.xml");
        Query query = queryXMLSupport.getQuery("list_objects", connection);
        LIST_OBJECTS = query.getSql();
        query = queryXMLSupport.getQuery("script_ddl", connection);
        this.script_ddl = query.getSql();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGetDDL(DBObject dBObject) {
        this.getQueries(dBObject.getConnection());
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.clear();
        hashMap.put("OWNER", dBObject.getSchemaName());
        hashMap.put("NAME", dBObject.getObjectName());
        try {
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            resultSet = dBUtil.executeQuery(dBObject.getConnection(), this.script_ddl, hashMap);
            if (resultSet != null) {
                while (resultSet.next()) {
                    stringBuilder.append(resultSet.getString(1));
                }
            } else {
                OracleDDLGenerator oracleDDLGenerator;
                Ddl ddl;
                Database database = dBObject.getDatabase();
                if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                    stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                    stringBuilder.append(ddl.getDdl());
                }
            }
        }
        catch (SQLException sQLException) {
            OracleDDLGenerator oracleDDLGenerator;
            Ddl ddl;
            stringBuilder = new StringBuilder();
            Database database = dBObject.getDatabase();
            if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                stringBuilder.append(ddl.getDdl());
            }
        }
        finally {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {}
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGetDDLScript(DBObject dBObject) {
        this.getQueries(dBObject.getConnection());
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.clear();
        hashMap.put("OWNER", dBObject.getSchemaName());
        hashMap.put("NAME", dBObject.getObjectName());
        stringBuilder.append(this._EOL + "--------------------------------------------------------" + this._EOL);
        stringBuilder.append("--  DDL for DB Link " + dBObject.getObjectName() + this._EOL);
        stringBuilder.append("--------------------------------------------------------" + this._EOL);
        try {
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            resultSet = dBUtil.executeQuery(dBObject.getConnection(), this.script_ddl, hashMap);
            if (resultSet != null) {
                while (resultSet.next()) {
                    stringBuilder.append(resultSet.getString(1));
                }
            } else {
                OracleDDLGenerator oracleDDLGenerator;
                Ddl ddl;
                Database database = dBObject.getDatabase();
                if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                    stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                    stringBuilder.append(ddl.getDdl());
                }
            }
        }
        catch (SQLException sQLException) {
            OracleDDLGenerator oracleDDLGenerator;
            Ddl ddl;
            stringBuilder = new StringBuilder();
            Database database = dBObject.getDatabase();
            if (database != null && (ddl = (oracleDDLGenerator = new OracleDDLGenerator((DBObjectProvider)database)).getCreateDDL(dBObject.getSchemaObject(), false, false)).getDdl().length() > 0) {
                stringBuilder.append("-- Unable to Render DDL with DBMS_METADATA using internal generator." + this._EOL);
                stringBuilder.append(ddl.getDdl());
            }
        }
        finally {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {}
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<DBObject> getSchemaObjects(Connection connection, String string, String string2) {
        this.getQueries(connection);
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = null;
        ResultSet resultSet = null;
        hashMap.put("OWNER", string);
        hashMap.put("TYPE", "TABLE");
        resultSet = DBUtil.getInstance().executeQuery(connection, LIST_OBJECTS, hashMap);
        String string3 = Connections.getInstance().getConnectioName(connection);
        try {
            while (resultSet.next()) {
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, string, string2);
                uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(2));
                arrayList.add(new DBObject(uRL));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {}
            }
        }
        return arrayList;
    }
}

