/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.oracle.OracleObjectDDL;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDataDDL
extends OracleObjectDDL {
    InsertFormatter datawriter = new InsertFormatter();
    private static String LIST_OBJECTS;
    private String _EOL = System.getProperty("line.separator");

    private void getQueries(Connection connection) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport("/oracle/dbtools/raptor/ddl/oracle/ObjectSql.xml");
        Query query = queryXMLSupport.getQuery("list_objects", connection);
        LIST_OBJECTS = query.getSql();
    }

    @Override
    public String doGetDDL(DBObject dBObject) {
        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        OutputStreamWriter outputStreamWriter = dDLGenerator.getWriter();
        this.datawriter.setTableName(dBObject.getObjectName());
        String string = "select * from " + dBObject.getSchemaName() + ".\"" + dBObject.getObjectName() + "\" where 1=1 ";
        String string2 = null;
        if (this.getFilter() != null) {
            string = string + " and " + this.getFilter();
            string2 = "--   FILTER = " + this.getFilter() + this._EOL;
        } else {
            string2 = "--   FILTER = none used" + this._EOL;
        }
        this.datawriter.setSql(dBObject.getConnectionName(), string);
        this.datawriter.setOutWriter(outputStreamWriter);
        try {
            dDLGenerator.getWriter().write(this._EOL + "---------------------------------------------------" + this._EOL);
            dDLGenerator.getWriter().write("--   DATA FOR TABLE " + dBObject.getObjectName() + this._EOL);
            dDLGenerator.getWriter().write(string2);
            dDLGenerator.getWriter().write("---------------------------------------------------" + this._EOL);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.datawriter.print();
        stringBuilder.append(this._EOL + "---------------------------------------------------" + this._EOL);
        stringBuilder.append("--   END DATA FOR TABLE " + dBObject.getObjectName() + this._EOL);
        stringBuilder.append("---------------------------------------------------" + this._EOL);
        return stringBuilder.toString();
    }

    @Override
    public String doGetDDLScript(DBObject dBObject) {
        return this.doGetDDL(dBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<DBObject> getSchemaObjects(Connection connection, String string, String string2) {
        this.getQueries(connection);
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = null;
        ResultSet resultSet = null;
        hashMap.put("OWNER", string);
        hashMap.put("TYPE", "TABLE");
        resultSet = DBUtil.getInstance().executeQuery(connection, LIST_OBJECTS, hashMap);
        String string3 = Connections.getInstance().getConnectioName(connection);
        try {
            while (resultSet.next()) {
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, string, string2);
                uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                arrayList.add(new DBObject(uRL));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                }
                catch (Exception exception2) {}
            }
        }
        return arrayList;
    }
}

