/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.raptor.ddl.IObjectDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleApex;
import oracle.dbtools.raptor.ddl.oracle.OracleApexPage;
import oracle.dbtools.raptor.ddl.oracle.OracleConstraintDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleDataDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleDbLinkDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleFunctionDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleIndexDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleMatViewDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleMatViewLogDDL;
import oracle.dbtools.raptor.ddl.oracle.OraclePackageBodyDDL;
import oracle.dbtools.raptor.ddl.oracle.OraclePackageDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleProcedureDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleRefConstraintDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleSequenceDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleSynonymnDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleTableDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleTriggerDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleTypeDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleViewDDL;
import oracle.dbtools.raptor.utils.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLRegistry {
    private static HashMap<String, Class> _registry = new HashMap();

    public static synchronized ArrayList<String> getTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            String[] stringArray = string.split("#");
            arrayList.add(stringArray[1]);
        }
        return arrayList;
    }

    public static synchronized void registerHandler(String string, String string2, Class clazz) {
        if (!IObjectDDL.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IDdlGenerator");
        }
        _registry.put(DBObject.getKey(string, string2), clazz);
    }

    public static synchronized void unregisterHandler(String string) {
        _registry.remove(string);
    }

    public static synchronized IObjectDDL getInstanceFor(String string) {
        if (_registry.get(string) != null) {
            try {
                return (IObjectDDL)_registry.get(string).newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static synchronized boolean isSupported(String string) {
        return _registry.get(string) != null;
    }

    static {
        DDLRegistry.registerHandler("Oracle", "TABLE", OracleTableDDL.class);
        DDLRegistry.registerHandler("Oracle", "CONSTRAINT", OracleConstraintDDL.class);
        DDLRegistry.registerHandler("Oracle", "REFCONSTRAINT", OracleRefConstraintDDL.class);
        DDLRegistry.registerHandler("Oracle", "INDEX", OracleIndexDDL.class);
        DDLRegistry.registerHandler("Oracle", "TRIGGER", OracleTriggerDDL.class);
        DDLRegistry.registerHandler("Oracle", "MATERIALIZED_VIEW", OracleMatViewDDL.class);
        DDLRegistry.registerHandler("Oracle", "MATERIALIZED_VIEW_LOG", OracleMatViewLogDDL.class);
        DDLRegistry.registerHandler("Oracle", "VIEW", OracleViewDDL.class);
        DDLRegistry.registerHandler("Oracle", "FUNCTION", OracleFunctionDDL.class);
        DDLRegistry.registerHandler("Oracle", "PACKAGE", OraclePackageDDL.class);
        DDLRegistry.registerHandler("Oracle", "PACKAGE_BODY", OraclePackageBodyDDL.class);
        DDLRegistry.registerHandler("Oracle", "PROCEDURE", OracleProcedureDDL.class);
        DDLRegistry.registerHandler("Oracle", "DATABASE_LINK", OracleDbLinkDDL.class);
        DDLRegistry.registerHandler("Oracle", "SEQUENCE", OracleSequenceDDL.class);
        DDLRegistry.registerHandler("Oracle", "TYPE", OracleTypeDDL.class);
        DDLRegistry.registerHandler("Oracle", "SYNONYM", OracleSynonymnDDL.class);
        DDLRegistry.registerHandler("Oracle", "DATA", OracleDataDDL.class);
        DDLRegistry.registerHandler("Oracle", "APEX", OracleApex.class);
        DDLRegistry.registerHandler("Oracle", "APEX_PAGE", OracleApexPage.class);
    }
}

