/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.Action;
import javax.swing.JMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLRegistry;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLContextMenuListener
implements ContextMenuListener,
Controller {
    private JMenu _menu;
    public static final String DDL_AS_ZIP_FILE_CMD = "DatabaseNavigator.DDL_AS_ZIP_FILE_CMD";
    public static final int DDL_AS_ZIP_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_AS_ZIP_FILE_CMD");
    public static final String DDL_AS_FILE_CMD = "DatabaseNavigator.DDL_AS_FILE_CMD";
    public static final int DDL_AS_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_AS_FILE_CMD");
    public static final String DDL_TO_WRKSHEET_CMD = "DatabaseNavigator.DDL_TO_WRKSHEET_CMD";
    public static final int DDL_TO_WRKSHEET_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_TO_WRKSHEET_CMD");
    public static final String DDL_TO_CLIPBOARD_CMD = "DatabaseNavigator.DDL_TO_CLIPBOARD_CMD";
    public static final int DDL_TO_CLIPBOARD_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_TO_CLIPBOARD_CMD");
    public static final IdeAction DDL_TO_FILE = IdeAction.get((int)DDL_AS_FILE_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(14)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(14))));
    public static final IdeAction DDL_TO_ZIP_FILE = IdeAction.get((int)DDL_AS_ZIP_FILE_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(17)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(17))));
    public static final IdeAction DDL_TO_WRKSHEET = IdeAction.get((int)DDL_TO_WRKSHEET_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(15)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(15))));
    public static final IdeAction DDL_TO_CLIPBOARD = IdeAction.get((int)DDL_TO_CLIPBOARD_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(16)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(16))));

    private void init() {
        if (this._menu == null) {
            this._menu = new JMenu(DatabaseNavigatorResources.getString(13));
            this._menu.add((Action)DDL_TO_FILE);
            this._menu.add((Action)DDL_TO_ZIP_FILE);
            this._menu.add((Action)DDL_TO_WRKSHEET);
            this._menu.add((Action)DDL_TO_CLIPBOARD);
            DDL_TO_FILE.addController((Controller)this);
            DDL_TO_ZIP_FILE.addController((Controller)this);
            DDL_TO_WRKSHEET.addController((Controller)this);
            DDL_TO_CLIPBOARD.addController((Controller)this);
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Element[] elementArray;
        this.init();
        DBObject dBObject = null;
        boolean bl = true;
        for (Element element : elementArray = contextMenu.getContext().getSelection()) {
            dBObject = new DBObject(element);
            if (DDLRegistry.isSupported(dBObject.getKey())) continue;
            bl = false;
        }
        if (bl) {
            contextMenu.add((Component)this._menu);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == DDL_AS_FILE_CMD_ID) {
            this.saveToFile(context, false);
            return true;
        }
        if (ideAction.getCommandId() == DDL_AS_ZIP_FILE_CMD_ID) {
            this.saveToFile(context, true);
            return true;
        }
        if (ideAction.getCommandId() == DDL_TO_WRKSHEET_CMD_ID) {
            this.saveToWorkSheet(context);
            return true;
        }
        if (ideAction.getCommandId() == DDL_TO_CLIPBOARD_CMD_ID) {
            this.saveToClip(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    private List<DBObject> getList(Context context) {
        Element[] elementArray;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (Element element : elementArray = context.getSelection()) {
            arrayList.add(new DBObject(element));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToWorkSheet(Context context) {
        Ide.getWaitCursor().show();
        try {
            DBObject dBObject = new DBObject(context.getSelection()[0]);
            RaptorDBAddin.getSqlOpener().openNewEditor(DDLGenerator.getInstance().getDDL(this.getList(context)), dBObject.getConnectionName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Ide.getWaitCursor().hide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToClip(Context context) {
        DBObject dBObject = new DBObject(context.getSelection()[0]);
        Ide.getWaitCursor().show();
        try {
            UIUtils.setClipboard(DDLGenerator.getInstance().getDDL(this.getList(context)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Ide.getWaitCursor().hide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(Context context, boolean bl) {
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.setSelectionScope(0);
        uRLChooser.setSelectionMode(0);
        List<DBObject> list = this.getList(context);
        String string = Ide.getTrueUserHomeDirectory() + "/" + list.get(0).getObjectName();
        string = list.size() > 1 ? string + list.get(0).getObjectName() : string + "MULTIPLE_" + list.get(0).getObjectType();
        string = bl ? string + ".zip" : string + ".sql";
        try {
            uRLChooser.setSelectedURL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            URL uRL = uRLChooser.getSelectedURL();
            File file = new File(uRL.getFile());
            String string2 = file.getName();
            String string3 = string2.indexOf(".") > 0 ? string2.substring(0, string2.indexOf(".")) : string2;
            String string4 = file.getParent();
            DBObject dBObject = new DBObject(context.getSelection()[0]);
            if (dBObject != null) {
                if (bl) {
                    DDLGenerator.getInstance().setFile(string4 + File.separator + string3 + ".sql", null);
                } else {
                    DDLGenerator.getInstance().setFile(uRL.getFile(), null);
                }
                Ide.getWaitCursor().show();
                try {
                    DDLGenerator.getInstance().openFile();
                    DDLGenerator.getInstance().getWriter().write(DDLGenerator.getInstance().getDDL(list));
                    DDLGenerator.getInstance().closeFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    Ide.getWaitCursor().hide();
                }
            }
            if (bl) {
                byte[] byArray = new byte[1024];
                try {
                    int n2;
                    String string5 = string4 + File.separator + string3 + ".zip";
                    ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string5));
                    FileInputStream fileInputStream = new FileInputStream(string4 + File.separator + string3 + ".sql");
                    zipOutputStream.putNextEntry(new ZipEntry(string3 + ".sql"));
                    while ((n2 = fileInputStream.read(byArray)) > 0) {
                        zipOutputStream.write(byArray, 0, n2);
                    }
                    zipOutputStream.closeEntry();
                    fileInputStream.close();
                    zipOutputStream.close();
                    File file2 = new File(string4 + File.separator + string3 + ".sql");
                    file2.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

