/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.validators;

import java.util.HashMap;
import oracle.dbtools.raptor.apex.ApexStatusValidator;
import oracle.dbtools.raptor.controls.validators.DBCharset;
import oracle.dbtools.raptor.controls.validators.IValidator;
import oracle.dbtools.raptor.controls.validators.Numeric;
import oracle.dbtools.raptor.utils.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorRegistry {
    private static HashMap<String, Class<? extends IValidator>> _validators = null;

    public static synchronized void registerValidator(String string, Class<? extends IValidator> clazz) {
        if (_validators == null) {
            _validators = new HashMap();
        }
        _validators.put(string, clazz);
    }

    public static synchronized void unRegisterValidator(String string) {
        if (_validators != null) {
            _validators.remove(string);
        }
    }

    public static IValidator getValidator(String string) {
        if (_validators != null) {
            try {
                return _validators.get(string).newInstance();
            }
            catch (Exception exception) {
                ExceptionHandler.handleException(exception);
            }
        }
        return null;
    }

    static {
        ValidatorRegistry.registerValidator("numeric", Numeric.class);
        ValidatorRegistry.registerValidator("charset", DBCharset.class);
        ValidatorRegistry.registerValidator("apex.status", ApexStatusValidator.class);
    }
}

