/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.controls.table.SingleRecordViewMenu;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpSystem;

public class SingleRecordViewPanel
extends JPanel {
    private JTable _table;
    private int _currRow = -1;
    private ArrayList<Component> _values = new ArrayList();
    private Toolbar _toolbar;
    private JPanel _panel;

    public SingleRecordViewPanel(JTable jTable, int n) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_singlerecordgridview_html");
        this._table = jTable;
        this.jbInit();
        this.navigateTo(n);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this._toolbar = new Toolbar();
        this._toolbar.setFloatable(true);
        SingleRecordViewMenu.getInstance().populateToolbar(this._toolbar);
        this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this._panel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this._panel);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
    }

    public void navigateTo(int n) {
        if (this._currRow > -1) {
            this.save();
        }
        if (this._currRow != n && n > -1 && n < this._table.getRowCount()) {
            this._table.setColumnSelectionAllowed(false);
            this._table.setRowSelectionAllowed(true);
            this._table.getSelectionModel().setSelectionInterval(n, n);
            this._currRow = n;
            this._panel.removeAll();
            this._values.clear();
            for (int i = 0; i < this._table.getColumnCount(); ++i) {
                JLabel jLabel = new JLabel(this._table.getColumnName(i));
                TableCellEditor tableCellEditor = this._table.getCellEditor(this._currRow, i);
                Object object = this._table.getValueAt(this._currRow, i);
                Component component = tableCellEditor.getTableCellEditorComponent(this._table, object, false, this._currRow, i);
                this._values.add(component);
                this._panel.add((Component)jLabel, new GridBagConstraints(0, i, 1, 1, 0.0, 0.1, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
                this._panel.add(component, new GridBagConstraints(1, i, 1, 1, 1.0, 0.1, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
            }
            if (this.getGraphics() != null) {
                this.paintAll(this.getGraphics());
            }
        }
    }

    public int getCurrentRow() {
        return this._currRow;
    }

    public void next() {
        this.navigateTo(this._currRow + 1);
    }

    public void prev() {
        this.navigateTo(this._currRow - 1);
    }

    public void first() {
        this.navigateTo(0);
    }

    public void last() {
        this.navigateTo(this._table.getRowCount() - 1);
    }

    public void save() {
        JTextComponent jTextComponent = null;
        for (int i = 0; i < this._values.size(); ++i) {
            Component component = this._values.get(i);
            jTextComponent = this.findTextComp(component);
            if (jTextComponent == null) continue;
            this._table.setValueAt(jTextComponent.getText(), this._currRow, i);
        }
        this._table.paintAll(this._table.getGraphics());
    }

    public JTextComponent findTextComp(Component component) {
        Component[] componentArray;
        int n;
        int n2;
        if (component instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        if (component instanceof Container && (n2 = 0) < (n = (componentArray = ((Container)component).getComponents()).length)) {
            Component component2 = componentArray[n2];
            return this.findTextComp(component2);
        }
        return null;
    }
}

