/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.EditableResultSetTable;
import oracle.dbtools.raptor.controls.table.SingleRecordViewPanel;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;

public class SingleRecordViewMenu
implements ContextMenuListener,
Controller {
    private static String _nextCmdName = "TABLE_SINGLE_VIEW_NEXT";
    private static int _nextCmdId = Ide.findOrCreateCmdID((String)_nextCmdName);
    private static String _prevCmdName = "TABLE_SINGLE_VIEW_PREV";
    private static int _prevCmdId = Ide.findOrCreateCmdID((String)_prevCmdName);
    private static String _startCmdName = "TABLE_SINGLE_VIEW_START";
    private static int _startCmdId = Ide.findOrCreateCmdID((String)_startCmdName);
    private static String _lastCmdName = "TABLE_SINGLE_VIEW_LAST";
    private static int _lastCmdId = Ide.findOrCreateCmdID((String)_lastCmdName);
    private static String _cmdName = "TABLE_SINGLE_VIEW";
    private static int _cmdId = Ide.findOrCreateCmdID((String)_cmdName);
    private IdeAction _action = null;
    private JMenuItem _menuItem = null;
    private JTable _table;
    private int _currRow;
    private SingleRecordViewPanel _panel;
    protected int h = 200;
    protected int w = 200;
    private static SingleRecordViewMenu _instance;
    private static final Object LOCK;

    private SingleRecordViewMenu() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SingleRecordViewMenu getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new SingleRecordViewMenu();
            }
        }
        return _instance;
    }

    public void populateToolbar(Toolbar toolbar) {
        this.createAction(_startCmdId, "First", "first_ena.png", toolbar);
        this.createAction(_prevCmdId, "Previous", "prev_ena.png", toolbar);
        this.createAction(_nextCmdId, "Next", "next_ena.png", toolbar);
        this.createAction(_lastCmdId, "Last", "last_ena.png", toolbar);
    }

    private IdeAction createAction(int n, String string, String string2, Toolbar toolbar) {
        IdeAction ideAction = IdeAction.get((int)n, null, (String)string, null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (Icon)RaptorImage.getIcon(string2), null, (boolean)true);
        toolbar.add((ToggleAction)ideAction);
        ideAction.addController((Controller)this);
        return ideAction;
    }

    public void initAction() {
        if (this._action == null) {
            String string = "Single Record View";
            String string2 = StringUtils.stripMnemonic((String)string);
            Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
            this._action = IdeAction.get((int)_cmdId, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this._action.setEnabled(true);
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.initAction();
        if (contextMenu.getContext().getEvent().getSource() instanceof JTable) {
            this._table = (JTable)contextMenu.getContext().getEvent().getSource();
            this._currRow = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            this._menuItem = contextMenu.createMenuItem((ToggleAction)this._action);
            this._action.addController((Controller)this);
            this._action.setEnabled(true);
            contextMenu.add((Component)this._menuItem);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (_cmdId == n) {
            this._panel = new SingleRecordViewPanel(this._table, this._currRow);
            this._panel.print(this._panel.getGraphics());
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand() == "apply") {
                        SingleRecordViewMenu.this._panel.save();
                    }
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            };
            int n2 = this._table instanceof EditableResultSetTable ? 14 : 6;
            UIUtils.showPanelAsDialog(this._panel, "Single Record View", actionListener, n2, true);
            return true;
        }
        if (_startCmdId == n) {
            this._panel.first();
        } else if (_prevCmdId == n) {
            this._panel.prev();
        } else if (_nextCmdId == n) {
            this._panel.next();
        } else if (_lastCmdId == n) {
            this._panel.last();
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    static {
        LOCK = new Object();
    }
}

