/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.table;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.EditableResultSetTable;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.ExtendedTypeFactory;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModelBuffer;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;

public class DuplicateRowMenu
implements Controller,
ContextMenuListener {
    private static DuplicateRowMenu _instance = null;
    private static final Object LOCK = new Object();
    private static String _cmdName = "TABLE_DUPLICATE_ROW";
    private static int _cmdId = Ide.findOrCreateCmdID((String)_cmdName);
    private IdeAction _action = null;
    private JMenuItem _menuItem = null;
    private EditableResultSetTable _table;
    private int _currRow;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (this._table == null) {
            return true;
        }
        int n = ideAction.getCommandId();
        if (_cmdId == n) {
            ResultSetTableModelBuffer resultSetTableModelBuffer = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 1; i < this._table.getModel().getColumnCount(); ++i) {
                int n2;
                Object object = this._table.getModel().getValueAt(this._currRow, i);
                if (DataTypesUtil.isExtendedType(object, n2 = ((EditableResultSetTableModel)this._table.getModel()).getType(i - 1)) && object != null && !object.toString().equals("") && DataTypesUtil.canDuplicate(object, n2)) {
                    ExtendedType extendedType = ExtendedTypeFactory.getExtendedType(object, n2);
                    try {
                        extendedType.duplicate();
                        arrayList.add(extendedType);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        arrayList.add("");
                    }
                    continue;
                }
                if (!DataTypesUtil.isExtendedType(object, n2) && DataTypesUtil.canDuplicate(object, n2)) {
                    try {
                        arrayList.add(DataTypesUtil.getDuplicate(object, ((ResultSetTableModel)this._table.getModel()).getConnection(), n2));
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        arrayList.add("");
                    }
                    continue;
                }
                arrayList.add("");
            }
            resultSetTableModelBuffer = new ResultSetTableModelBuffer();
            resultSetTableModelBuffer.setChangedRow(arrayList);
            resultSetTableModelBuffer.setNew(true);
            resultSetTableModelBuffer.setChanged(true);
            this._table.insertRow(resultSetTableModelBuffer);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    public boolean handleDefaultAction(Context context) {
        return true;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.initAction();
        if (contextMenu.getContext().getEvent().getSource() instanceof EditableResultSetTable) {
            int n;
            Object object;
            this._table = (EditableResultSetTable)contextMenu.getContext().getEvent().getSource();
            this._currRow = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            if (this._table.getModel().getColumnCount() == 2 && !DataTypesUtil.canDuplicate(object = this._table.getModel().getValueAt(this._currRow, 1), n = ((EditableResultSetTableModel)this._table.getModel()).getType(0))) {
                return;
            }
            this._menuItem = contextMenu.createMenuItem((ToggleAction)this._action);
            this._action.addController((Controller)this);
            this._action.setEnabled(true);
            contextMenu.add((Component)this._menuItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DuplicateRowMenu getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new DuplicateRowMenu();
            }
        }
        return _instance;
    }

    public void initAction() {
        if (this._action == null) {
            String string = Translate.translate("&Duplicate Row");
            String string2 = StringUtils.stripMnemonic((String)string);
            Integer n = new Integer(StringUtils.getMnemonicKeyCode((String)string));
            this._action = IdeAction.get((int)_cmdId, null, (String)string2, null, (Integer)n, null, null, null, (boolean)false);
            this._action.setEnabled(true);
        }
    }
}

