/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.RadioGroupPanel;
import oracle.dbtools.raptor.controls.sqldialog.ActionSql;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionPrompt;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLPromptPanel
extends JPanel {
    private static final String CHECKBOX_VALUE = "CHECKBOX_VALUE";
    private Map<String, Object> _dict = new HashMap<String, Object>();
    private ArrayList<JComponent> _textValues = new ArrayList();
    private ObjectAction _action;
    private String _conn;
    private int row = 0;
    private FocusListener _focusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!(focusEvent.getSource() instanceof JComboBox)) {
                SQLPromptPanel.this.processReloadablePrompts((JComponent)focusEvent.getSource());
            }
        }
    };
    private ItemListener _comboListener = new ItemListener(){

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SQLPromptPanel.this.processReloadablePrompts((JComponent)itemEvent.getSource());
            }
        }
    };

    public SQLPromptPanel(ObjectAction objectAction, String string, Map<String, Object> map) {
        this.setLayout(new GridBagLayout());
        this._action = objectAction;
        this._conn = string;
        this._dict = map;
        this.init();
    }

    public ArrayList<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (JComponent jComponent : this._textValues) {
            String string = null;
            if (jComponent == null) {
                string = "";
            } else if (jComponent instanceof JTextComponent) {
                string = ((JTextComponent)jComponent).getText();
            } else if (jComponent instanceof RadioGroupPanel) {
                string = ((RadioGroupPanel)jComponent).getSelectedValue();
            } else if (jComponent instanceof JComboBox) {
                string = ((JComboBox)jComponent).getSelectedItem() != null ? ((JComboBox)jComponent).getSelectedItem().toString() : "";
            } else if (jComponent instanceof JCheckBox) {
                string = (String)((JCheckBox)jComponent).getClientProperty(CHECKBOX_VALUE);
                if (string.indexOf("STATIC:") == 0) {
                    string = string.substring(7);
                }
                if (((JCheckBox)jComponent).isSelected() && (string == null || string.length() == 0)) {
                    string = ((JCheckBox)jComponent).getText();
                }
            } else if (jComponent instanceof JScrollPane && ((JViewport)((JScrollPane)jComponent).getComponent(0)).getComponent(0) instanceof BasicEditorPane) {
                string = ((BasicEditorPane)((JViewport)((JScrollPane)jComponent).getComponent(0)).getComponent(0)).getText();
            }
            arrayList.add(string);
            ++n;
        }
        return arrayList;
    }

    public void evalDefaults() {
        ActionSql actionSql = new ActionSql();
        actionSql.setDict(this._dict);
        for (int i = 0; i < this._action.getPrompts().size(); ++i) {
            if (this._action.getDefaults().get(i) == null) continue;
            String string = null;
            if (this._action.getDefaults().get(i).toLowerCase().indexOf("static:") == 0) {
                string = actionSql.manualSubs(this._action.getDefaults().get(i).substring(7), this._dict);
            } else if (this._action.getDefaults().get(i) != null && !this._action.getDefaults().get(i).equals("")) {
                actionSql.setSql(this._action.getDefaults().get(i));
                actionSql.processSql(this.getTextValues(), this.getValues());
                string = DBUtil.getInstance().executeReturnOneCol(this._conn, actionSql.getSql(), actionSql.getBinds());
            } else {
                string = "";
            }
            if (this._textValues.get(i) instanceof RadioGroupPanel) {
                ((RadioGroupPanel)this._textValues.get(i)).setSelectedValue(string);
                continue;
            }
            if (this._textValues.get(i) instanceof JTextField) {
                ((JTextField)this._textValues.get(i)).setText(string);
                continue;
            }
            if (this._textValues.get(i) instanceof JComboBox) {
                ((JComboBox)this._textValues.get(i)).setSelectedItem(string);
                continue;
            }
            if (!(this._textValues.get(i) instanceof JScrollPane)) continue;
            ((BasicEditorPane)((JViewport)((JScrollPane)this._textValues.get(i)).getComponent(0)).getComponent(0)).setText(string);
        }
    }

    public void init() {
        if (this._dict.get("OBJECT_OWNER") != null && this._dict.get("OBJECT_NAME") != null) {
            this.addRow(new JLabel("Owner"), new JLabel(this._dict.get("OBJECT_OWNER").toString()));
            this.addRow(new JLabel("Name"), new JLabel(this._dict.get("OBJECT_NAME").toString()));
        }
        if (this._action.getPrompts() == null || this._action.getPrompts().size() == 0) {
            this.add((Component)new JLabel(Translate.translate("Confirm Action") + this._action.getTitle()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
        } else {
            for (ObjectActionPrompt objectActionPrompt : this._action.getPrompts()) {
                Object object;
                Object object2;
                JComboBox jComboBox;
                if (objectActionPrompt.getType().equalsIgnoreCase("confirm")) {
                    this.add((Component)new JLabel(objectActionPrompt.getPrompt()), new GridBagConstraints(0, this.row, 2, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 5), 0, 0));
                    ++this.row;
                    jComboBox = new JLabel("");
                } else if (objectActionPrompt.getType().equalsIgnoreCase("radio")) {
                    object2 = new RadioGroupPanel(objectActionPrompt.getValue());
                    jComboBox = object2;
                } else if (objectActionPrompt.getType().equalsIgnoreCase("codearea")) {
                    object2 = EditorFactory.createIdeEditorPane();
                    object2.setPreferredSize(new Dimension(300, 200));
                    object2.setText("");
                    object2.setDocument((Document)new BasicDocument("foo.plsql"));
                    object2.installPlugin((EditorPlugin)new LineHighlightPlugin());
                    object2.setText("");
                    object2.setEditable(true);
                    object = new JScrollPane((Component)object2, 22, 32);
                    ((JComponent)object).setPreferredSize(object2.getPreferredSize());
                    ((Component)object).setSize(((JComponent)object).getPreferredSize());
                    jComboBox = object;
                } else if (objectActionPrompt.getType().equalsIgnoreCase("check")) {
                    jComboBox = new JCheckBox();
                    if (objectActionPrompt.getValue().equals(objectActionPrompt.getDefault()) || objectActionPrompt.getDefault().indexOf("STATIC:") == 0 && objectActionPrompt.getValue().equals(objectActionPrompt.getDefault().substring(7))) {
                        ((JCheckBox)((Object)jComboBox)).setSelected(true);
                    }
                    ((JCheckBox)((Object)jComboBox)).putClientProperty(CHECKBOX_VALUE, objectActionPrompt.getValue());
                    ((JCheckBox)((Object)jComboBox)).addItemListener(this._comboListener);
                } else if (objectActionPrompt.getValue().toUpperCase().indexOf("STATIC:") == 0) {
                    jComboBox = new JComboBox<String>(objectActionPrompt.getValue().substring(7).split(":"));
                    ((JComboBox)jComboBox).addItemListener(this._comboListener);
                } else if (objectActionPrompt.getValue().toUpperCase().indexOf("SELECT") == 0) {
                    object2 = objectActionPrompt.getValue();
                    object = new ActionSql((String)object2, this._dict);
                    ((ActionSql)object).processSql(this.getTextValues(), this._action.getDefaults());
                    jComboBox = new JComboBox(new SQLComboxModel(this._conn, ((ActionSql)object).getSql(), ((ActionSql)object).getBinds(), null));
                    jComboBox.addItemListener(this._comboListener);
                } else {
                    jComboBox = new JTextField(25);
                }
                jComboBox.addFocusListener(this._focusListener);
                if (jComboBox != null) {
                    this._textValues.add(jComboBox);
                }
                if (objectActionPrompt.getType().equalsIgnoreCase("confirm")) continue;
                this.addRow(new JLabel(objectActionPrompt.getPrompt()), jComboBox);
            }
        }
        this.evalDefaults();
        this.toggleReadOnlyPrompts(false);
        this.add(Box.createGlue(), new GridBagConstraints(0, this.row, 1, 1, 0.0, 10.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.setSize(this.getPreferredSize());
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    private void addRow(Component component, Component component2) {
        this.add(component, new GridBagConstraints(0, this.row, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(component2, new GridBagConstraints(1, this.row, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
        ++this.row;
    }

    public void processReloadablePrompts(JComponent jComponent) {
        ActionSql actionSql;
        int n;
        int n2 = -1;
        this.toggleReadOnlyPrompts(true);
        for (n = 0; n < this._textValues.size(); ++n) {
            if (!jComponent.equals(this._textValues.get(n))) continue;
            n2 = n;
        }
        for (n = 0; n < this._action.getPrompts().size(); ++n) {
            if (this._action.getPrompts().get(n).getValue().toUpperCase().trim().indexOf("SELECT") != 0 || !this._action.getPrompts().get(n).isReloadable() || this._action.getPrompts().get(n).getReload().indexOf(n2 + "") <= 0) continue;
            actionSql = new ActionSql(this._action.getPrompts().get(n).getValue(), this._dict);
            actionSql.processSql(this.getTextValues(), this.getValues());
            ((JComboBox)this._textValues.get(n)).setModel(new SQLComboxModel(this._conn, actionSql.getSql(), actionSql.getBinds(), null));
        }
        for (n = 0; n < this._action.getPrompts().size(); ++n) {
            if (this._action.getPrompts().get(n).getDefault().toUpperCase().trim().indexOf("SELECT") != 0 || !this._action.getPrompts().get(n).isReloadable() || this._action.getPrompts().get(n).getReload().indexOf(n2 + "") <= 0) continue;
            actionSql = new ActionSql(this._action.getPrompts().get(n).getDefault(), this._dict);
            actionSql.processSql(this.getTextValues(), this.getValues());
            String string = DBUtil.getInstance().executeReturnOneCol(this._conn, actionSql.getSql(), actionSql.getBinds());
            if (this._textValues.get(n) instanceof RadioGroupPanel) {
                ((RadioGroupPanel)this._textValues.get(n)).setSelectedValue(string);
                continue;
            }
            if (this._textValues.get(n) instanceof JTextField) {
                ((JTextField)this._textValues.get(n)).setText(string);
                continue;
            }
            if (this._textValues.get(n) instanceof JComboBox) {
                ((JComboBox)this._textValues.get(n)).setSelectedItem(string);
                continue;
            }
            if (!(this._textValues.get(n) instanceof JScrollPane)) continue;
            ((BasicEditorPane)((JViewport)((JScrollPane)this._textValues.get(n)).getComponent(0)).getComponent(0)).setText(string);
        }
        this.toggleReadOnlyPrompts(false);
    }

    private void toggleReadOnlyPrompts(boolean bl) {
        for (int i = 0; i < this._action.getPrompts().size(); ++i) {
            if (!this._action.getPrompts().get(i).isReadOnly()) continue;
            if (this._textValues.get(i) instanceof RadioGroupPanel) {
                ((RadioGroupPanel)this._textValues.get(i)).setEnabled(bl);
                continue;
            }
            if (this._textValues.get(i) instanceof JTextField) {
                ((JTextField)this._textValues.get(i)).setEditable(bl);
                continue;
            }
            if (this._textValues.get(i) instanceof JComboBox) {
                ((JComboBox)this._textValues.get(i)).setEditable(bl);
                continue;
            }
            if (!(this._textValues.get(i) instanceof JScrollPane)) continue;
            ((BasicEditorPane)((JViewport)((JScrollPane)this._textValues.get(i)).getComponent(0)).getComponent(0)).setEditable(bl);
        }
    }

    public void update() {
    }

    public ArrayList<JComponent> getTextValues() {
        return this._textValues;
    }

    public Map<String, Object> getDictionary() {
        return this._dict;
    }

    public ObjectAction getAction() {
        return this._action;
    }

    public void setDictionary(Map<String, Object> map) {
        this._dict = map;
    }
}

