/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.util.ArrayList;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectActionPrompt {
    private String _prompt;
    private String _value;
    private String _reload;
    private String _default;
    private String _type;
    private String _required;
    private String _validator;
    private boolean _readOnly;

    public ObjectActionPrompt(Node node) {
        if (node.getNodeName().equalsIgnoreCase("prompt")) {
            this._prompt = XMLHelper.getNodeValue(node, "label");
            this._value = XMLHelper.getNodeValue(node, "value");
            this._default = XMLHelper.getNodeValue(node, "default");
            this._type = XMLHelper.getAttributeNode(node, "type");
            this._required = XMLHelper.getAttributeNode(node, "required");
            this._readOnly = Boolean.parseBoolean(XMLHelper.getAttributeNode(node, "readonly"));
            this._validator = XMLHelper.getAttributeNode(node, "validator");
            this._reload = XMLHelper.getAttributeNode(node, "reload");
        }
    }

    public ObjectActionPrompt(String string, String string2, String string3, String string4, String string5) {
        this._prompt = string;
        this._value = string2;
        this._type = string3;
        this._default = string4;
        this._reload = string5;
    }

    public String getPrompt() {
        return this._prompt == null ? "" : Translate.translate(this._prompt);
    }

    public void setPrompt(String string) {
        this._prompt = string;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String string) {
        this._value = string;
    }

    public String getReload() {
        return this._reload;
    }

    public void setreload(String string) {
        this._reload = string;
    }

    public String getDefault() {
        return this._default;
    }

    public void setDefault(String string) {
        this._default = string;
    }

    public String getType() {
        return this._type == null ? "" : this._type;
    }

    public void setType(String string) {
        this._type = string;
    }

    public void setValidator(String string) {
        this._validator = string;
    }

    public String getValidator() {
        return this._validator;
    }

    public void setRequired(String string) {
        this._required = string;
    }

    public boolean isRequired() {
        return this._required != null && this._required.equalsIgnoreCase("true");
    }

    public void setReadOnly(boolean bl) {
        this._readOnly = bl;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public static ArrayList<ObjectActionPrompt> getPrompts(Node node) {
        ArrayList<ObjectActionPrompt> arrayList = new ArrayList<ObjectActionPrompt>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("prompt")) continue;
            arrayList.add(new ObjectActionPrompt(nodeList.item(i)));
        }
        return arrayList;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toXML(stringBuffer);
        return stringBuffer.toString();
    }

    public void toXML(StringBuffer stringBuffer) {
        stringBuffer.append("<prompt type=\"" + this._type + "\" ");
        if (this._reload != null) {
            stringBuffer.append("reload=\"" + this._reload + "\" ");
        }
        if (this._required != null) {
            stringBuffer.append("required=\"" + this._required + "\" ");
        }
        if (this._validator != null) {
            stringBuffer.append("validator=\"" + this._validator + "\" ");
        }
        stringBuffer.append(">");
        stringBuffer.append("\t<label>" + this._prompt + "</label>");
        if (this._default != null) {
            stringBuffer.append("\t<default><![CDATA[" + this._default + "]]></default>");
        }
        if (this._value != null) {
            stringBuffer.append("\t<value><![CDATA[" + this._value + "]]></value>   ");
        }
        stringBuffer.append("\t</prompt>");
    }

    public boolean isReloadable() {
        return this._reload != null;
    }
}

