/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.StringReader;
import java.net.URL;
import java.sql.PreparedStatement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.sqldialog.ActionSql;
import oracle.dbtools.raptor.controls.sqldialog.ActionSqlPanel;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionPrompt;
import oracle.dbtools.raptor.controls.sqldialog.SQLDialogHelpProvider;
import oracle.dbtools.raptor.controls.sqldialog.SQLPromptPanel;
import oracle.dbtools.raptor.controls.validators.IValidator;
import oracle.dbtools.raptor.controls.validators.ValidatorRegistry;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionCanceledException;
import oracle.jdeveloper.cm.dt.CmUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectActionController
implements Controller {
    private static ObjectActionController _instance;
    private static ArrayList<IObjectActionListener> _listeners;

    public static synchronized Controller getInstance() {
        if (_instance == null) {
            _instance = new ObjectActionController();
        }
        return _instance;
    }

    public static void addListener(IObjectActionListener iObjectActionListener) {
        if (_listeners == null) {
            _listeners = new ArrayList();
        }
        _listeners.add(iObjectActionListener);
    }

    public static void removeListener(IObjectActionListener iObjectActionListener) {
        if (_listeners != null) {
            _listeners.remove(iObjectActionListener);
        }
    }

    private ObjectActionController() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        ObjectAction objectAction = (ObjectAction)ideAction.getValue("ObjectAction.KEY");
        if (objectAction != null) {
            Object object;
            Object object2;
            String string = null;
            HashMap<String, Object> hashMap = null;
            DBObject dBObject = null;
            if (context.getProperty("ObjectAction.DBOBJECT") != null) {
                dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
                string = dBObject.getConnectionName();
            } else if (context.getProperty("ObjectAction.CONN_NAME") != null) {
                string = (String)context.getProperty("ObjectAction.CONN_NAME");
            } else if (objectAction.getMenuItem().getClientProperty("ObjectAction.DBOBJECT") != null) {
                dBObject = (DBObject)objectAction.getMenuItem().getClientProperty("ObjectAction.DBOBJECT");
                string = dBObject.getConnectionName();
            } else {
                object2 = context.getNode().getURL();
                String string2 = string = CmUtil.isCMUrl((URL)object2) ? CmUtil.getConnName((URL)object2) : DBURLFormatHelper.getConnectionName((URL)object2);
            }
            if (context.getProperty("ObjectAction.TARGET.KEY") != null && context.getProperty("ObjectAction.TARGET.KEY") instanceof IDisplay) {
                object2 = (InputEvent)context.getProperty("ObjectAction.EVENT");
                object = null;
                if (object2 != null && object2 instanceof MouseEvent) {
                    object = ((MouseEvent)object2).getPoint();
                }
                hashMap = ((IDisplay)context.getProperty("ObjectAction.TARGET.KEY")).getBinds((Point)object);
            } else if (dBObject == null) {
                dBObject = new DBObject((Element)context.getNode());
                hashMap = dBObject.getDictionary();
                string = dBObject.getConnectionName();
            }
            object2 = objectAction.getClassName();
            try {
                if (objectAction.isConnectionRequired()) {
                    Connections.getInstance().getConnection(string);
                }
            }
            catch (ConnectionCanceledException connectionCanceledException) {
                return true;
            }
            catch (CMException cMException) {
                AbstractConnectionNode.ExceptionWrapper exceptionWrapper = new AbstractConnectionNode.ExceptionWrapper(cMException);
                ExceptionHandler.handleException(exceptionWrapper);
                return true;
            }
            if (object2 == null) {
                try {
                    this.processAction(objectAction, string, hashMap, dBObject);
                }
                catch (ConnectionCanceledException connectionCanceledException) {
                }
                catch (CMException cMException) {
                    ExceptionHandler.handleException((Exception)((Object)cMException));
                }
            } else {
                try {
                    object = (AbstractMenuAction)ideAction.getValue("ObjectAction.CLASS");
                    if (object == null) {
                        object = (AbstractMenuAction)this.getClass().getClassLoader().loadClass((String)object2).newInstance();
                    }
                    ((AbstractMenuAction)object).setDBObject(dBObject);
                    ((AbstractMenuAction)object).setContext(context);
                    ((AbstractMenuAction)object).setArgs(objectAction.getClassArgs());
                    ((AbstractMenuAction)object).launch();
                    DBObject dBObject2 = ((AbstractMenuAction)object).getDBObject();
                    if (dBObject2 != null && objectAction.isConnectionRequired()) {
                        this.postProcessAction(string, objectAction, dBObject2.getDictionary(), null, dBObject);
                    }
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public void processAction(final ObjectAction objectAction, final String string, Map<String, Object> map, final DBObject dBObject) throws CMException {
        Connections.getInstance().getConnection(string);
        SQLPromptPanel sQLPromptPanel = new SQLPromptPanel(objectAction, string, map != null ? map : dBObject.getDictionary());
        if (map != null) {
            sQLPromptPanel.setDictionary(map);
        }
        if (dBObject != null) {
            sQLPromptPanel.setDictionary(dBObject.getDictionary());
        }
        final ActionSqlPanel actionSqlPanel = new ActionSqlPanel(sQLPromptPanel);
        JPanel[] jPanelArray = new JPanel[]{sQLPromptPanel, actionSqlPanel};
        String[] stringArray = new String[]{"Prompts", "SQL"};
        UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, objectAction.getTitle(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectActionController.this.processDialog(actionEvent, actionSqlPanel, objectAction, string, dBObject);
            }
        }, new SQLDialogHelpProvider(objectAction.getHelp()));
    }

    public boolean update(IdeAction ideAction, Context context) {
        String string;
        ObjectAction objectAction = (ObjectAction)ideAction.getValue("ObjectAction.KEY");
        if (objectAction != null && (string = objectAction.getClassName()) != null && objectAction.getControllerClassName() == null) {
            try {
                AbstractMenuAction abstractMenuAction = (AbstractMenuAction)this.getClass().getClassLoader().loadClass(string).newInstance();
                DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
                if (dBObject == null && (dBObject = (DBObject)objectAction.getMenuItem().getClientProperty("ObjectAction.DBOBJECT")) == null) {
                    dBObject = new DBObject((Element)context.getNode());
                }
                abstractMenuAction.setDBObject(dBObject);
                abstractMenuAction.setContext(context);
                abstractMenuAction.setArgs(objectAction.getClassArgs());
                ideAction.setEnabled(abstractMenuAction.isEnabled(context));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDialog(ActionEvent actionEvent, ActionSqlPanel actionSqlPanel, ObjectAction objectAction, String string, DBObject dBObject) {
        if (this.validateValues(string, actionSqlPanel, objectAction)) {
            if (objectAction.getSqlType() != null && objectAction.getSqlType().equalsIgnoreCase("script")) {
                ScriptUtils.runAsScript(new StringReader(objectAction.getSql()), string);
                this.processConfirm(objectAction, actionSqlPanel, string);
                this.postProcessAction(string, objectAction, actionSqlPanel.getDictionary(), actionSqlPanel.getPromptPanel().getValues(), dBObject);
            } else {
                DBUtil.getInstance().setRaiseError(true);
                PreparedStatement preparedStatement = DBUtil.getInstance().prepareExecute(string, actionSqlPanel.getSQL().trim(), actionSqlPanel.getBinds());
                if (preparedStatement == null) {
                    return;
                }
                try {
                    boolean bl = preparedStatement.execute();
                    Log.log(actionSqlPanel.getSQL());
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                    this.processConfirm(objectAction, actionSqlPanel, string);
                    this.postProcessAction(string, objectAction, actionSqlPanel.getDictionary(), actionSqlPanel.getPromptPanel().getValues(), dBObject);
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException(exception);
                }
                finally {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Exception exception) {}
                        preparedStatement = null;
                    }
                }
            }
        }
    }

    private boolean validateValues(String string, ActionSqlPanel actionSqlPanel, ObjectAction objectAction) {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = actionSqlPanel.getPromptPanel().getValues();
        ObjectActionPrompt objectActionPrompt = null;
        String string2 = null;
        Object[] objectArray = new Object[1];
        for (int i = 0; i < arrayList.size(); ++i) {
            IValidator iValidator;
            objectActionPrompt = objectAction.getPrompts().get(i);
            string2 = arrayList.get(i);
            if (objectActionPrompt.getType().equals("confirm")) continue;
            if (objectActionPrompt.isRequired() && (arrayList.get(i) == null || arrayList.get(i).trim().length() == 0)) {
                bl = false;
            }
            if (objectActionPrompt.isRequired() && (string2 == null || string2.trim().equals(""))) {
                stringBuilder.append(objectActionPrompt.getPrompt() + " is required.\n");
                bl = false;
                continue;
            }
            if (objectActionPrompt.getValidator() == null || (iValidator = ValidatorRegistry.getValidator(objectActionPrompt.getValidator())).isValid(string, arrayList.get(i))) continue;
            objectArray[0] = string2;
            stringBuilder.append(MessageFormat.format(iValidator.getMessage(), objectArray));
            bl = false;
        }
        if (!bl) {
            MessageDialog.error((Component)actionSqlPanel, (Object)stringBuilder.toString(), (String)"Error", null);
        }
        return bl;
    }

    private void postProcessAction(String string, ObjectAction objectAction, Map<String, Object> map, ArrayList<String> arrayList, DBObject dBObject) {
        if (_listeners != null) {
            if (objectAction.isRemoveFromParent()) {
                for (IObjectActionListener iObjectActionListener : _listeners) {
                    try {
                        iObjectActionListener.removedFromParent(string, objectAction, map, arrayList, dBObject);
                    }
                    catch (Exception exception) {}
                }
            }
            if (objectAction.getReload()) {
                for (IObjectActionListener iObjectActionListener : _listeners) {
                    try {
                        iObjectActionListener.reload(string, objectAction, map, arrayList, dBObject);
                    }
                    catch (Exception exception) {}
                }
            }
            if (objectAction.getReloadParent()) {
                for (IObjectActionListener iObjectActionListener : _listeners) {
                    try {
                        iObjectActionListener.reloadParent(string, objectAction, map, arrayList, dBObject);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void processConfirm(ObjectAction objectAction, ActionSqlPanel actionSqlPanel, String string) {
        PropertyPanel propertyPanel = new PropertyPanel();
        propertyPanel.removeAll();
        ActionSql actionSql = new ActionSql();
        String string2 = objectAction.getConfirmTitle();
        string2 = string2 == null ? Translate.translate("Success ") : actionSql.manualSubs(string2, actionSqlPanel.getDictionary());
        String string3 = objectAction.getTitle() + " Succeeded";
        if (objectAction.getConfirm() != null && !objectAction.getConfirm().equals("")) {
            string3 = actionSql.manualSubs(objectAction.getConfirm(), actionSqlPanel.getDictionary());
            string3 = actionSql.processPrompts(string3, actionSqlPanel.getPromptPanel().getTextValues(), objectAction.getDefaults());
            if (objectAction.getConfirmSql() != null && !objectAction.getConfirmSql().equals("")) {
                actionSql.setSql(objectAction.getConfirmSql());
                actionSql.setDict(actionSqlPanel.getDictionary());
                actionSql.processSql();
                Map<String, Object> map = DBUtil.getInstance().executeReturnHashMap(string, actionSql.getSql(), actionSql.getBinds());
                string3 = actionSql.manualSubs(string3, map);
            }
        }
        propertyPanel.addSingleComp(string3);
        UIUtils.showPanelAsDialog((JPanel)propertyPanel, string2, null, 1);
    }
}

