/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.progress;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;

public class DelayedProgressRunnable {
    private IndeterminateProgressMonitor _monitor;
    private JScrollPane _detailPane;
    private Component _detailComp;
    private IDelayedProgressRunnable _run;
    private Thread _monThread;
    private Thread _runThread;
    private Logger logger = Logger.getLogger(DelayedProgressRunnable.class.getName());

    public DelayedProgressRunnable(String string, String string2, int n, IDelayedProgressRunnable iDelayedProgressRunnable) {
        this(string, string2, n, iDelayedProgressRunnable, new JTextArea());
    }

    public DelayedProgressRunnable(String string, String string2, int n, IDelayedProgressRunnable iDelayedProgressRunnable, Component component) {
        this._detailComp = component;
        this._run = iDelayedProgressRunnable;
        this._monitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), string, (Object)string2, null);
        this._monitor.setMillisToPopup(n);
        this._detailPane = new JScrollPane(this._detailComp);
        this._detailPane.setVerticalScrollBarPolicy(20);
        this._detailPane.setHorizontalScrollBarPolicy(30);
        this._monitor.setDetailContent((Component)this._detailPane);
        this._monitor.setCloseOnFinish(true);
        this._monitor.setCancellable(false);
    }

    public ProgressPanel getProgressPanel() {
        return this._monitor.getPanel();
    }

    public Component getDetailComponent() {
        return this._detailComp;
    }

    public void setCancellable(boolean bl) {
        this._monitor.setCancellable(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object;
        block13: {
            this.logger.info("Doing close");
            try {
                this._monThread.interrupt();
                if (this._monitor == null) break block13;
                object = this._monitor;
                synchronized (object) {
                    this._monitor.finish();
                    this._monitor.close();
                }
            }
            catch (Throwable throwable) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Ide.getWaitCursor().hide();
                    }
                });
                DelayedProgressRunnable delayedProgressRunnable = this;
                synchronized (delayedProgressRunnable) {
                    if (this._monitor != null) {
                        this._monitor.finish();
                        this._monitor.close();
                        this._monitor = null;
                    }
                }
                throw throwable;
            }
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        object = this;
        synchronized (object) {
            if (this._monitor != null) {
                this._monitor.finish();
                this._monitor.close();
                this._monitor = null;
            }
        }
    }

    public void setRunnable(IDelayedProgressRunnable iDelayedProgressRunnable) {
        this._run = iDelayedProgressRunnable;
    }

    public void setMillisToPopup(int n) {
        this._monitor.setMillisToPopup(n);
    }

    public void setCloseOnFinish(boolean bl) {
        this._monitor.setCloseOnFinish(bl);
    }

    public void start() {
        this._monitor.start();
        MonitorRunner monitorRunner = new MonitorRunner();
        this._monThread = new Thread((Runnable)monitorRunner, "MonitorThread");
        this.logger.info("Starting monitor thread");
        this._monThread.start();
        this._runThread = new RunnerThread();
        this.logger.info("Starting runner thread");
        this._runThread.start();
    }

    private synchronized boolean isRunning() {
        return this._monitor != null && !this._monitor.isCanceled();
    }

    private synchronized boolean isCancelled() {
        return this._monitor != null && this._monitor.isCanceled();
    }

    class MonitorRunner
    implements Runnable {
        MonitorRunner() {
        }

        public void run() {
            while (DelayedProgressRunnable.this.isRunning()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            if (DelayedProgressRunnable.this.isCancelled()) {
                DelayedProgressRunnable.this._runThread.interrupt();
                DelayedProgressRunnable.this._run.cancel();
                DelayedProgressRunnable.this._runThread.interrupt();
                DelayedProgressRunnable.this.close();
            }
            if (DelayedProgressRunnable.this._monitor != null) {
                DelayedProgressRunnable.this._monitor.close();
            }
        }
    }

    class RunnerThread
    extends Thread {
        RunnerThread() {
            super("RunnerThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable runnable = new Runnable(){

                    public void run() {
                        Ide.getWaitCursor().show();
                        DelayedProgressRunnable.this.logger.info("Doing preWork");
                        DelayedProgressRunnable.this._run.preWork();
                    }
                };
                EventQueue.invokeAndWait(runnable);
                DelayedProgressRunnable.this.logger.info("Doing doWork");
                final Object object = DelayedProgressRunnable.this._run.doWork();
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        try {
                            DelayedProgressRunnable.this.logger.info("Doing finish");
                            DelayedProgressRunnable.this._run.finish(object);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                DelayedProgressRunnable.this._run.cancel();
                DelayedProgressRunnable.this.close();
            }
            finally {
                DelayedProgressRunnable.this.close();
            }
            if (DelayedProgressRunnable.this._monitor != null) {
                DelayedProgressRunnable.this._monitor.close();
            }
        }
    }
}

