/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.SimpleIdeCore;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.jdbc.driver.OracleDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayTest {
    private static Connection CONN;

    public static void main(String[] stringArray) throws Exception {
        DriverManager.registerDriver((Driver)new OracleDriver());
        String string = "jdbc:oracle:thin:@stacw26.us.oracle.com:1521:utf";
        CONN = DriverManager.getConnection(string, "system", "manager");
        CONN.setAutoCommit(false);
        SimpleIdeCore.initIde();
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        arrayList.add(DisplayTest.createModel("A Objects", "select * from dual", null));
        arrayList.add(DisplayTest.createDoubleModel("select * from all_objects where object_name like 'C%'", "select * from all_objects where object_name like 'D%'", "select * from all_objects where object_name like 'E%'", "select * from all_objects where object_name like 'F%'"));
        arrayList.add(DisplayTest.createChildModel("select object_name name,ao.*from all_objects ao where object_name like 'C%'", "select * from all_objects where object_name = :NAME"));
        arrayList.add(DisplayTest.createNested());
        arrayList.add(DisplayTest.createCode());
        arrayList.add(DisplayTest.createDetailCode());
        DisplayModel displayModel = DisplayTest.createModel("BIND TEST", "select * from all_objects where object_name like :NAME", null);
        Bind bind = new Bind("NAME", null, "Enter Name", null, "Enter object name");
        ArrayList<Bind> arrayList2 = new ArrayList<Bind>();
        arrayList2.add(bind);
        displayModel.setQueriesBinds(arrayList2);
        arrayList.add(displayModel);
        DisplayTest.showModels(arrayList);
    }

    private static DisplayModel createCode() {
        DisplayModel displayModel = DisplayTest.createModel("code", "select text from dba_source where rownum  < 1000 ", null);
        displayModel.setType("code");
        return displayModel;
    }

    private static DisplayModel createDetailCode() {
        DisplayModel displayModel = DisplayTest.createModel("procedures", "select * from dba_objects where object_type = 'PROCEDURE'", null);
        DisplayModel displayModel2 = DisplayTest.createModel("source", "select text from dba_source where name = :OBJECT_NAME and owner = :OWNER", "code");
        displayModel2.setType("code");
        displayModel.addChild(displayModel2);
        return displayModel;
    }

    private static DisplayModel createNested() {
        DisplayModel displayModel = DisplayTest.createModel("master-detail-detail", "select * from dba_objects where object_type = 'TABLE'", null);
        DisplayModel displayModel2 = DisplayTest.createModel("all_Tables", "select * from all_tables where table_name = :OBJECT_NAME and owner = :OWNER", "masterdetail");
        DisplayModel displayModel3 = DisplayTest.createModel("all_Tabcols", "select * from all_tab_columns where table_name = :TABLE_NAME and owner = :OWNER", "masterdetail");
        displayModel2.addChild(displayModel3);
        displayModel.addChild(displayModel2);
        return displayModel;
    }

    private static DisplayModel createChildModel(String string, String string2) {
        DisplayModel displayModel = DisplayTest.createModel("master-detail", string, null);
        displayModel.addChild(DisplayTest.createModel("Child1:" + System.currentTimeMillis(), string2, "masterdetails"));
        return displayModel;
    }

    public static void showModels(ArrayList<DisplayModel> arrayList) throws Exception {
        JPanel[] jPanelArray = new DisplayPanel[arrayList.size()];
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        for (DisplayModel displayModel : arrayList) {
            stringArray[n] = displayModel.getName();
            jPanelArray[n] = new DisplayPanel(displayModel);
            ++n;
        }
        UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, "Test", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JEWTDialog jEWTDialog = (JEWTDialog)actionEvent.getSource();
                CustomTabbedPane customTabbedPane = (CustomTabbedPane)jEWTDialog.getContent();
                DisplayPanel displayPanel = (DisplayPanel)customTabbedPane.getActivePanel();
                UIUtils.makeTitledBorder(displayPanel, "T:" + System.currentTimeMillis());
                displayPanel.refresh(true, true);
            }
        });
        System.exit(0);
    }

    public static DisplayModel createDoubleModel(String string, String string2, String string3, String string4) {
        DisplayModel displayModel = DisplayTest.createModel("title", string, null);
        displayModel.addChild(DisplayTest.createModel("Bottom1:" + System.currentTimeMillis(), string2, null));
        displayModel.addChild(DisplayTest.createModel("Bottom2:" + System.currentTimeMillis(), string3, null));
        displayModel.addChild(DisplayTest.createModel("Bottom3:" + System.currentTimeMillis(), string4, null));
        return displayModel;
    }

    public static DisplayModel createModel(String string, String string2, String string3) {
        DisplayModel displayModel = new DisplayModel();
        Query query = new Query();
        query.setSql(string2);
        ArrayList<Query> arrayList = new ArrayList<Query>();
        arrayList.add(query);
        displayModel.setQueries(arrayList);
        displayModel.setConnection(CONN);
        displayModel.setName(string);
        displayModel.setStyle(string3);
        return displayModel;
    }
}

