/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dss.graph.Graph;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplaySimpleChart
extends DisplayAdapter {
    private Graph _graph;
    private JScrollPane _spSql;
    private Boolean _show;

    public Boolean getBoolean(String string) {
        try {
            String string2 = this.getExtVales().get(string);
            if (string2.equals("true")) {
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getStyle() {
        String string = this.getExtVales().get("STYLE");
        if (string == null) {
            return null;
        }
        if (string.equals("Autumn")) {
            return "/oracle/dss/graph/styles/autumn_simple.xml";
        }
        if (string.equals("Black and White")) {
            return "/oracle/dss/graph/styles/blackwhite.xml";
        }
        if (string.equals("Earth")) {
            return "/oracle/dss/graph/styles/earth.xml";
        }
        if (string.equals("Executive")) {
            return "/oracle/dss/graph/styles/executive.xml";
        }
        if (string.equals("Financial")) {
            return "/oracle/dss/graph/styles/financial.xml";
        }
        if (string.equals("Projection")) {
            return "/oracle/dss/graph/styles/projection.xml";
        }
        if (string.equals("Regatta")) {
            return "/oracle/dss/graph/styles/regatta_simple.xml";
        }
        return null;
    }

    public void init() {
        if (this._graph == null) {
            this._graph = new Graph();
            this._graph.setVisible(false);
            try {
                if (this.getStyle() != null) {
                    this._graph.setStylePath(this.getStyle());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.getBoolean("GRADIENT").booleanValue()) {
                this._graph.setSeriesEffect(1);
            } else {
                this._graph.setSeriesEffect(0);
            }
            this._graph.getLegendArea().setVisible(this.getBoolean("LEGEND").booleanValue());
            this._graph.getX1MajorTick().setVisible(this.getBoolean("GRID").booleanValue());
            this._graph.getY1MajorTick().setVisible(this.getBoolean("GRID").booleanValue());
            this._graph.getY2MajorTick().setVisible(this.getBoolean("GRID").booleanValue());
            this._graph.set3DEffect(this.getBoolean("THREED").booleanValue());
            String string = this.getExtVales().get("TYPE");
            if (string.equals("PIE_MULTI")) {
                this._graph.setGraphType(57);
            } else if (string.equals("BAR_HORIZ_CLUST")) {
                this._graph.setGraphType(24);
            } else if (string.equals("BAR_VERT_CLUST")) {
                this._graph.setGraphType(17);
            } else if (string.equals("BAR_VERT_STACK")) {
                this._graph.setGraphType(18);
            } else if (string.equals("BAR_HORIZ_STACK")) {
                this._graph.setGraphType(25);
            }
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)DBConfig.getInstance().getString("NLS_LANG"), (String)DBConfig.getInstance().getString("NLS_TERR"));
            Locale locale = oraLocaleInfo.getLocale();
            this._graph.setLocale(locale);
            this._spSql = new JScrollPane((Component)this._graph, 22, 32);
            this._spSql.setPreferredSize(new Dimension(400, 400));
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._spSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void refresh(boolean var1_1) {
        if (this._graph == null) {
            this.init();
        }
        this._graph.setVisible(true);
        var2_2 = this._graph.getMarkerText();
        var2_2.getViewFormat(0).setDecimalDigit(2);
        var2_2.getViewFormat(1).setDecimalDigit(2);
        var2_2.getViewFormat(2).setDecimalDigit(2);
        var2_2.getViewFormat(3).setDecimalDigit(2);
        var2_2.getViewFormat(4).setDecimalDigit(2);
        var3_3 = null;
        var4_4 = null;
        this._show = false;
        var5_5 = this.getConnection();
        synchronized (var5_5) {
            block33: {
                block32: {
                    try {
                        if (this.getQuery().getSql() == null || this.getQuery().getSql().equals("")) {
                            this._graph.setVisible(false);
                            break block32;
                        }
                        var3_3 = this.getConnection().prepareStatement(this.getQuery().getSql());
                        DBUtil.getInstance().bind(this.getQuery().getSql(), (PreparedStatement)var3_3, this.getBindMap());
                        var4_4 = var3_3.executeQuery();
                        var6_8 = null;
                        var7_14 = new ArrayList<Object[]>();
                        while (var4_4.next()) {
                            var6_8 = new Object[var4_4.getMetaData().getColumnCount()];
                            for (var8_15 = 1; var8_15 < var4_4.getMetaData().getColumnCount() + 1; ++var8_15) {
                                var6_8[var8_15 - 1] = var8_15 > 2 ? var4_4.getBigDecimal(var8_15) : var4_4.getString(var8_15);
                            }
                            var7_14.add(var6_8);
                        }
                        if (var7_14.size() > 0) {
                            this._show = this._graph.setTabularData(var7_14);
                        }
                        break block33;
                    }
                    catch (Exception var6_11) {
                        ExceptionHandler.handleException(var6_11);
                        break block33;
                    }
                }
                return;
                finally {
                    try {
                        if (var3_3 != null) {
                            var3_3.close();
                        }
                    }
                    catch (SQLException var6_12) {}
                    try {
                        if (var4_4 != null) {
                            var4_4.close();
                        }
                    }
                    catch (SQLException var6_13) {}
                }
            }
            ** if (!this._show.booleanValue()) goto lbl55
        }
lbl-1000:
        // 1 sources

        {
            this._graph.setVisible(true);
        }
lbl55:
        // 2 sources

    }

    @Override
    public void addActions(final ArrayList<ObjectAction> arrayList) {
        if (arrayList != null) {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 2) {
                        ContextMenu contextMenu = new ContextMenu();
                        for (ObjectAction objectAction : arrayList) {
                            contextMenu.add((Component)objectAction.getMenuItem());
                        }
                        Context context = new Context();
                        context.setEvent((EventObject)mouseEvent);
                        contextMenu.show(context);
                    }
                }
            };
            if (this._graph == null) {
                this.init();
            }
            this._graph.addMouseListener((MouseListener)mouseAdapter);
        }
    }

    @Override
    public void clear() {
        if (this._graph == null) {
            this.init();
        }
        this._graph.setVisible(false);
    }
}

