/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.scriptrunner.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.ContextMenu;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayScript
extends DisplayAdapter {
    private BasicEditorPane _codeArea;
    private JScrollPane _spSql;

    public void init() {
        if (this._codeArea == null) {
            this._codeArea = EditorFactory.createIdeEditorPane();
            this._codeArea.setText("");
            this._codeArea.setDocument((Document)new BasicDocument("foo.plsql"));
            this._codeArea.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this._codeArea.setText("");
            this._codeArea.setEditable(false);
            LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
            this._codeArea.installPlugin((EditorPlugin)lineGutterPlugin);
            this._spSql = new JScrollPane((Component)this._codeArea, 22, 32);
            this._spSql.setRowHeaderView((Component)lineGutterPlugin);
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._spSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(boolean bl) {
        this.init();
        Connection connection = this.getConnection();
        synchronized (connection) {
            try {
                this._codeArea.getDocument().remove(0, this._codeArea.getDocument().getLength());
                ScriptRunner scriptRunner = new ScriptRunner(this.getQuery().getSql(), this.getConnection());
                this._codeArea.setEditable(true);
                scriptRunner.setScriptRunnerContext(new ScriptRunnerContext());
                PipedInputStream pipedInputStream = new PipedInputStream();
                BufferedOutputStream bufferedOutputStream = null;
                bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                scriptRunner.setOut(bufferedOutputStream);
                scriptRunner.start();
                OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, this._codeArea.getDocument(), this._codeArea);
                outputRedirector.setName("Report output reader");
                outputRedirector.start();
                this._codeArea.setEditable(false);
                String string = this._codeArea.getText();
            }
            catch (Exception exception) {
                ExceptionHandler.handleException(exception);
            }
        }
    }

    @Override
    public void addActions(final ArrayList<ObjectAction> arrayList) {
        if (arrayList != null) {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 2) {
                        ContextMenu contextMenu = new ContextMenu();
                        for (ObjectAction objectAction : arrayList) {
                            contextMenu.add((Component)objectAction.getMenuItem());
                        }
                        Context context = new Context();
                        context.setEvent((EventObject)mouseEvent);
                        contextMenu.show(context);
                    }
                }
            };
            this.init();
            this._codeArea.addMouseListener((MouseListener)mouseAdapter);
        }
    }

    @Override
    public void clear() {
        this._codeArea.setText("");
    }

    @Override
    public BasicEditorPane getCodeEditor() {
        return this._codeArea;
    }
}

