/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayModelCache;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.table.ResultsSetTableContextMenu;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayResultTable
extends DisplayAdapter
implements ISelectionChangeListener {
    private Logger logger = Logger.getLogger(DisplayResultTable.class.getName());
    private ResultSetTable _table;
    private HashMap<String, Object> _binds;
    private DisplayRTContextMenuListener _menu;

    public void initTable() {
        if (this._table == null) {
            this._table = new ResultSetTable();
            this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    DisplayResultTable.this.fireSelectionChanged();
                }
            });
        }
        this._table.setMinimumSize(new Dimension(200, 200));
    }

    @Override
    public JComponent getUI() {
        this.logger.info("DisplayResultTable.getUI()");
        this.initTable();
        return this._table;
    }

    @Override
    public void close() {
        this.logger.info("DisplayResultTable.close()");
        this._binds = null;
        if (this._table != null) {
            this._table.closeModel();
        }
        if (this._menu != null) {
            ResultsSetTableContextMenu.getContextMenu().removeContextMenuListener((ContextMenuListener)this._menu);
        }
        this._table = null;
    }

    @Override
    public void refresh(boolean bl) {
        this.logger.info("DisplayResultTable.refresh(" + bl + ")");
        if (this.getQuery().getSql() == null) {
            return;
        }
        if (this._table == null) {
            this.initTable();
        }
        this._table.setThreaded(false);
        HashMap<String, Object> hashMap = this.getBindMap();
        Iterator<String> iterator = hashMap.keySet().iterator();
        String string = null;
        while (iterator.hasNext()) {
            string = iterator.next();
            this.logger.info(string + "=" + hashMap.get(string));
        }
        if ((bl || this.isDirty()) && (this.getQuery().getSql().indexOf(":") == -1 || this.getQuery().getSql().indexOf(":") > 0 && hashMap != null)) {
            this._table.closeModel();
            String string2 = this.getExtVales().get("TYPE");
            if (string2 != null && string2.equalsIgnoreCase("vertical")) {
                this._table.setVerticalDisplay(true);
            }
            this._table.setQuery(this.getConnection(), null, QueryUtils.expandQuery(this.getQuery().getSql(), hashMap), hashMap);
            this.logger.info("\n\n     Loading....\n" + this.getQuery().getSql());
            this.setDirty(false);
        }
    }

    public HashMap<String, Object> getBinds() {
        this.logger.info("DisplayResultTable.getBinds()");
        return this._binds;
    }

    @Override
    public HashMap<String, Object> getBinds(Point point) {
        if (point != null) {
            this.logger.info("DisplayResultTable.getBinds(" + point.getX() + "," + point.getY() + ")");
        }
        if (this._binds == null) {
            this._binds = new HashMap();
        } else {
            this._binds.clear();
        }
        int n = this._table.getSelectedRow();
        if (n == -1 && point != null) {
            n = this._table.rowAtPoint(point);
        }
        if (n > -1) {
            int n2 = this._table.getColumnCount();
            String string = this.getExtVales().get("TYPE");
            if (string != null && string.equalsIgnoreCase("vertical")) {
                String string2 = ((ResultSetTableModel)this._table.getModel()).getValueAt(n, 1).toString();
                Object object = ((ResultSetTableModel)this._table.getModel()).getValueAt(n, 2);
                this._binds.put(string2, object);
            } else {
                for (int i = 0; i < n2; ++i) {
                    String string3 = this._table.getRawColumnName(i);
                    Object object = ((ResultSetTableModel)this._table.getModel()).getValueAt(n, i + 1);
                    this._binds.put(string3, object);
                }
            }
        }
        return this._binds;
    }

    @Override
    public void parentSelectionChanged() {
        if (this._table != null && this._table.isShowing()) {
            this.setDirty(true);
            this.refresh(true);
        }
    }

    @Override
    public void addActions(ArrayList<ObjectAction> arrayList) {
        this._menu = new DisplayRTContextMenuListener(this, arrayList);
        ResultsSetTableContextMenu.getContextMenu().addContextMenuListener((ContextMenuListener)this._menu);
    }

    public void getDrillableReports(ContextMenu contextMenu) {
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = DisplayModelCache.getIds();
        HashMap<String, Object> hashMap = this.getBinds();
        for (String string : arrayList2) {
            DisplayModel displayModel = DisplayModelCache.getDisplayModel(string);
            Query query = displayModel.getQueries() == null ? null : QueryUtils.getQuery(displayModel.getQueries(), this.getConnection());
            if (query == null) continue;
            List<Bind> list = query.getBinds();
            boolean bl = query.getBinds().size() > 0;
            for (Bind bind : list) {
                if (hashMap.containsKey(bind.getName())) continue;
                bl = false;
            }
            if (!bl) continue;
            ObjectAction objectAction = new ObjectAction();
            objectAction.setClassName("oracle.report.addin.DrillReportAction");
            objectAction.setClassArgs(string);
            objectAction.setTitle(displayModel.getName());
            JMenuItem jMenuItem = objectAction.getMenuItem(contextMenu);
            contextMenu.add((Component)jMenuItem);
        }
    }

    @Override
    public void clear() {
        if (this._table != null && this._table.getModel() != null) {
            this._table.closeModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DisplayRTContextMenuListener
    implements ContextMenuListener {
        private DisplayResultTable _display;
        private ArrayList<ObjectAction> _actions;

        DisplayRTContextMenuListener(DisplayResultTable displayResultTable2, ArrayList<ObjectAction> arrayList) {
            this._display = displayResultTable2;
            this._actions = arrayList;
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Object object = contextMenu.getContext().getProperty("RSETTABLE");
            ResultSetTable resultSetTable = DisplayResultTable.this._table;
            if (contextMenu.getContext().getProperty("RSETTABLE") == DisplayResultTable.this._table) {
                contextMenu.getContext().setProperty("ObjectAction.EVENT", (Object)contextMenu.getContext().getEvent());
                contextMenu.getContext().setProperty("ObjectAction.TARGET.KEY", (Object)this._display);
                contextMenu.getContext().setProperty("ObjectAction.CONN_NAME", (Object)this._display.getConnName());
                if (this._actions != null) {
                    for (ObjectAction objectAction : this._actions) {
                        contextMenu.add((Component)objectAction.getMenuItem(contextMenu));
                    }
                }
                DisplayResultTable.this.getDrillableReports(contextMenu);
            }
        }
    }
}

