/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.diff;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.FilePanelAcc;
import oracle.dbtools.raptor.controls.diff.SourceSelector;
import oracle.dbtools.util.Translate;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class ResultPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public BasicEditorPane _sql;
    public JButton _saveAs = new JButton(Translate.translate("Save As"));
    public JButton _openEditor = new JButton(Translate.translate("Open Editor"));
    private SourceSelector _source;

    public BasicEditorPane getSqlPane() {
        return this._sql;
    }

    private void openSQLEditor() {
        RaptorDBAddin.getSqlOpener().openNewEditor(this._sql.getText(), this._source.getDatabase().getConnectionName());
    }

    private void savePrompt() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Diff File Chooser");
        String string = (String)DBConfig.getInstance().getParameter("EXPORTDIR") + File.separator;
        if (string == null || string.equals("")) {
            string = System.getProperty("user.home");
        }
        File file = new File(string + "dbDiff.sql");
        jFileChooser.setSelectedFile(file);
        jFileChooser.setAccessory(new FilePanelAcc());
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            this.saveFile(jFileChooser.getSelectedFile().toString(), this._sql.getText(), ((FilePanelAcc)jFileChooser.getAccessory()).getEncoding());
        }
    }

    private void saveFile(String string, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string3);
            outputStreamWriter.write(string2);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ResultPanel(SourceSelector sourceSelector) {
        this._source = sourceSelector;
        this._openEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.openSQLEditor();
            }
        });
        this._saveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.savePrompt();
            }
        });
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_diffresults_html");
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        jLabel.setText("SQL:");
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 5, 0), 0, 0));
        this._sql = EditorFactory.createIdeEditorPane();
        this._sql.setPreferredSize(new Dimension(300, 200));
        this._sql.setText("");
        this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
        this._sql.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this._sql.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
        jScrollPane.setPreferredSize(this._sql.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this._saveAs, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.add((Component)this._openEditor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 5, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("You must press the CLOSE button to close this dialog.");
        this.add((Component)jLabel2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 5, 0), 0, 0));
    }
}

