/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.diff;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.help.HelpSystem;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabase;

public class DestinationSelector
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DBConnectionComboBox _dbComboBox;
    private OracleDatabase _db;
    private JScrollPane _sp;
    private JList _list;
    private DefaultListModel _model = new DefaultListModel();

    public DestinationSelector() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_diffdest_html");
        this.setLayout(new SpringLayout());
        this.add(new JLabel(Translate.translate("Connection:")));
        this._dbComboBox = new DBConnectionComboBox();
        this.add(this._dbComboBox.getJComboBox());
        this.add(new JLabel(Translate.translate("Schemas:")));
        this._sp = new JScrollPane();
        this._sp.setMinimumSize(new Dimension(200, 200));
        this.add(this._sp);
        this._list = new JList(this._model);
        this._list.setSelectionMode(0);
        this._dbComboBox.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DestinationSelector.this.initList();
                }
            }
        });
        SpringUtilities.makeCompactGrid(this, 4, 1, 0, 0, 0, 2);
    }

    private void initList() {
        this._model.clear();
        try {
            this._db = (OracleDatabase)this._dbComboBox.getCurrentDatabase();
            for (Schema schema : this._db.listSchemas()) {
                this._model.addElement(schema.toString());
            }
            this._sp.setViewportView(this._list);
        }
        catch (DBException dBException) {
            DBException dBException2 = dBException.getCause() instanceof Exception ? (Exception)dBException.getCause() : dBException;
            ExceptionHandler.handleException((Exception)((Object)dBException2));
        }
    }

    public Schema getSchema() {
        try {
            return this._dbComboBox.getCurrentDatabase().getSchema(this._list.getSelectedValue().toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public OracleDatabase getDatabase() {
        return this._db;
    }
}

