/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.cellrenderers;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.swing.JTable;
import oracle.dbtools.raptor.controls.cellrenderers.ICellRenderer;
import oracle.dbtools.raptor.controls.cellrenderers.NestedTableRenderer;
import oracle.dbtools.raptor.controls.cellrenderers.XMLTypeRenderer;
import oracle.sql.OPAQUE;

public class CellRenderingFactory {
    private static HashMap<Class, Stack<ICellRenderer>> renderers = new HashMap();

    public static void registerCellRenderer(Class clazz, ICellRenderer iCellRenderer) {
        if (renderers.get(clazz) == null) {
            renderers.put(clazz, new Stack());
        }
        renderers.get(clazz).push(iCellRenderer);
    }

    public static String getText(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = null;
        if (object != null && renderers.get(object.getClass()) != null) {
            for (ICellRenderer iCellRenderer : renderers.get(object.getClass())) {
                try {
                    string = iCellRenderer.getText(jTable, object, bl, bl2, n, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return string;
    }

    public static Component getComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = null;
        if (object != null && renderers.get(object.getClass()) != null) {
            for (ICellRenderer iCellRenderer : renderers.get(object.getClass())) {
                try {
                    component = iCellRenderer.getComponent(jTable, object, bl, bl2, n, n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return component;
    }

    static {
        CellRenderingFactory.registerCellRenderer(OPAQUE.class, new XMLTypeRenderer());
        CellRenderingFactory.registerCellRenderer(List.class, new NestedTableRenderer());
        CellRenderingFactory.registerCellRenderer(ArrayList.class, new NestedTableRenderer());
    }
}

