/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.celleditor.CellEditingFactory;
import oracle.dbtools.raptor.controls.celleditor.DateTimeEditPanel;
import oracle.dbtools.raptor.controls.celleditor.ExtendedTypeEditPanel;
import oracle.dbtools.raptor.controls.celleditor.LongCharEditPanel;
import oracle.dbtools.raptor.controls.celleditor.RSTableEditorJPanel;
import oracle.dbtools.raptor.controls.celleditor.RSTableEditorTextField;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.ExtendedTypeFactory;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.IdeIcons;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.DATE;
import oracle.sql.RAW;

public class ResultSetCellEditor
extends DefaultCellEditor {
    ResultSetTableModel rsTm = null;
    private Object origValue = null;

    public ResultSetCellEditor() {
        super(new RSTableEditorTextField());
    }

    public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component;
        final Object object2 = object;
        this.origValue = null;
        TableModel tableModel = jTable.getModel();
        boolean bl2 = true;
        if (tableModel instanceof ResultSetTableModel) {
            this.rsTm = (ResultSetTableModel)tableModel;
            bl2 = this.rsTm instanceof EditableResultSetTableModel;
        }
        if ((component = CellEditingFactory.getComponent(jTable, object, n, n2)) != null) {
            this.origValue = this.rsTm != null ? DataTypesUtil.stringValue(object, this.rsTm.getConnection()) : DataTypesUtil.stringValue(object, null);
            return component;
        }
        String string = CellEditingFactory.getText(jTable, object, n, n2);
        final int n3 = this.getType(jTable, n2);
        if (string != null) {
            object = string;
        } else if (this.rsTm != null && this.rsTm.getConnection() != null) {
            if (DataTypesUtil.isExtendedType(object, n3)) {
                this.origValue = object;
            }
            object = DataTypesUtil.stringValue(object, this.rsTm.getConnection());
        }
        RSTableEditorTextField rSTableEditorTextField = (RSTableEditorTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        rSTableEditorTextField.setEditable(this.isEnabled(n3) && bl2);
        boolean bl3 = true;
        Object object3 = rSTableEditorTextField.getMouseListeners();
        int n4 = ((MouseListener[])object3).length;
        for (int i = 0; i < n4; ++i) {
            MouseListener mouseListener = object3[i];
            if (!(mouseListener instanceof DblClickListener)) continue;
            bl3 = false;
        }
        if (bl3) {
            rSTableEditorTextField.addMouseListener(new DblClickListener(jTable));
        }
        if ((object3 = rSTableEditorTextField.getDocument()) != null) {
            object3.putProperty("filterNewlines", Boolean.FALSE);
            rSTableEditorTextField.setText(object != null ? object.toString() : "");
        }
        RSTableEditorJPanel rSTableEditorJPanel = new RSTableEditorJPanel(rSTableEditorTextField);
        if (ResultSetCellEditor.hasExtendedEdit(n3)) {
            JButton jButton = new JButton(IdeIcons.getIcon((int)20));
            jButton.setMargin(new Insets(2, 2, 2, 2));
            final boolean bl4 = this.isEnabled(n3) && bl2;
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ResultSetCellEditor.this.origValue instanceof BLOB || n3 == 2004 || ResultSetCellEditor.this.origValue instanceof BFILE || n3 == -13) {
                        ResultSetCellEditor.this.showExtendedTypeEdit(ResultSetCellEditor.this.origValue, n3, jTable);
                    } else if (ResultSetCellEditor.this.origValue instanceof Clob || n3 == 2005) {
                        try {
                            ResultSetCellEditor.this.showLongCharEdit(object2 != null && !object2.toString().equals("") ? ((Clob)object2).getSubString(1L, (int)((Clob)object2).length()) : "", bl4);
                        }
                        catch (SQLException sQLException) {}
                    } else if (object2 instanceof DATE || n3 == 91) {
                        ResultSetCellEditor.this.showDateTimeEdit(object2, bl4, ResultSetCellEditor.this.rsTm.getConnection());
                    } else {
                        ResultSetCellEditor.this.showLongCharEdit(ResultSetCellEditor.this.getCellEditorValue(), bl4);
                    }
                    jTable.requestFocusInWindow();
                }
            });
            rSTableEditorJPanel.add((Component)jButton, "East");
            rSTableEditorJPanel.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                }
            });
        }
        return rSTableEditorJPanel;
    }

    public boolean isCellEditable(EventObject eventObject) {
        MouseEvent mouseEvent;
        return !(eventObject instanceof MouseEvent) || (mouseEvent = (MouseEvent)eventObject).getClickCount() == 2;
    }

    public Object getCellEditorValue() {
        return this.origValue != null ? this.origValue : super.getCellEditorValue();
    }

    public void setValue(Object object) {
        this.delegate.setValue(object);
    }

    private int getType(JTable jTable, int n) {
        int n2 = 0;
        TableModel tableModel = jTable.getModel();
        if (tableModel instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)tableModel;
            int[] nArray = resultSetTableModel.getTypes();
            if (nArray != null && nArray.length >= n) {
                n2 = nArray[n];
            }
        } else if (tableModel instanceof DefaultTableModel && n == 0) {
            return 2005;
        }
        return n2;
    }

    protected boolean isEnabled(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2007: {
                return false;
            }
        }
        return true;
    }

    public static boolean hasExtendedEdit(int n) {
        switch (n) {
            case -13: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 12: 
            case 91: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    private void showLongCharEdit(Object object, boolean bl) {
        LongCharEditPanel longCharEditPanel = new LongCharEditPanel(object, bl);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)longCharEditPanel, (Component)longCharEditPanel.getDefaultComponent(), (String)ControlsArb.getString(0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)longCharEditPanel, "f1_extendeddataedit_html");
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if (!"closed".equals(propertyChangeEvent.getPropertyName()) || Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    // empty if block
                }
            }
        });
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(bl);
        if (object instanceof RAW) {
            longCharEditPanel.setText(((RAW)object).stringValue());
        } else {
            longCharEditPanel.setText(object.toString());
        }
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.setValue(longCharEditPanel.getText());
            this.stopCellEditing();
        } else {
            this.cancelCellEditing();
        }
        longCharEditPanel.close();
    }

    private void showExtendedTypeEdit(Object object, int n, JTable jTable) {
        ExtendedType extendedType;
        if ("".equals(object)) {
            object = null;
        }
        try {
            extendedType = ExtendedTypeFactory.getExtendedType(object, n);
        }
        catch (ClassCastException classCastException) {
            extendedType = null;
        }
        if (extendedType == null) {
            return;
        }
        ExtendedTypeEditPanel extendedTypeEditPanel = ExtendedTypeFactory.getEditPanel(extendedType, n);
        extendedTypeEditPanel.setJTable(jTable);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)extendedTypeEditPanel, (Component)extendedTypeEditPanel.getDefaultComponent(), (String)ControlsArb.getString(0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)extendedTypeEditPanel, "f1_extendeddataedit_html");
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(true);
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            if (extendedTypeEditPanel.processExtendedType()) {
                this.origValue = extendedType;
                this.setValue(object);
                this.stopCellEditing();
            } else {
                this.cancelCellEditing();
            }
        }
    }

    private void showDateTimeEdit(Object object, boolean bl, Connection connection) {
        OraDATEFormat oraDATEFormat = null;
        try {
            oraDATEFormat = NLSUtils.getOraDATEFormat(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DateTimeEditPanel dateTimeEditPanel = new DateTimeEditPanel(object, bl, connection);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)dateTimeEditPanel, (Component)dateTimeEditPanel.getDefaultComponent(), (String)ControlsArb.getString(0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)dateTimeEditPanel, "f1_extendeddataedit_html");
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if (!"closed".equals(propertyChangeEvent.getPropertyName()) || Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    // empty if block
                }
            }
        });
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(bl);
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            try {
                this.setValue(oraDATEFormat.format(dateTimeEditPanel.getDate()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.stopCellEditing();
        } else {
            this.cancelCellEditing();
        }
    }

    private final class DblClickListener
    extends MouseAdapter {
        private final JTable table;

        private DblClickListener(JTable jTable) {
            this.table = jTable;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                MouseListener[] mouseListenerArray = this.table.getMouseListeners();
                for (MouseListener mouseListener : this.table.getMouseListeners()) {
                    Point point = mouseEvent.getPoint();
                    mouseListener.mouseClicked(mouseEvent);
                }
            }
        }
    }
}

