/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.util.ResourceUtils;
import oracle.sql.DATE;

public class DateTimeEditPanel
extends JPanel {
    protected DateEditor dateEditor = null;
    protected JButton setTodayButton = new JButton();
    protected JButton setNullButton = new JButton();
    protected JButton setSysdateButton = new JButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected boolean _canChange = false;

    public DateTimeEditPanel(Object object, boolean bl, Connection connection) {
        this._canChange = bl;
        if (object == null || object.toString().equals("")) {
            object = new java.sql.Date(new Date().getTime());
        } else if (object instanceof DATE) {
            object = ((DATE)object).dateValue();
        } else {
            OraDATEFormat oraDATEFormat = null;
            try {
                oraDATEFormat = NLSUtils.getOraDATEFormat(connection);
                object = oraDATEFormat.parseDATE(object.toString(), new ParsePosition(0)).dateValue();
            }
            catch (Exception exception) {
                object = new java.sql.Date(new Date().getTime());
            }
        }
        this.getDateTimeEditPanel((java.sql.Date)object, bl, connection);
    }

    public void getDateTimeEditPanel(java.sql.Date date, boolean bl, Connection connection) {
        OraDATEFormat oraDATEFormat = null;
        try {
            oraDATEFormat = NLSUtils.getOraDATEFormat(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (oraDATEFormat == null) {
            return;
        }
        this.dateEditor = new DateEditor((Date)date, oraDATEFormat.getCalendar(), SimpleDateFormat.getDateTimeInstance(0, 0, oraDATEFormat.getLocale()));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.dateEditor, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.getButtonPanel(), gridBagConstraints);
    }

    protected Component getDefaultComponent() {
        return this.dateEditor;
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getSetTodayButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        return this.buttonPanel;
    }

    protected JButton getSetTodayButton() {
        ResourceUtils.resButton((AbstractButton)this.setTodayButton, (String)Translate.translate("Set To&day"));
        this.setTodayButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditPanel.this.dateEditor.setDate((Date)new java.sql.Date(new Date().getTime()));
            }
        });
        this.setTodayButton.setEnabled(this._canChange);
        return this.setTodayButton;
    }

    protected JButton getSetNullButton() {
        ResourceUtils.resButton((AbstractButton)this.setNullButton, (String)Translate.translate("Set &Null"));
        this.setNullButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditPanel.this.dateEditor.setDate(null);
            }
        });
        return this.setNullButton;
    }

    public java.sql.Date getDate() {
        return new java.sql.Date(this.dateEditor.getDate().getTime());
    }

    public boolean is_canChange() {
        return this._canChange;
    }

    public void set_canChange(boolean bl) {
        this._canChange = bl;
    }
}

