/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.dbtools.raptor.controls.celleditor.BFileEditPanel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.util.ResourceUtils;

public class BFileInsertPanel
extends JPanel {
    static final String SELECT_DIR = Translate.translate("Select Directory..");
    static final String SELECT_FILE = Translate.translate("Select File..");
    List dirList = new ArrayList();
    JLabel dirLabel = new JLabel();
    JComboBox dirCombo = new JComboBox();
    JLabel fileLabel = new JLabel();
    JComboBox fileCombo = new JComboBox();
    JButton dirButton = new JButton();
    String dir = null;
    String file = null;

    public BFileInsertPanel(List list, String string, String string2) {
        this.dir = string;
        this.file = string2;
        this.setLayout(new GridBagLayout());
        this.createGUI();
        this.addListeners();
        this.fillDirCombo(list);
    }

    private void fillDirCombo(List list) {
        this.dirList = list;
        this.dirCombo.removeAllItems();
        if (list != null) {
            for (Object e : list) {
                this.dirCombo.addItem(e);
            }
        }
        this.dirCombo.addItem(SELECT_DIR);
        this.dirCombo.setSelectedIndex(this.dirCombo.getItemCount() - 1);
        if (this.dir != null) {
            this.dirCombo.setSelectedItem(this.dir);
        }
    }

    private void fillFileCombo(String[] stringArray) {
        this.fileCombo.removeAllItems();
        if (stringArray != null) {
            for (String string : stringArray) {
                File file = new File(string);
                if (file.isDirectory()) continue;
                this.fileCombo.addItem(file.getName());
            }
        }
        this.fileCombo.addItem(SELECT_FILE);
        this.fileCombo.setSelectedIndex(this.fileCombo.getItemCount() - 1);
        if (this.file != null) {
            this.fileCombo.setSelectedItem(this.file);
        }
    }

    private void addListeners() {
        this.dirCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = itemEvent.getItem();
                if (itemEvent.getStateChange() == 1 && object != null && !object.equals(SELECT_DIR)) {
                    BFileEditPanel.DbDirectory dbDirectory = (BFileEditPanel.DbDirectory)object;
                    File file = new File(dbDirectory.getPath());
                    if (file.exists()) {
                        BFileInsertPanel.this.fillFileCombo(file.list());
                    } else {
                        BFileInsertPanel.this.fillFileCombo(new String[0]);
                    }
                }
            }
        });
        this.fileCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
            }
        });
        this.dirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }

    private void createGUI() {
        this.dirCombo.setRenderer(new MyComboBoxRenderer());
        ResourceUtils.resLabel((JLabel)this.dirLabel, (Component)this.dirCombo, (String)Translate.translate("&Directory :"));
        this.add((Component)this.dirLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.dirCombo, new GridBagConstraints(1, 0, 2, 1, 0.5, 0.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.dirButton, (String)Translate.translate("&Browse"));
        ResourceUtils.resLabel((JLabel)this.fileLabel, (Component)this.fileCombo, (String)Translate.translate("&File :"));
        this.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.fileCombo.setEditable(true);
        this.add((Component)this.fileCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
    }

    public static void main(String[] stringArray) {
        BFileInsertPanel bFileInsertPanel = new BFileInsertPanel(new ArrayList(), null, null);
        JFrame jFrame = new JFrame("Test");
        jFrame.setLayout(new GridBagLayout());
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setLayout(new GridLayout(1, 1));
        jFrame.getContentPane().add(bFileInsertPanel);
        jFrame.setSize(bFileInsertPanel.getPreferredSize());
        jFrame.setVisible(true);
    }

    public String getDir() {
        Object object = this.dirCombo.getSelectedItem();
        if (object != null && object instanceof BFileEditPanel.DbDirectory) {
            return ((BFileEditPanel.DbDirectory)object).getName();
        }
        return null;
    }

    public String getFile() {
        Object object = this.fileCombo.getSelectedItem();
        if (object != null && !object.equals(SELECT_FILE)) {
            return object.toString();
        }
        return null;
    }

    class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        MyComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
                if (-1 < n) {
                    if (object instanceof BFileEditPanel.DbDirectory) {
                        BFileEditPanel.DbDirectory dbDirectory = (BFileEditPanel.DbDirectory)object;
                        jList.setToolTipText("Owner=" + dbDirectory.getOwner() + ", Path=" + dbDirectory.getPath());
                    } else {
                        jList.setToolTipText(object.toString());
                    }
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }
}

