/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.ide.resource.ComponentArb;
import oracle.javatools.icons.OracleIcons;

public class TablePanel
extends JPanel {
    private static final long serialVersionUID = 1993181320397013205L;
    private final JButton btnEdit = new JButton();
    private final JButton btnAdd = new JButton();
    private final JButton btnRemove = new JButton();
    private final JButton btnUp = new JButton();
    private final JButton btnDown = new JButton();
    private final JScrollPane _scrollPane = new JScrollPane();
    private final JTable _table = new JTable();
    private final L _listener = new L();
    private ActionListener _editListener;
    private ActionListener _addListener;
    private ActionListener _deleteListener;
    public static int DELETE = 1;
    public static int ADD = 2;
    public static int ORDER = 4;
    public static int EDIT = 8;
    public static int DEFAULT = DELETE | ADD | ORDER | EDIT;
    private static final String EDIT_CMD = "EDIT";
    private static final String ADD_CMD = "ADD";
    private static final String REMOVE_CMD = "REMOVE";
    private static final String UP_CMD = "UP";
    private static final String DOWN_CMD = "DOWN";

    public TablePanel() {
        this(DEFAULT, null, null, null);
    }

    public TablePanel(int n, ActionListener actionListener) {
        this(DEFAULT, actionListener, null, null);
    }

    public TablePanel(int n, ActionListener actionListener, ActionListener actionListener2) {
        this(DEFAULT, actionListener, actionListener2, null);
    }

    public TablePanel(int n, ActionListener actionListener, ActionListener actionListener2, ActionListener actionListener3) {
        this._editListener = actionListener;
        this._addListener = actionListener2;
        this._deleteListener = actionListener3;
        try {
            this.jbInit(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit(int n) throws Exception {
        this.setLayout(new BorderLayout());
        this._table.setModel(new DefaultTableModel());
        Dimension dimension = new Dimension(30, 30);
        JPanel jPanel = new JPanel(new GridBagLayout());
        if ((n & EDIT) == EDIT) {
            this.btnEdit.setPreferredSize(dimension);
            this.btnEdit.setIcon(OracleIcons.getIcon((String)"edit.png"));
            this.btnEdit.setEnabled(false);
            this.btnEdit.setActionCommand(EDIT_CMD);
            if (this._editListener != null) {
                this.btnEdit.addActionListener(this._editListener);
            } else {
                this.btnEdit.addActionListener(this._listener);
            }
            jPanel.add((Component)this.btnEdit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if ((n & ADD) == ADD) {
            this.btnAdd.setPreferredSize(dimension);
            this.btnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
            this.btnAdd.setActionCommand(ADD_CMD);
            if (this._addListener != null) {
                this.btnAdd.addActionListener(this._addListener);
            } else {
                this.btnAdd.addActionListener(this._listener);
            }
            jPanel.add((Component)this.btnAdd, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if ((n & DELETE) == DELETE) {
            this.btnRemove.setPreferredSize(dimension);
            this.btnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
            this.btnRemove.setActionCommand(REMOVE_CMD);
            this.btnRemove.setEnabled(false);
            if (this._deleteListener != null) {
                this.btnRemove.addActionListener(this._deleteListener);
            } else {
                this.btnRemove.addActionListener(this._listener);
            }
            jPanel.add((Component)this.btnRemove, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        if ((n & ORDER) == ORDER) {
            this.btnUp.setPreferredSize(dimension);
            this.btnUp.setIcon(ComponentArb.getIcon((int)0));
            this.btnUp.setDisabledIcon(ComponentArb.getIcon((int)2));
            this.btnUp.setActionCommand(UP_CMD);
            this.btnUp.addActionListener(this._listener);
            this.btnUp.setEnabled(false);
            this.btnDown.setPreferredSize(dimension);
            this.btnDown.setIcon(ComponentArb.getIcon((int)1));
            this.btnDown.setDisabledIcon(ComponentArb.getIcon((int)3));
            this.btnDown.setActionCommand(DOWN_CMD);
            this.btnDown.addActionListener(this._listener);
            this.btnDown.setEnabled(false);
            jPanel.add((Component)this.btnUp, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
            jPanel.add((Component)this.btnDown, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        }
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 11, 3, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, "East");
        this._table.setSelectionMode(0);
        this._scrollPane.getViewport().add((Component)this._table, null);
        this.add((Component)this._scrollPane, "Center");
        this._table.getSelectionModel().addListSelectionListener(new L());
    }

    public void setEditListener(ActionListener actionListener) {
        this._editListener = actionListener;
    }

    public void setAddListener(ActionListener actionListener) {
        this._addListener = actionListener;
    }

    public void setDeleteListener(ActionListener actionListener) {
        this._deleteListener = actionListener;
    }

    public void addNew(int n) {
        Vector<String> vector = new Vector<String>();
        vector.add("");
        if (n > 0) {
            ((DefaultTableModel)this._table.getModel()).getDataVector().add(n, vector);
        } else {
            ((DefaultTableModel)this._table.getModel()).addRow(vector);
        }
        ((DefaultTableModel)this._table.getModel()).fireTableDataChanged();
    }

    public boolean canRemoveRow(int n) {
        return n >= 0;
    }

    public void removeParameter(int n) {
        ((DefaultTableModel)this._table.getModel()).removeRow(n);
        ((DefaultTableModel)this._table.getModel()).fireTableDataChanged();
    }

    public boolean canMoveRowUp(int n) {
        return n > 1;
    }

    public void moveUp(int n) {
        if (this.canMoveRowUp(n)) {
            Vector vector = ((DefaultTableModel)this._table.getModel()).getDataVector().get(n);
            ((DefaultTableModel)this._table.getModel()).getDataVector().remove(n);
            ((DefaultTableModel)this._table.getModel()).getDataVector().add(n - 1, vector);
            ((DefaultTableModel)this._table.getModel()).fireTableDataChanged();
        }
    }

    public boolean canMoveRowDown(int n) {
        return n >= 0 && n < ((DefaultTableModel)this._table.getModel()).getRowCount() - 1;
    }

    public void moveDown(int n) {
        if (this.canMoveRowDown(n)) {
            Vector vector = ((DefaultTableModel)this._table.getModel()).getDataVector().get(n);
            ((DefaultTableModel)this._table.getModel()).getDataVector().remove(n);
            ((DefaultTableModel)this._table.getModel()).getDataVector().add(n + 1, vector);
            this._table.setRowSelectionInterval(n, n);
            this._table.requestFocusInWindow();
            ((DefaultTableModel)this._table.getModel()).fireTableDataChanged();
        }
    }

    public JTable getTable() {
        return this._table;
    }

    public static void main(String[] stringArray) {
        System.out.println("A:" + ADD);
        System.out.println("D:" + DELETE);
        System.out.println("O:" + ORDER);
        System.out.println("Default:" + DEFAULT);
    }

    private class L
    implements ListSelectionListener,
    ActionListener {
        private L() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = TablePanel.this._table.getSelectedRow();
            this.updateButtons(n);
        }

        private void updateButtons(int n) {
            TablePanel.this.btnEdit.setEnabled(TablePanel.this._table.getSelectedRow() > -1);
            TablePanel.this.btnRemove.setEnabled(TablePanel.this.canRemoveRow(TablePanel.this._table.getSelectedRow()));
            TablePanel.this.btnUp.setEnabled(TablePanel.this.canMoveRowUp(TablePanel.this._table.getSelectedRow()));
            TablePanel.this.btnDown.setEnabled(TablePanel.this.canMoveRowDown(TablePanel.this._table.getSelectedRow()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TablePanel.this._table.getSelectedRow();
            String string = actionEvent.getActionCommand();
            if (TablePanel.ADD_CMD.equals(string)) {
                if (n >= 0) {
                    TablePanel.this.addNew(n);
                } else {
                    TablePanel.this.addNew(-1);
                }
            } else if (TablePanel.REMOVE_CMD.equals(string)) {
                TablePanel.this.removeParameter(n);
            } else if (TablePanel.UP_CMD.equals(string)) {
                TablePanel.this.moveUp(n);
            } else if (TablePanel.DOWN_CMD.equals(string)) {
                TablePanel.this.moveDown(n);
            }
        }
    }
}

