/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.utils.CMHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Node;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.Column;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Procedure;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.cm.dt.browser.RelationNode;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;

public class RaptorDnD
extends DropTargetAdapter {
    private Logger logger = Logger.getLogger(RaptorDnD.class.getName());
    private JTextComponent _target;

    public RaptorDnD() {
        this(null);
    }

    public RaptorDnD(JTextComponent jTextComponent) {
        this._target = jTextComponent;
        this.init();
    }

    private void init() {
        DropTarget dropTarget = new DropTarget(this._target, 1, this, true, null);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n = this._target.viewToModel(dropTargetDragEvent.getLocation());
        this._target.setCaretPosition(n);
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        this.drop(dropTargetDropEvent, this._target);
    }

    public boolean drop(DropTargetDropEvent dropTargetDropEvent, JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        this._target = jTextComponent;
        int n = jTextComponent.viewToModel(dropTargetDropEvent.getLocation());
        Object object = dropTargetDropEvent.getSource();
        Transferable transferable = dropTargetDropEvent.getTransferable();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        jTextComponent.setAutoscrolls(true);
        boolean bl = false;
        try {
            if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR) || transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                document.insertString(n, this.nodeDrop(transferable, n), null);
                bl = true;
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                document.insertString(n, string, null);
                bl = true;
            }
            jTextComponent.setCaretPosition(n);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return bl;
    }

    private String nodeDrop(Transferable transferable, int n) throws UnsupportedFlavorException, IOException {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        String string = null;
        if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
            arrayList.addAll((Collection<DefaultMutableTreeNode>)((TransferablesList)transferable.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR)));
        } else {
            arrayList.add((DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            Object object2 = null;
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            defaultMutableTreeNode = arrayList.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)arrayList.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)arrayList.get(i);
            object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof RelationNode) {
                stringBuilder.append(this.getRelationDrop((RelationNode)object2));
                continue;
            }
            if (object2 instanceof PlSqlBaseNode) {
                object = CMHelper.getbaseObject((Node)((PlSqlBaseNode)object2));
                if (object instanceof Procedure) {
                    stringBuilder.append(this.getProcedureDrop((Procedure)object));
                    continue;
                }
                if (!(object instanceof Function)) continue;
                stringBuilder.append(this.getFunctionDrop((Function)object));
                continue;
            }
            if (object2 instanceof ObjectNode) {
                object = (ObjectNode)object2;
                String string2 = (String)((ObjectNode)object).getProperty("TYPE");
                if (string2.equals("TABLE")) {
                    stringBuilder.append(this.getObjectNodeTable((ObjectNode)object));
                    continue;
                }
                stringBuilder.append(object2.toString() + ",");
                continue;
            }
            stringBuilder.append(object2.toString() + ",");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        if (stringBuilder.length() > 1) {
            string = stringBuilder.toString();
        }
        return string;
    }

    private String getObjectNodeTable(ObjectNode objectNode) {
        if (this._target instanceof BasicEditorPane) {
            StringBuilder stringBuilder = new StringBuilder();
            objectNode.ensureOpen();
            List<DBChildInstance> list = null;
            try {
                list = objectNode.getNodeInstance().listChildren("COLUMN");
            }
            catch (AbortException abortException) {
                return null;
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException(sQLException);
                return null;
            }
            stringBuilder.append("select ");
            if (list != null && list.size() > 0) {
                for (DBChildInstance dBChildInstance : list) {
                    stringBuilder.append(dBChildInstance.getProperty("NAME") + ",");
                }
                stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "");
            } else {
                stringBuilder.append(" * ");
            }
            stringBuilder.append(" from " + DBUtil.enquote((String)objectNode.getProperty("SCHEMA")) + "." + DBUtil.enquote(objectNode.toString()) + ";\n");
            return stringBuilder.toString();
        }
        return null;
    }

    private String getFunctionDrop(Function function) {
        StringBuilder stringBuilder = new StringBuilder("ret/*" + function.getReturnType() + "*/ := " + DBUtil.enquote(function.getSchema().getName()) + "." + DBUtil.enquote(function.getName()));
        PlSqlParameter[] plSqlParameterArray = function.getParameters();
        for (int i = 0; i < plSqlParameterArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(DBUtil.enquote(plSqlParameterArray[i].getName()) + "/*" + plSqlParameterArray[i].getDataType().getName() + "*/");
            if (i != plSqlParameterArray.length - 1) {
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    public String getRelationDrop(RelationNode relationNode) {
        StringBuilder stringBuilder = new StringBuilder("select ");
        Column[] columnArray = relationNode.getRelation().getColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            stringBuilder.append(DBUtil.enquote(columnArray[i].getName()));
            if (i == columnArray.length - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(" from " + DBUtil.enquote(relationNode.getRelation().getSchema().getName()) + "." + DBUtil.enquote(relationNode.getRelation().getName()) + ";\n");
        return stringBuilder.toString();
    }

    public String getProcedureDrop(Procedure procedure) {
        StringBuilder stringBuilder = new StringBuilder(DBUtil.enquote(procedure.getSchema().getName()) + "." + DBUtil.enquote(procedure.getName()));
        PlSqlParameter[] plSqlParameterArray = procedure.getParameters();
        for (int i = 0; i < plSqlParameterArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(DBUtil.enquote(plSqlParameterArray[i].getName()) + "/*" + plSqlParameterArray[i].getDataType().getName() + "*/");
            if (i != plSqlParameterArray.length - 1) {
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }
}

