/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.utils.SpringUtilities;

public class RadioGroupPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ButtonGroup group;
    private ArrayList<JRadioButton> buttons;
    private ArrayList<ActionListener> _listeners;
    private ActionListener _listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; RadioGroupPanel.this._listeners != null && i < RadioGroupPanel.this._listeners.size(); ++i) {
                ((ActionListener)RadioGroupPanel.this._listeners.get(i)).actionPerformed(actionEvent);
            }
        }
    };

    public RadioGroupPanel(String string) {
        super(new SpringLayout());
        this.process(string);
    }

    public void process(String string) {
        String[] stringArray = string.substring(7).split(":");
        this.group = new ButtonGroup();
        this.buttons = new ArrayList();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            ++n;
            JRadioButton jRadioButton = new JRadioButton(stringArray[i]);
            jRadioButton.addActionListener(this._listener);
            if (i == 0) {
                jRadioButton.setSelected(true);
            }
            this.group.add(jRadioButton);
            this.add(jRadioButton);
            this.buttons.add(jRadioButton);
        }
        SpringUtilities.makeCompactGrid(this, 1, n, 0, 0, 1, 1);
    }

    public void setSelectedValue(String string) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).getText().equals(string)) continue;
            this.buttons.get(i).setSelected(true);
        }
    }

    public String getSelectedValue() {
        String string = null;
        for (int i = 0; i < this.buttons.size(); ++i) {
            if (!this.buttons.get(i).isSelected()) continue;
            string = this.buttons.get(i).getText();
        }
        return string;
    }

    public void addActionListener(ActionListener actionListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(actionListener);
    }
}

