/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Color;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModelBuffer;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class EditableResultSetTable
extends ResultSetTable {
    private String _nullValue = "(null)";
    private String _where;
    private static DataEditorLogPage _logPage;
    private IActionUpdater actionUpdater = null;

    public EditableResultSetTable(IActionUpdater iActionUpdater) {
        this.actionUpdater = iActionUpdater;
        EditableResultSetCellRenderer editableResultSetCellRenderer = new EditableResultSetCellRenderer();
        try {
            this.setDefaultRenderer(Class.forName("java.lang.Object"), editableResultSetCellRenderer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(object, n, n2);
        this.actionUpdater.updateActions();
    }

    public boolean save() {
        TableModel tableModel = this.getModel();
        boolean bl = true;
        DataEditorLogPage dataEditorLogPage = this.getLogPage();
        dataEditorLogPage.log("\n\n");
        if (tableModel instanceof EditableResultSetTableModel) {
            Object object;
            if (this.isEditing() && (object = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
                object.stopCellEditing();
            }
            object = (EditableResultSetTableModel)tableModel;
            ((EditableResultSetTableModel)object).setColumnModel(this.getColumnModel());
            int n = ((EditableResultSetTableModel)object).save();
            dataEditorLogPage.show();
            dataEditorLogPage.activate();
            ArrayList arrayList = ((EditableResultSetTableModel)object).getLog();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i) == null) continue;
                dataEditorLogPage.log(arrayList.get(i) + System.getProperty("line.separator"));
            }
            dataEditorLogPage.log(System.getProperty("line.separator"));
            if (n > 0) {
                bl = false;
                if (n == 1) {
                    dataEditorLogPage.log(MessageFormat.format(ConnectionArb.getString((int)595), ((ResultSetTableModel)object).getTableName()) + System.getProperty("line.separator"));
                } else {
                    dataEditorLogPage.log(MessageFormat.format(ConnectionArb.getString((int)596), new Integer(n), ((ResultSetTableModel)object).getTableName()) + System.getProperty("line.separator"));
                }
                for (int i = 0; i < ((EditableResultSetTableModel)object).getRowCount(); ++i) {
                    if (!((EditableResultSetTableModel)object).isRowError(i)) continue;
                    dataEditorLogPage.log(MessageFormat.format(ConnectionArb.getString((int)597), new Integer(i + 1), ((EditableResultSetTableModel)object).getErrorMessage(i)));
                }
            } else {
                dataEditorLogPage.log(Translate.translate("Commit Successful") + System.getProperty("line.separator"));
            }
        }
        return bl;
    }

    public boolean rollback() {
        TableModel tableModel = this.getModel();
        boolean bl = true;
        DataEditorLogPage dataEditorLogPage = this.getLogPage();
        if (tableModel instanceof EditableResultSetTableModel) {
            Object object;
            if (this.isEditing() && (object = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
                object.stopCellEditing();
            }
            object = (EditableResultSetTableModel)tableModel;
            int n = ((EditableResultSetTableModel)object).rollback();
            dataEditorLogPage.show();
            dataEditorLogPage.activate();
            dataEditorLogPage.log(Translate.translate("Rollback Successful") + System.getProperty("line.separator"));
        }
        return bl;
    }

    public boolean isColSortable(int n) {
        return super.isColSortable(n);
    }

    public boolean deleteRow() {
        boolean bl = false;
        int n = this.getSelectedRowCount();
        if (n < 1) {
            return true;
        }
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            if (n == 1) {
                if (editableResultSetTableModel.isRowDeleted(this.getSelectedRow())) {
                    editableResultSetTableModel.markRowDeleted(this.getSelectedRow(), false);
                } else {
                    editableResultSetTableModel.markRowDeleted(this.getSelectedRow(), true);
                }
            } else {
                int n2;
                int[] nArray = this.getSelectedRows();
                for (n2 = 0; n2 < n; ++n2) {
                    if (editableResultSetTableModel.isRowDeleted(nArray[n2])) continue;
                    bl = true;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    if (!bl) {
                        editableResultSetTableModel.markRowDeleted(nArray[n2], false);
                        continue;
                    }
                    editableResultSetTableModel.markRowDeleted(nArray[n2], true);
                }
            }
            this.repaint();
        }
        return true;
    }

    public boolean insertRow() {
        return this.insertRow(null);
    }

    public boolean insertRow(ResultSetTableModelBuffer resultSetTableModelBuffer) {
        Object object;
        int n = this.getSelectedRow();
        n = n < 0 ? this.getRowCount() : ++n;
        if (this.isEditing() && (object = this.getCellEditor(this.getEditingRow(), this.getEditingColumn())) != null) {
            object.stopCellEditing();
        }
        if ((object = this.getModel()) instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)object;
            if (resultSetTableModelBuffer == null) {
                editableResultSetTableModel.addRow(n);
            } else {
                editableResultSetTableModel.addRow(n, resultSetTableModelBuffer);
            }
            this.changeSelection(n, 0, false, false);
            this.actionUpdater.updateActions();
            this.repaint();
        }
        return true;
    }

    public void setInsertOnly() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            editableResultSetTableModel.setInsertOnly();
        }
    }

    public boolean getChanged() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            return editableResultSetTableModel.getChanged();
        }
        return false;
    }

    public boolean getValid() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            return editableResultSetTableModel.getValid();
        }
        return false;
    }

    public boolean getUpdatedByAnotherUser() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            return editableResultSetTableModel.getUpdatedByAnotherUser();
        }
        return false;
    }

    public void setChanged(boolean bl) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
            editableResultSetTableModel.setChanged(bl);
        }
    }

    public void showLogPage(boolean bl) {
        if (this.getLogPage() != null) {
            if (bl) {
                this.getLogPage().show();
            } else {
                this.getLogPage().close();
            }
        }
    }

    public String getColumnDBName(int n) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)tableModel;
            return resultSetTableModel.getRawColumnName(n);
        }
        return null;
    }

    public void setOrderBy(String string) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)tableModel;
            resultSetTableModel.setOrderBy(string);
        }
    }

    public void setWhere(String string) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)tableModel;
            resultSetTableModel.setWhere(string);
            this._where = string;
        }
    }

    public String getWhereClause() {
        return this._where;
    }

    public DataEditorLogPage getLogPage() {
        if (_logPage != null) {
            return _logPage;
        }
        LogManager logManager = LogManager.getLogManager();
        if (logManager != null) {
            TableModel tableModel = this.getModel();
            if (tableModel instanceof EditableResultSetTableModel) {
                EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
                _logPage = new DataEditorLogPage(editableResultSetTableModel.getTableName());
                logManager.addPage((LogPage)_logPage);
            }
            return _logPage;
        }
        return null;
    }

    public final class DataEditorLogPage
    extends DefaultLogPage {
        public DataEditorLogPage(String string) {
            super(new ViewId("DataEditorLogPage", "Data Editor"), null, false, HIDE_FIX_SOURCE_MENU);
        }
    }

    private class EditableResultSetCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            TableModel tableModel = jTable.getModel();
            component.setFont(component.getFont().deriveFont(8));
            if (tableModel instanceof EditableResultSetTableModel) {
                EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)tableModel;
                if (editableResultSetTableModel.isRowDeleted(n) && !jTable.isRowSelected(n)) {
                    component.setForeground(Color.lightGray);
                } else if (!jTable.isRowSelected(n)) {
                    component.setForeground(Color.black);
                }
                if (editableResultSetTableModel.isRowError(n) && !jTable.isRowSelected(n)) {
                    component.setBackground(Color.red);
                } else if (!jTable.isRowSelected(n)) {
                    if (!editableResultSetTableModel.isCellEditable(n, n2 + 1)) {
                        component.setBackground(new Color(230, 230, 230));
                    } else {
                        component.setBackground(Color.white);
                    }
                }
            }
            return component;
        }
    }
}

